/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.data;

import com.threerings.getdown.Log;
import com.threerings.getdown.data.Resource;
import com.threerings.getdown.data.SysProps;
import com.threerings.getdown.data.f;
import com.threerings.getdown.util.Config;
import com.threerings.getdown.util.MessageUtil;
import com.threerings.getdown.util.ProgressObserver;
import com.threerings.getdown.util.StringUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class Digest {
    public static final int VERSION = 2;
    protected HashMap<String, String> _digests = new HashMap();
    protected String _metaDigest = "";
    protected static final String FILE_NAME = "digest";
    protected static final String FILE_SUFFIX = ".txt";

    public static String digestFile(int n2) {
        String string = n2 > 1 ? String.valueOf(n2) : "";
        return FILE_NAME + string + FILE_SUFFIX;
    }

    public static String sigAlgorithm(int n2) {
        switch (n2) {
            case 1: {
                return "SHA1withRSA";
            }
            case 2: {
                return "SHA256withRSA";
            }
        }
        throw new IllegalArgumentException("Invalid digest version " + n2);
    }

    public static void createDigest(int n2, List<Resource> list, File object) throws IOException {
        Object object2;
        Object object4 = Executors.newFixedThreadPool(SysProps.threadPoolSize());
        ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
        LinkedBlockingQueue object52 = new LinkedBlockingQueue();
        long l2 = System.currentTimeMillis();
        Object object3 = new HashSet<Resource>(list);
        for (Resource resource : list) {
            object4.execute(new f(n2, concurrentHashMap, resource, object52));
        }
        object4.shutdown();
        try {
            while (object3.size() > 0) {
                object2 = object52.poll(600L, TimeUnit.SECONDS);
                if (object2 instanceof IOException) {
                    throw (IOException)object2;
                }
                if (object2 instanceof Resource) {
                    object3.remove(object2);
                    continue;
                }
                throw new AssertionError((Object)("What is this? " + object2));
            }
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Timeout computing digests. Wow.");
        }
        object2 = new StringBuilder();
        try (FileOutputStream fileOutputStream = new FileOutputStream((File)object);
             OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8);){
            object = new PrintWriter(outputStreamWriter);
            try {
                for (Resource resource : list) {
                    object3 = resource.getPath();
                    String string = (String)concurrentHashMap.get(resource);
                    Digest.note((StringBuilder)object2, (String)object3, string);
                    ((PrintWriter)object).println((String)object3 + " = " + string);
                }
                object4 = Digest.getMessageDigest(n2);
                byte[] byArray = ((StringBuilder)object2).toString().getBytes(StandardCharsets.UTF_8);
                object3 = Digest.digestFile(n2);
                ((PrintWriter)object).println((String)object3 + " = " + StringUtil.hexlate(((MessageDigest)object4).digest(byArray)));
            }
            finally {
                ((PrintWriter)object).close();
            }
        }
        long l3 = System.currentTimeMillis() - l2;
        Log.log.debug("Computed digests [rsrcs=" + list.size() + ", time=" + l3 + "ms]", new Object[0]);
    }

    public static MessageDigest getMessageDigest(int n2) {
        String string = n2 > 1 ? "SHA-256" : "MD5";
        try {
            return MessageDigest.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("JVM does not support " + string + ". Gurp!");
        }
    }

    public Digest(File file, boolean bl) throws IOException {
        this(file, 2, bl);
    }

    public Digest(File object, int n2, boolean bl) throws IOException {
        String string = Digest.digestFile(n2);
        StringBuilder stringBuilder = new StringBuilder();
        object = new File((File)object, string);
        Config.ParseOpts parseOpts = Config.createOpts(false);
        Config.createOpts(false).strictComments = bl;
        parseOpts.biasToKey = true;
        for (String[] stringArray : Config.parsePairs((File)object, parseOpts)) {
            if (stringArray[0].equals(string)) {
                this._metaDigest = stringArray[1];
                break;
            }
            this._digests.put(stringArray[0], stringArray[1]);
            Digest.note(stringBuilder, stringArray[0], stringArray[1]);
        }
        object = Digest.getMessageDigest(n2);
        byte[] byArray = stringBuilder.toString().getBytes(StandardCharsets.UTF_8);
        if (!((String)(object = StringUtil.hexlate(((MessageDigest)object).digest(byArray)))).equals(this._metaDigest)) {
            object = MessageUtil.tcompose("m.invalid_digest_file", new String[]{this._metaDigest, object});
            throw new IOException((String)object);
        }
    }

    public String getMetaDigest() {
        return this._metaDigest;
    }

    public boolean validateResource(Resource resource, ProgressObserver object) {
        try {
            object = resource.computeDigest(2, Digest.getMessageDigest(2), (ProgressObserver)object);
            String string = this._digests.get(resource.getPath());
            if (((String)object).equals(string)) {
                return true;
            }
            Log.log.info("Resource failed digest check", "rsrc", resource, "computed", object, "expected", string);
        }
        catch (Throwable throwable) {
            Log.log.info("Resource failed digest check", "rsrc", resource, "error", throwable);
        }
        return false;
    }

    public String getDigest(Resource resource) {
        return this._digests.get(resource.getPath());
    }

    protected static void note(StringBuilder stringBuilder, String string, String string2) {
        stringBuilder.append(string).append(" = ").append(string2).append("\n");
    }
}

