/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.launcher;

import ca.beq.util.win32.registry.RegistryKey;
import ca.beq.util.win32.registry.RegistryValue;
import ca.beq.util.win32.registry.RootKey;
import com.threerings.getdown.Log;
import com.threerings.getdown.data.Application;
import com.threerings.getdown.launcher.q;
import com.threerings.getdown.net.Connector;
import com.threerings.getdown.spi.ProxyAuth;
import com.threerings.getdown.util.Config;
import com.threerings.getdown.util.LaunchUtil;
import com.threerings.getdown.util.StringUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.ServiceLoader;
import javax.script.Bindings;
import javax.script.Invocable;
import javax.script.ScriptEngineManager;

public final class ProxyUtil {
    protected static final String PROXY_REGISTRY = "Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings";

    public static boolean autoDetectProxy(Application application) {
        Object object;
        String[] stringArray = null;
        String string = null;
        if (System.getProperty("https.proxyHost") != null) {
            stringArray = System.getProperty("https.proxyHost");
            string = System.getProperty("https.proxyPort");
        }
        if (StringUtil.isBlank(stringArray) && System.getProperty("http.proxyHost") != null) {
            stringArray = System.getProperty("http.proxyHost");
            string = System.getProperty("http.proxyPort");
        }
        if (StringUtil.isBlank((String)stringArray) && LaunchUtil.isWindows()) {
            try {
                object = null;
                Object object2 = null;
                boolean bl = false;
                RegistryKey.initialize();
                Object object3 = new RegistryKey(RootKey.HKEY_CURRENT_USER, PROXY_REGISTRY);
                object3 = ((RegistryKey)object3).values();
                block2: while (object3.hasNext()) {
                    Object object4;
                    RegistryValue registryValue = (RegistryValue)object3.next();
                    if ("ProxyEnable".equals(registryValue.getName())) {
                        bl = "1".equals(registryValue.getStringValue());
                    }
                    if (registryValue.getName().equals("ProxyServer")) {
                        object4 = ProxyUtil.splitHostPort(registryValue.getStringValue());
                        object = object4[0];
                        object2 = object4[1];
                    }
                    if (!registryValue.getName().equals("AutoConfigURL")) continue;
                    object4 = registryValue.getStringValue();
                    InputStreamReader inputStreamReader = new InputStreamReader(new URL((String)object4).openStream());
                    object4 = application.getConfigResource().getRemote();
                    for (String string2 : ProxyUtil.findPACProxiesForURL(inputStreamReader, (URL)object4)) {
                        if (!string2.startsWith("PROXY ")) continue;
                        object2 = ProxyUtil.splitHostPort(string2.substring(6));
                        object = object2[0];
                        object2 = object2[1];
                        bl = true;
                        continue block2;
                    }
                }
                if (bl) {
                    stringArray = object;
                    string = object2;
                } else {
                    Log.log.info("Detected no proxy settings in the registry.", new Object[0]);
                }
            }
            catch (Throwable throwable) {
                Log.log.info("Failed to find proxy settings in Windows registry", "error", throwable);
            }
        }
        if (StringUtil.isBlank((String)stringArray)) {
            object = ProxyUtil.loadProxy(application);
            stringArray = object[0];
            string = object[1];
        }
        if (StringUtil.isBlank((String)stringArray)) {
            return false;
        }
        ProxyUtil.initProxy(application, (String)stringArray, string, null, null);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean canLoadWithoutProxy(URL uRL, int n2) {
        Log.log.info("Attempting to fetch without proxy: " + uRL, new Object[0]);
        try {
            int n3 = n2;
            URLConnection uRLConnection = Connector.DEFAULT.open(uRL, n3, n3);
            if (!(uRLConnection instanceof HttpURLConnection)) {
                return true;
            }
            uRLConnection = (HttpURLConnection)uRLConnection;
            try {
                ((HttpURLConnection)uRLConnection).setRequestMethod("HEAD");
                uRLConnection.connect();
                int n4 = ((HttpURLConnection)uRLConnection).getResponseCode();
                if (n4 != 407) {
                    if (n4 != 403) return true;
                }
                Log.log.warning("Got an 'HTTP credentials needed' response", "code", n4);
                return false;
            }
            finally {
                ((HttpURLConnection)uRLConnection).disconnect();
            }
        }
        catch (IOException iOException) {
            Log.log.info("Failed to HEAD " + uRL + ": " + iOException, new Object[0]);
            Log.log.info("We probably need a proxy, but auto-detection failed.", new Object[0]);
        }
        return false;
    }

    public static void configProxy(Application application, String string, String string2, String string3, String string4) {
        ProxyUtil.saveProxy(application, string, string2);
        if (!StringUtil.isBlank(string3) && !StringUtil.isBlank(string4)) {
            Object object = ServiceLoader.load(ProxyAuth.class);
            object = ((ServiceLoader)object).iterator();
            String string5 = application.getAppDir().getAbsolutePath();
            while (object.hasNext()) {
                ((ProxyAuth)object.next()).saveCredentials(string5, string3, string4);
            }
        }
        ProxyUtil.initProxy(application, string, string2, string3, string4);
    }

    public static String[] loadProxy(Application object) {
        if (((File)(object = ((Application)object).getLocalPath("proxy.txt"))).exists()) {
            try {
                Config config = Config.parseConfig((File)object, Config.createOpts(false));
                return new String[]{config.getString("host"), config.getString("port")};
            }
            catch (IOException iOException) {
                Log.log.warning("Failed to read '" + object + "': " + iOException, new Object[0]);
            }
        }
        return new String[]{null, null};
    }

    public static void saveProxy(Application object, String string, String string2) {
        object = ((Application)object).getLocalPath("proxy.txt");
        try (PrintStream printStream = new PrintStream(new FileOutputStream((File)object));){
            if (!StringUtil.isBlank(string)) {
                printStream.println("host = " + string);
            }
            if (!StringUtil.isBlank(string2)) {
                printStream.println("port = " + string2);
            }
        }
        catch (IOException iOException) {
            Log.log.warning("Error creating proxy file '" + object + "': " + iOException, new Object[0]);
        }
    }

    public static void initProxy(Application object, String string, String string2, String string3, String string4) {
        boolean bl;
        Object object2 = ((Application)object).getAppDir().getAbsolutePath();
        Object object3 = ServiceLoader.load(ProxyAuth.class);
        object2 = (object3 = ((ServiceLoader)object3).iterator()).hasNext() ? ((ProxyAuth)object3.next()).loadCredentials((String)object2) : null;
        if (object2 != null) {
            string3 = ((ProxyAuth.Credentials)object2).username;
            string4 = ((ProxyAuth.Credentials)object2).password;
        }
        boolean bl2 = bl = !StringUtil.isBlank(string3) && !StringUtil.isBlank(string4);
        if (StringUtil.isBlank(string)) {
            Log.log.info("Using no proxy", new Object[0]);
            ((Application)object).conn = new Connector();
        } else {
            int n2 = StringUtil.isBlank(string2) ? 80 : Integer.valueOf(string2);
            Log.log.info("Using proxy", "host", string, "port", n2, "haveCreds", bl);
            ((Application)object).conn = new Connector(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(string, n2)));
        }
        if (bl) {
            string2 = string3;
            object = string4.toCharArray();
            Authenticator.setDefault(new q(string2, (char[])object));
        }
    }

    public static String[] findPACProxiesForURL(Reader object, URL uRL) {
        try {
            Object object2 = new ScriptEngineManager();
            object2 = ((ScriptEngineManager)object2).getEngineByName("javascript");
            Object object3 = object2.createBindings();
            object3.put("resolver", (Object)new Resolver());
            object2.setBindings((Bindings)object3, 200);
            object3 = ProxyUtil.class.getResource("PacUtils.js");
            if (object3 == null) {
                Log.log.error("Unable to load PacUtils.js", new Object[0]);
                return new String[0];
            }
            object2.eval(new InputStreamReader(((URL)object3).openStream()));
            object = object2.eval((Reader)object);
            if (object2 instanceof Invocable) {
                object = new Object[]{uRL.toString(), uRL.getHost()};
                object = ((Invocable)object2).invokeFunction("FindProxyForURL", object);
            }
            object = object.toString().split(";");
            for (int i2 = 0; i2 < ((String[])object).length; ++i2) {
                object[i2] = ((String)object[i2]).trim();
            }
            return object;
        }
        catch (Exception | NoClassDefFoundError throwable) {
            Log.log.warning("Failed to resolve PAC proxy", throwable);
            return new String[0];
        }
    }

    private static String[] splitHostPort(String string) {
        int n2 = string.indexOf(":");
        if (n2 == -1) {
            return new String[]{string, null};
        }
        return new String[]{string.substring(0, n2), string.substring(n2 + 1)};
    }

    public static class Resolver {
        public String dnsResolve(String string) {
            try {
                return InetAddress.getByName(string).getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                return null;
            }
        }

        public String myIpAddress() {
            try {
                return InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                return null;
            }
        }
    }
}

