/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.net;

import com.threerings.getdown.data.SysProps;
import com.threerings.getdown.util.Base64;
import com.threerings.getdown.util.StreamUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.zip.GZIPInputStream;

public class Connector {
    public static final Connector DEFAULT = new Connector();
    public final Proxy proxy;
    public State state = State.ACTIVE;

    public Connector() {
        this(null);
    }

    public Connector(Proxy proxy) {
        if (proxy == Proxy.NO_PROXY) {
            throw new IllegalArgumentException("The passed Proxy cannot be " + Proxy.NO_PROXY + ". Use the empty constructor instead");
        }
        this.proxy = proxy;
    }

    public URLConnection open(URL object, int n2, int n3) throws IOException {
        URLConnection uRLConnection = this.proxy == null ? ((URL)object).openConnection() : ((URL)object).openConnection(this.proxy);
        if ((n2 = n2 > 0 ? n2 : SysProps.connectTimeout()) > 0) {
            uRLConnection.setConnectTimeout(n2 * 1000);
        }
        if ((n2 = n3 > 0 ? n3 : SysProps.readTimeout()) > 0) {
            uRLConnection.setReadTimeout(n2 * 1000);
        }
        if ((object = ((URL)object).getUserInfo()) != null) {
            object = URLDecoder.decode((String)object, "UTF-8");
            object = Base64.encodeToString(((String)object).getBytes(StandardCharsets.UTF_8), 0).replaceAll("\\n", "").replaceAll("\\r", "");
            uRLConnection.setRequestProperty("Authorization", "Basic " + (String)object);
        }
        return uRLConnection;
    }

    public HttpURLConnection openHttp(URL uRL, int n2, int n3) throws IOException {
        return (HttpURLConnection)this.open(uRL, n2, n3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void download(URL object, File object2) throws IOException {
        Object object3 = this.open((URL)object, 0, 0);
        ((URLConnection)object3).setUseCaches(false);
        ((URLConnection)object3).setRequestProperty("Accept-Encoding", "gzip");
        this.checkConnectOK((URLConnection)object3, "Unable to download " + object);
        object = ((URLConnection)object3).getInputStream();
        try {
            object3 = ((URLConnection)object3).getContentEncoding();
            boolean bl = "gzip".equalsIgnoreCase((String)object3);
            object3 = bl ? new GZIPInputStream((InputStream)object) : object;
            try {
                object2 = new FileOutputStream((File)object2);
                try {
                    StreamUtil.copy((InputStream)object3, object2);
                }
                finally {
                    ((FileOutputStream)object2).close();
                }
            }
            finally {
                if (object3 != null) {
                    ((InputStream)object3).close();
                }
            }
            if (object == null) return;
        }
        catch (Throwable throwable) {
            if (object == null) throw throwable;
            try {
                ((InputStream)object).close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ((InputStream)object).close();
    }

    public String fetch(URL uRL) throws IOException {
        Object object = this.open(uRL, 0, 0);
        this.checkConnectOK((URLConnection)object, "Unable to fetch " + uRL);
        int n2 = ((URLConnection)object).getContentLength();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2 > 0 ? n2 : 1024);
        object = ((URLConnection)object).getInputStream();
        try {
            StreamUtil.copy((InputStream)object, byteArrayOutputStream);
        }
        finally {
            if (object != null) {
                ((InputStream)object).close();
            }
        }
        return byteArrayOutputStream.toString(StandardCharsets.UTF_8.toString());
    }

    public void checkConnectOK(URLConnection uRLConnection, String string) throws IOException {
        int n2 = this.checkConnectStatus(uRLConnection);
        if (n2 != 200) {
            throw new IOException(string + " [code=" + n2 + "]");
        }
    }

    public int checkConnectStatus(URLConnection uRLConnection) throws IOException {
        if (!(uRLConnection instanceof HttpURLConnection)) {
            return 200;
        }
        int n2 = ((HttpURLConnection)uRLConnection).getResponseCode();
        switch (n2) {
            case 305: 
            case 403: {
                this.state = State.NEED_PROXY;
                break;
            }
            case 407: {
                this.state = State.NEED_PROXY_AUTH;
            }
        }
        return n2;
    }

    public void addProxyArgs(List<String> list) {
        if (this.proxy != null && this.proxy.type() == Proxy.Type.HTTP && this.proxy.address() instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)this.proxy.address();
            String string = inetSocketAddress.getHostString();
            int n2 = inetSocketAddress.getPort();
            list.add("-Dhttp.proxyHost=" + string);
            list.add("-Dhttp.proxyPort=" + n2);
            list.add("-Dhttps.proxyHost=" + string);
            list.add("-Dhttps.proxyPort=" + n2);
        }
    }

    public static enum State {
        ACTIVE,
        NEED_PROXY,
        NEED_PROXY_AUTH;

    }
}

