/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.tools;

import com.threerings.getdown.data.Application;
import com.threerings.getdown.data.Digest;
import com.threerings.getdown.data.EnvConfig;
import com.threerings.getdown.data.Resource;
import com.threerings.getdown.tools.JarDiff;
import com.threerings.getdown.util.FileUtil;
import com.threerings.getdown.util.StreamUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class Differ {
    public void createDiff(File file, File object, boolean bl) throws IOException {
        ArrayList<Resource> arrayList = file.getName();
        String string = ((File)object).getName();
        try {
            if (Long.parseLong((String)((Object)arrayList)) <= Long.parseLong(string)) {
                object = "New version (" + (String)((Object)arrayList) + ") must be greater than old version (" + string + ").";
                throw new IOException((String)object);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Non-numeric versions? [nvers=" + (String)((Object)arrayList) + ", overs=" + string + "].");
        }
        object = new Application(new EnvConfig((File)object));
        ((Application)object).init(false);
        arrayList = new ArrayList<Resource>();
        arrayList.addAll(((Application)object).getCodeResources());
        arrayList.addAll(((Application)object).getResources());
        Application application = new Application(new EnvConfig(file));
        application.init(false);
        Object object2 = new ArrayList<Resource>();
        object2.addAll(application.getCodeResources());
        object2.addAll(application.getResources());
        File object32 = new File(file, "patch" + string + ".dat");
        this.createPatch(object32, (List<Resource>)arrayList, (List<Resource>)object2, bl);
        for (Application.AuxGroup auxGroup : application.getAuxGroups()) {
            arrayList = new ArrayList<Resource>();
            object2 = ((Application)object).getAuxGroup(auxGroup.name);
            if (object2 != null) {
                arrayList.addAll(((Application.AuxGroup)object2).codes);
                arrayList.addAll(((Application.AuxGroup)object2).rsrcs);
            }
            object2 = new ArrayList<Resource>();
            object2.addAll(auxGroup.codes);
            object2.addAll(auxGroup.rsrcs);
            File file2 = new File(file, "patch-" + auxGroup.name + string + ".dat");
            this.createPatch(file2, (List<Resource>)arrayList, (List<Resource>)object2, bl);
        }
    }

    protected void createPatch(File file, List<Resource> list, List<Resource> iterator, boolean bl) throws IOException {
        MessageDigest messageDigest = Digest.getMessageDigest(2);
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
             ZipOutputStream zipOutputStream = new ZipOutputStream(bufferedOutputStream);){
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Resource resource = (Resource)iterator.next();
                int n2 = list.indexOf(resource);
                Comparable<Resource> comparable = n2 == -1 ? null : list.remove(n2);
                if (comparable != null) {
                    String string;
                    Object object = comparable.computeDigest(2, messageDigest, null);
                    if (((String)object).equals(string = resource.computeDigest(2, messageDigest, null))) {
                        if (!bl) continue;
                        System.out.println("Unchanged: " + resource.getPath());
                        continue;
                    }
                    if (resource.getPath().endsWith(".jar")) {
                        if (bl) {
                            System.out.println("JarDiff: " + resource.getPath());
                        }
                        comparable = this.rebuildJar(comparable.getLocal());
                        object = this.rebuildJar(resource.getLocal());
                        zipOutputStream.putNextEntry(new ZipEntry(resource.getPath() + ".patch"));
                        this.jarDiff((File)comparable, (File)object, zipOutputStream);
                        FileUtil.deleteHarder((File)comparable);
                        FileUtil.deleteHarder((File)object);
                        continue;
                    }
                }
                if (bl) {
                    System.out.println("Addition: " + resource.getPath());
                }
                zipOutputStream.putNextEntry(new ZipEntry(resource.getPath() + ".create"));
                Differ.pipe(resource.getLocal(), zipOutputStream);
            }
            for (Resource resource : list) {
                if (bl) {
                    System.out.println("Removal: " + resource.getPath());
                }
                zipOutputStream.putNextEntry(new ZipEntry(resource.getPath() + ".delete"));
            }
            System.out.println("Created patch file: " + file);
        }
        catch (IOException iOException) {
            FileUtil.deleteHarder(file);
            throw iOException;
        }
    }

    protected File rebuildJar(File object) throws IOException {
        File file = File.createTempFile("differ", "jar");
        object = new ZipFile((File)object);
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
             ZipOutputStream zipOutputStream = new ZipOutputStream(bufferedOutputStream);){
            byte[] byArray = new byte[4096];
            Enumeration<? extends ZipEntry> enumeration = ((ZipFile)object).entries();
            while (enumeration.hasMoreElements()) {
                Object object2 = enumeration.nextElement();
                ((ZipEntry)object2).setCompressedSize(-1L);
                zipOutputStream.putNextEntry((ZipEntry)object2);
                object2 = ((ZipFile)object).getInputStream((ZipEntry)object2);
                try {
                    int n2 = ((InputStream)object2).read(byArray);
                    while (n2 != -1) {
                        zipOutputStream.write(byArray, 0, n2);
                        n2 = ((InputStream)object2).read(byArray);
                    }
                }
                finally {
                    if (object2 == null) continue;
                    ((InputStream)object2).close();
                }
            }
        }
        finally {
            ((ZipFile)object).close();
        }
        return file;
    }

    protected void jarDiff(File file, File file2, ZipOutputStream zipOutputStream) throws IOException {
        JarDiff.createPatch(file.getPath(), file2.getPath(), zipOutputStream, false);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.err.println("Usage: Differ [-verbose] new_vers_dir old_vers_dir");
            System.exit(255);
        }
        Differ differ = new Differ();
        boolean bl = false;
        int n2 = 0;
        if ("-verbose".equals(stringArray[0])) {
            bl = true;
            ++n2;
        }
        try {
            differ.createDiff(new File(stringArray[n2++]), new File(stringArray[n2]), bl);
            return;
        }
        catch (IOException iOException) {
            System.err.println("Error: " + iOException.getMessage());
            System.exit(255);
            return;
        }
    }

    protected static void pipe(File object, OutputStream outputStream) throws IOException {
        object = new FileInputStream((File)object);
        try {
            StreamUtil.copy((InputStream)object, outputStream);
            return;
        }
        finally {
            ((FileInputStream)object).close();
        }
    }
}

