/*
 * Decompiled with CFR 0.152.
 */
package com.fazecast.jSerialComm.android;

import android.app.Application;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.util.Log;
import com.fazecast.jSerialComm.SerialPort;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.HashMap;

public abstract class AndroidPort {
    protected static final int USB_REQUEST_TYPE_STANDARD = 0;
    protected static final int USB_REQUEST_TYPE_CLASS = 32;
    protected static final int USB_REQUEST_TYPE_VENDOR = 64;
    protected static final int USB_REQUEST_TYPE_RESERVED = 96;
    protected static final int USB_ENDPOINT_IN = 128;
    protected static final int USB_ENDPOINT_OUT = 0;
    protected static final int USB_RECIPIENT_DEVICE = 0;
    protected static final int USB_RECIPIENT_INTERFACE = 1;
    protected static final int USB_RECIPIENT_ENDPOINT = 2;
    protected static final int USB_RECIPIENT_OTHER = 3;
    protected static Application context = null;
    protected static UsbManager usbManager = null;
    private static final String ACTION_USB_PERMISSION = "com.fazecast.jSerialComm.USB_PERMISSION";
    private static volatile boolean userPermissionGranted = false;
    private static volatile boolean awaitingUserPermission = false;
    private static PendingIntent permissionIntent = null;
    protected final UsbDevice usbDevice;
    protected UsbInterface usbInterface = null;
    protected UsbDeviceConnection usbConnection = null;
    protected UsbEndpoint usbDeviceIn = null;
    protected UsbEndpoint usbDeviceOut = null;
    protected volatile int writeBufferIndex = 0;
    protected volatile int writeBufferLength = 1024;
    protected volatile int readBufferIndex = 0;
    protected volatile int readBufferOffset = 0;
    protected volatile int readBufferLength = 1024;
    protected final byte[] readBuffer = new byte[this.readBufferLength];
    protected final byte[] writeBuffer = new byte[this.writeBufferLength];
    private static final BroadcastReceiver usbReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            UsbDevice device;
            if (intent.getAction().equals(AndroidPort.ACTION_USB_PERMISSION)) {
                Class<AndroidPort> clazz = AndroidPort.class;
                synchronized (AndroidPort.class) {
                    userPermissionGranted = intent.getBooleanExtra("permission", false);
                    awaitingUserPermission = false;
                    AndroidPort.class.notifyAll();
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                }
            } else if (intent.getAction().equals("android.hardware.usb.action.USB_DEVICE_DETACHED") && (device = (UsbDevice)intent.getParcelableExtra("device")) != null) {
                Log.i((String)"jSerialComm", (String)"Port was disconnected. Need TODO something");
            }
        }
    };

    protected AndroidPort(UsbDevice device) {
        this.usbDevice = device;
    }

    public static void setAndroidContext(Object androidContext) {
        context = (Application)Application.class.cast(androidContext);
    }

    public static SerialPort[] getCommPortsNative() {
        if (context == null) {
            throw new RuntimeException("The Android application context must be specified using 'setAndroidContext()' before making any jSerialComm library calls.");
        }
        if (!context.getPackageManager().hasSystemFeature("android.hardware.usb.host")) {
            return new SerialPort[0];
        }
        if (permissionIntent == null) {
            permissionIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)new Intent(ACTION_USB_PERMISSION), (int)0);
            IntentFilter filter = new IntentFilter(ACTION_USB_PERMISSION);
            filter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
            context.registerReceiver(usbReceiver, filter);
        }
        usbManager = (UsbManager)context.getApplicationContext().getSystemService("usb");
        HashMap deviceList = usbManager.getDeviceList();
        SerialPort[] portsList = new SerialPort[deviceList.size()];
        int i2 = 0;
        for (UsbDevice device : deviceList.values()) {
            Object androidPort = null;
            SerialPort serialPort = null;
            try {
                Constructor serialPortConstructor = SerialPort.class.getDeclaredConstructor(String.class, String.class, String.class, String.class, String.class, Integer.TYPE, Integer.TYPE);
                serialPortConstructor.setAccessible(true);
                serialPort = (SerialPort)serialPortConstructor.newInstance("COM" + (i2 + 1), device.getDeviceName(), device.getProductName(), device.getSerialNumber(), device.getSerialNumber(), device.getVendorId(), device.getProductId());
                Field privateAndroidPort = SerialPort.class.getDeclaredField("androidPort");
                privateAndroidPort.setAccessible(true);
                privateAndroidPort.set(serialPort, androidPort);
                portsList[i2++] = serialPort;
            }
            catch (Exception e2) {
                e2.printStackTrace();
                continue;
            }
            Log.i((String)"jSerialComm", (String)("System Port Name: " + serialPort.getSystemPortName()));
            Log.i((String)"jSerialComm", (String)("System Port Path: " + serialPort.getSystemPortPath()));
            Log.i((String)"jSerialComm", (String)("Descriptive Port Name: " + serialPort.getDescriptivePortName()));
            Log.i((String)"jSerialComm", (String)("Port Description: " + serialPort.getPortDescription()));
            Log.i((String)"jSerialComm", (String)("Serial Number: " + serialPort.getSerialNumber()));
            Log.i((String)"jSerialComm", (String)("Location: " + serialPort.getPortLocation()));
            Log.i((String)"jSerialComm", (String)("Vendor ID: " + serialPort.getVendorID()));
            Log.i((String)"jSerialComm", (String)("Product ID: " + serialPort.getProductID()));
        }
        return portsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public long openPortNative(SerialPort serialPort) {
        if (!usbManager.hasPermission(this.usbDevice)) {
            Class<AndroidPort> clazz = AndroidPort.class;
            // MONITORENTER : com.fazecast.jSerialComm.android.AndroidPort.class
            awaitingUserPermission = true;
            while (awaitingUserPermission) {
                usbManager.requestPermission(this.usbDevice, permissionIntent);
                try {
                    AndroidPort.class.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!userPermissionGranted) {
                // MONITOREXIT : clazz
                return 0L;
            }
            // MONITOREXIT : clazz
        }
        this.usbConnection = usbManager.openDevice(this.usbDevice);
        if (this.usbConnection == null || !this.openPort() || !this.configPort(serialPort)) {
            this.closePortNative();
        }
        if (this.usbConnection == null) return 0L;
        return 1L;
    }

    public long closePortNative() {
        if (this.usbConnection != null && this.closePort()) {
            this.usbConnection.close();
            this.usbConnection = null;
            this.usbInterface = null;
            this.usbDeviceOut = null;
            this.usbDeviceIn = null;
        }
        return this.usbConnection == null ? 0L : 1L;
    }

    protected static long makeVidPid(int vid, int pid) {
        return (long)vid << 16 & 0xFFFFFFFFFFFF0000L | (long)pid & 0xFFFFL;
    }

    public abstract boolean openPort();

    public abstract boolean closePort();

    public abstract boolean configPort(SerialPort var1);

    public abstract boolean flushRxTxBuffers();

    public abstract int waitForEvent();

    public abstract int bytesAvailable();

    public abstract int bytesAwaitingWrite();

    public abstract int readBytes(byte[] var1, long var2, long var4, int var6, int var7);

    public abstract int writeBytes(byte[] var1, long var2, long var4, int var6);

    public abstract void setEventListeningStatus(boolean var1);

    public abstract boolean setBreak();

    public abstract boolean clearBreak();

    public abstract boolean setRTS();

    public abstract boolean clearRTS();

    public abstract boolean setDTR();

    public abstract boolean clearDTR();

    public abstract boolean getCTS();

    public abstract boolean getDSR();

    public abstract boolean getDCD();

    public abstract boolean getDTR();

    public abstract boolean getRTS();

    public abstract boolean getRI();

    public abstract int getLastErrorLocation();

    public abstract int getLastErrorCode();
}

