/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.gtk.screencast;

import com.sun.glass.ui.Screen;
import com.sun.glass.ui.gtk.screencast.TokenItem;
import com.sun.glass.ui.gtk.screencast.TokenStorage;
import com.sun.javafx.geom.Rectangle;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Supplier;
import java.util.stream.IntStream;

public class ScreencastHelper {
    static final boolean SCREENCAST_DEBUG;
    private static final boolean IS_NATIVE_LOADED;
    private static final int ERROR = -1;
    private static final int DENIED = -11;
    private static final int OUT_OF_BOUNDS = -12;
    private static final int DELAY_BEFORE_SESSION_CLOSE = 2000;
    private static volatile TimerTask timerTask;
    private static final Timer timerCloseSession;

    private ScreencastHelper() {
    }

    public static boolean isAvailable() {
        return IS_NATIVE_LOADED;
    }

    private static native boolean loadPipewire(boolean var0);

    private static native int getRGBPixelsImpl(int var0, int var1, int var2, int var3, int[] var4, int[] var5, String var6);

    public static int clipRound(double d2) {
        double d3 = d2 - 0.5;
        if (d3 < -2.147483648E9) {
            return Integer.MIN_VALUE;
        }
        if (d3 > 2.147483647E9) {
            return Integer.MAX_VALUE;
        }
        return (int)Math.ceil(d3);
    }

    private static List<Rectangle> getSystemScreensBounds() {
        return Screen.getScreens().stream().map(screen -> new Rectangle(ScreencastHelper.clipRound((float)screen.getPlatformX() * screen.getPlatformScaleX()), ScreencastHelper.clipRound((float)screen.getPlatformY() * screen.getPlatformScaleY()), ScreencastHelper.clipRound((float)screen.getPlatformWidth() * screen.getPlatformScaleX()), ScreencastHelper.clipRound((float)screen.getPlatformHeight() * screen.getPlatformScaleY()))).toList();
    }

    private static synchronized native void closeSession();

    private static void timerCloseSessionRestart() {
        if (timerTask != null) {
            timerTask.cancel();
        }
        timerTask = new TimerTask(){

            @Override
            public void run() {
                ScreencastHelper.closeSession();
            }
        };
        timerCloseSession.schedule(timerTask, 2000L);
    }

    public static synchronized void getRGBPixels(int n2, int n3, int n4, int n5, int[] nArray) {
        int n6;
        if (!IS_NATIVE_LOADED) {
            return;
        }
        ScreencastHelper.timerCloseSessionRestart();
        Rectangle rectangle3 = new Rectangle(n2, n3, n4, n5);
        List<Rectangle> list = ScreencastHelper.getSystemScreensBounds().stream().filter(rectangle2 -> !rectangle3.intersection((Rectangle)rectangle2).isEmpty()).toList();
        if (SCREENCAST_DEBUG) {
            System.out.printf("// getRGBPixels in %s, affectedScreenBounds %s\n", rectangle3, list);
        }
        if (list.isEmpty()) {
            if (SCREENCAST_DEBUG) {
                System.out.println("// getRGBPixels - requested area outside of any screen");
            }
            return;
        }
        Set<TokenItem> set = TokenStorage.getTokens(list);
        int[] nArray2 = list.stream().filter(rectangle2 -> !rectangle3.intersection((Rectangle)rectangle2).isEmpty()).flatMapToInt(rectangle -> IntStream.of(rectangle.x, rectangle.y, rectangle.width, rectangle.height)).toArray();
        for (TokenItem tokenItem : set) {
            n6 = ScreencastHelper.getRGBPixelsImpl(n2, n3, n4, n5, nArray, nArray2, tokenItem.token);
            ScreencastHelper.debugReturnValue(n6);
            if (n6 < 0 && n6 != -1 && n6 != -11) continue;
            return;
        }
        n6 = ScreencastHelper.getRGBPixelsImpl(n2, n3, n4, n5, nArray, nArray2, null);
        ScreencastHelper.debugReturnValue(n6);
    }

    private static void debugReturnValue(int n2) {
        if (n2 == -11) {
            if (SCREENCAST_DEBUG) {
                System.err.println("Screen Capture in the selected area was not allowed");
            }
        } else if (n2 == -1) {
            if (SCREENCAST_DEBUG) {
                System.err.println("Screen capture failed.");
            }
        } else if (n2 == -12 && SCREENCAST_DEBUG) {
            System.err.println("Token does not provide access to requested area.");
        }
    }

    static {
        boolean bl;
        timerTask = null;
        timerCloseSession = new Timer("auto-close screencast session", true);
        SCREENCAST_DEBUG = bl = ((Supplier<Boolean>)() -> {
            String string = System.getProperty("javafx.robot.screenshotDebug", "false");
            return "true".equalsIgnoreCase(string);
        }).get().booleanValue();
        IS_NATIVE_LOADED = ScreencastHelper.loadPipewire(SCREENCAST_DEBUG);
    }
}

