/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx;

import java.util.AbstractList;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;

public class UnmodifiableArrayList<T>
extends AbstractList<T>
implements RandomAccess {
    private T[] elements;
    private final int size;

    public UnmodifiableArrayList(T[] TArray, int n2) {
        assert (TArray != null ? n2 <= TArray.length : n2 == 0);
        this.size = n2;
        this.elements = TArray;
    }

    @Override
    public T get(int n2) {
        return this.elements[n2];
    }

    @Override
    public int size() {
        return this.size;
    }

    public static <T> UnmodifiableArrayList<T> copyOfNullFiltered(List<T> list) {
        Objects.requireNonNull(list, "list cannot be null");
        int n2 = 0;
        Object[] objectArray = new Object[list.size()];
        if (list instanceof RandomAccess) {
            int n3 = list.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                T t2 = list.get(i2);
                if (t2 == null) continue;
                objectArray[n2++] = t2;
            }
        } else {
            for (T t3 : list) {
                if (t3 == null) continue;
                objectArray[n2++] = t3;
            }
        }
        return new UnmodifiableArrayList<Object>(objectArray, n2);
    }

    public static <T> UnmodifiableArrayList<T> copyOfNullFiltered(T[] TArray) {
        Objects.requireNonNull(TArray, "elements cannot be null");
        int n2 = 0;
        Object[] objectArray = new Object[TArray.length];
        for (int i2 = 0; i2 < TArray.length; ++i2) {
            if (TArray[i2] == null) continue;
            objectArray[n2++] = TArray[i2];
        }
        return new UnmodifiableArrayList<Object>(objectArray, n2);
    }
}

