/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.application.preferences;

import com.sun.javafx.application.preferences.ChangedValue;
import com.sun.javafx.application.preferences.PreferenceMapping;
import com.sun.javafx.util.Utils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javafx.application.ColorScheme;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectPropertyBase;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.scene.paint.Color;

final class PreferenceProperties {
    private final Map<String, DeferredProperty<?>> deferredProperties = new HashMap();
    private final DeferredProperty<Color> backgroundColor = new DeferredProperty<Color>("backgroundColor", Color.WHITE);
    private final DeferredProperty<Color> foregroundColor = new DeferredProperty<Color>("foregroundColor", Color.BLACK);
    private final DeferredProperty<Color> accentColor = new DeferredProperty<Color>("accentColor", Color.rgb(21, 126, 251));
    private final ColorSchemeProperty colorScheme = new ColorSchemeProperty();
    private final DeferredProperty<Boolean> reducedMotion = new DeferredProperty<Boolean>("reducedMotion", false);
    private final DeferredProperty<Boolean> reducedTransparency = new DeferredProperty<Boolean>("reducedTransparency", false);
    private final DeferredProperty<Boolean> reducedData = new DeferredProperty<Boolean>("reducedData", false);
    private final DeferredProperty<Boolean> persistentScrollBars = new DeferredProperty<Boolean>("persistentScrollBars", false);
    private final ReadOnlyBooleanWrapper reducedMotionFlag;
    private final ReadOnlyBooleanWrapper reducedTransparencyFlag;
    private final ReadOnlyBooleanWrapper reducedDataFlag;
    private final ReadOnlyBooleanWrapper persistentScrollBarsFlag;
    private final Object bean;

    PreferenceProperties(Object object) {
        this.bean = object;
        this.reducedMotionFlag = new ReadOnlyBooleanWrapper(object, this.reducedMotion.getName());
        this.reducedMotionFlag.bind((ObservableValue<? extends Boolean>)this.reducedMotion);
        this.reducedTransparencyFlag = new ReadOnlyBooleanWrapper(object, this.reducedTransparency.getName());
        this.reducedTransparencyFlag.bind((ObservableValue<? extends Boolean>)this.reducedTransparency);
        this.reducedDataFlag = new ReadOnlyBooleanWrapper(object, this.reducedData.getName());
        this.reducedDataFlag.bind((ObservableValue<? extends Boolean>)this.reducedData);
        this.persistentScrollBarsFlag = new ReadOnlyBooleanWrapper(object, this.persistentScrollBars.getName());
        this.persistentScrollBarsFlag.bind((ObservableValue<? extends Boolean>)this.persistentScrollBars);
    }

    public ReadOnlyBooleanProperty reducedMotionProperty() {
        return this.reducedMotionFlag.getReadOnlyProperty();
    }

    public boolean isReducedMotion() {
        return this.reducedMotion.get();
    }

    public void setReducedMotion(boolean bl) {
        this.reducedMotion.setValueOverride(bl);
    }

    public ReadOnlyBooleanProperty reducedTransparencyProperty() {
        return this.reducedTransparencyFlag.getReadOnlyProperty();
    }

    public boolean isReducedTransparency() {
        return this.reducedTransparency.get();
    }

    public void setReducedTransparency(boolean bl) {
        this.reducedTransparency.setValueOverride(bl);
    }

    public ReadOnlyBooleanProperty reducedDataProperty() {
        return this.reducedDataFlag.getReadOnlyProperty();
    }

    public boolean isReducedData() {
        return this.reducedData.get();
    }

    public void setReducedData(boolean bl) {
        this.reducedData.setValueOverride(bl);
    }

    public ReadOnlyBooleanProperty persistentScrollBarsProperty() {
        return this.persistentScrollBarsFlag.getReadOnlyProperty();
    }

    public boolean isPersistentScrollBars() {
        return this.persistentScrollBars.get();
    }

    public void setPersistentScrollBars(boolean bl) {
        this.persistentScrollBars.setValueOverride(bl);
    }

    public ReadOnlyObjectProperty<ColorScheme> colorSchemeProperty() {
        return this.colorScheme.getReadOnlyProperty();
    }

    public ColorScheme getColorScheme() {
        return (ColorScheme)((Object)this.colorScheme.get());
    }

    public void setColorScheme(ColorScheme colorScheme) {
        this.colorScheme.setValueOverride(colorScheme);
    }

    public ReadOnlyObjectProperty<Color> backgroundColorProperty() {
        return this.backgroundColor;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor.get();
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor.setValueOverride(color);
    }

    public ReadOnlyObjectProperty<Color> foregroundColorProperty() {
        return this.foregroundColor;
    }

    public Color getForegroundColor() {
        return this.foregroundColor.get();
    }

    public void setForegroundColor(Color color) {
        this.foregroundColor.setValueOverride(color);
    }

    public ReadOnlyObjectProperty<Color> accentColorProperty() {
        return this.accentColor;
    }

    public Color getAccentColor() {
        return this.accentColor.get();
    }

    public void setAccentColor(Color color) {
        this.accentColor.setValueOverride(color);
    }

    public void update(Map<String, ChangedValue> map, Map<String, PreferenceMapping<?, ?>> map2) {
        for (Map.Entry<String, ChangedValue> entry : map.entrySet()) {
            PreferenceMapping<?, ?> preferenceMapping;
            PreferenceMapping<?, ?> preferenceMapping2 = map2.get(entry.getKey());
            if (!(preferenceMapping2 instanceof PreferenceMapping) || !((preferenceMapping2 = this.deferredProperties.get((preferenceMapping = preferenceMapping2).keyName())) instanceof DeferredProperty)) continue;
            DeferredProperty deferredProperty = (DeferredProperty)((Object)preferenceMapping2);
            deferredProperty.setPlatformValue(preferenceMapping.map(entry.getValue().newValue()));
        }
        for (DeferredProperty deferredProperty : this.deferredProperties.values()) {
            deferredProperty.fireValueChangedIfNecessary();
        }
    }

    private final class DeferredProperty<T>
    extends ReadOnlyObjectPropertyBase<T> {
        private final String name;
        private final T defaultValue;
        private T overrideValue;
        private T platformValue;
        private T effectiveValue;
        private T lastEffectiveValue;

        DeferredProperty(String string, T t2) {
            Objects.requireNonNull(t2);
            PreferenceProperties.this.deferredProperties.put(string, this);
            this.name = string;
            this.defaultValue = t2;
            this.platformValue = t2;
            this.effectiveValue = t2;
            this.lastEffectiveValue = t2;
        }

        @Override
        public Object getBean() {
            return PreferenceProperties.this.bean;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public T get() {
            return this.effectiveValue;
        }

        public void setPlatformValue(Object object) {
            Class<?> clazz = this.defaultValue.getClass();
            this.platformValue = clazz.isInstance(object) ? object : null;
            this.updateEffectiveValue();
        }

        public void setValueOverride(T t2) {
            this.overrideValue = t2;
            this.updateEffectiveValue();
            this.fireValueChangedEvent();
        }

        public void fireValueChangedIfNecessary() {
            if (!Objects.equals(this.lastEffectiveValue, this.effectiveValue)) {
                this.lastEffectiveValue = this.effectiveValue;
                this.fireValueChangedEvent();
            }
        }

        private void updateEffectiveValue() {
            this.effectiveValue = Objects.requireNonNullElse(this.overrideValue != null ? this.overrideValue : this.platformValue, this.defaultValue);
        }
    }

    private class ColorSchemeProperty
    extends ReadOnlyObjectWrapper<ColorScheme> {
        private ColorScheme colorSchemeOverride;

        ColorSchemeProperty() {
            super(PreferenceProperties.this.bean, "colorScheme");
            InvalidationListener invalidationListener = observable -> this.update();
            PreferenceProperties.this.backgroundColor.addListener(invalidationListener);
            PreferenceProperties.this.foregroundColor.addListener(invalidationListener);
            this.update();
        }

        public void setValueOverride(ColorScheme colorScheme) {
            this.colorSchemeOverride = colorScheme;
            this.update();
        }

        private void update() {
            if (this.colorSchemeOverride != null) {
                this.set(this.colorSchemeOverride);
            } else {
                Color color = PreferenceProperties.this.backgroundColor.get();
                Color color2 = PreferenceProperties.this.foregroundColor.get();
                boolean bl = Utils.calculateBrightness(color) < Utils.calculateBrightness(color2);
                this.set(bl ? ColorScheme.DARK : ColorScheme.LIGHT);
            }
        }
    }
}

