/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.binding;

import com.sun.javafx.binding.Logging;
import java.lang.ref.WeakReference;
import java.text.Format;
import java.text.ParseException;
import java.util.Objects;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.FloatProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.util.StringConverter;

public abstract class BidirectionalBinding
implements InvalidationListener,
WeakListener {
    private final int cachedHashCode;

    private static void checkParameters(Object object, Object object2) {
        Objects.requireNonNull(object, "Both properties must be specified.");
        Objects.requireNonNull(object2, "Both properties must be specified.");
        if (object == object2) {
            throw new IllegalArgumentException("Cannot bind property to itself");
        }
    }

    public static <T> BidirectionalBinding bind(Property<T> property, Property<T> property2) {
        BidirectionalBinding.checkParameters(property, property2);
        BidirectionalBinding bidirectionalBinding = property instanceof DoubleProperty && property2 instanceof DoubleProperty ? new BidirectionalDoubleBinding((DoubleProperty)property, (DoubleProperty)property2) : (property instanceof FloatProperty && property2 instanceof FloatProperty ? new BidirectionalFloatBinding((FloatProperty)property, (FloatProperty)property2) : (property instanceof IntegerProperty && property2 instanceof IntegerProperty ? new BidirectionalIntegerBinding((IntegerProperty)property, (IntegerProperty)property2) : (property instanceof LongProperty && property2 instanceof LongProperty ? new BidirectionalLongBinding((LongProperty)property, (LongProperty)property2) : (property instanceof BooleanProperty && property2 instanceof BooleanProperty ? new BidirectionalBooleanBinding((BooleanProperty)property, (BooleanProperty)property2) : new TypedGenericBidirectionalBinding<T>(property, property2)))));
        property.setValue(property2.getValue());
        property.getValue();
        property.addListener(bidirectionalBinding);
        property2.addListener(bidirectionalBinding);
        return bidirectionalBinding;
    }

    public static Object bind(Property<String> property, Property<?> property2, Format format) {
        BidirectionalBinding.checkParameters(property, property2);
        Objects.requireNonNull(format, "Format cannot be null");
        StringFormatBidirectionalBinding stringFormatBidirectionalBinding = new StringFormatBidirectionalBinding(property, property2, format);
        property.setValue(format.format(property2.getValue()));
        property.getValue();
        property.addListener(stringFormatBidirectionalBinding);
        property2.addListener(stringFormatBidirectionalBinding);
        return stringFormatBidirectionalBinding;
    }

    public static <T> Object bind(Property<String> property, Property<T> property2, StringConverter<T> stringConverter) {
        BidirectionalBinding.checkParameters(property, property2);
        Objects.requireNonNull(stringConverter, "Converter cannot be null");
        StringConverterBidirectionalBinding<T> stringConverterBidirectionalBinding = new StringConverterBidirectionalBinding<T>(property, property2, stringConverter);
        property.setValue(stringConverter.toString(property2.getValue()));
        property.getValue();
        property.addListener(stringConverterBidirectionalBinding);
        property2.addListener(stringConverterBidirectionalBinding);
        return stringConverterBidirectionalBinding;
    }

    public static <T> void unbind(Property<T> property, Property<T> property2) {
        BidirectionalBinding.checkParameters(property, property2);
        UntypedGenericBidirectionalBinding untypedGenericBidirectionalBinding = new UntypedGenericBidirectionalBinding(property, property2);
        property.removeListener(untypedGenericBidirectionalBinding);
        property2.removeListener(untypedGenericBidirectionalBinding);
    }

    public static void unbind(Object object, Object object2) {
        BidirectionalBinding.checkParameters(object, object2);
        UntypedGenericBidirectionalBinding untypedGenericBidirectionalBinding = new UntypedGenericBidirectionalBinding(object, object2);
        if (object instanceof ObservableValue) {
            ((ObservableValue)object).removeListener(untypedGenericBidirectionalBinding);
        }
        if (object2 instanceof ObservableValue) {
            ((ObservableValue)object2).removeListener(untypedGenericBidirectionalBinding);
        }
    }

    public static BidirectionalBinding bindNumber(Property<Integer> property, IntegerProperty integerProperty) {
        return BidirectionalBinding.bindNumber(property, (Property<Number>)integerProperty);
    }

    public static BidirectionalBinding bindNumber(Property<Long> property, LongProperty longProperty) {
        return BidirectionalBinding.bindNumber(property, (Property<Number>)longProperty);
    }

    public static BidirectionalBinding bindNumber(Property<Float> property, FloatProperty floatProperty) {
        return BidirectionalBinding.bindNumber(property, (Property<Number>)floatProperty);
    }

    public static BidirectionalBinding bindNumber(Property<Double> property, DoubleProperty doubleProperty) {
        return BidirectionalBinding.bindNumber(property, (Property<Number>)doubleProperty);
    }

    public static BidirectionalBinding bindNumber(IntegerProperty integerProperty, Property<Integer> property) {
        return BidirectionalBinding.bindNumberObject(integerProperty, property);
    }

    public static BidirectionalBinding bindNumber(LongProperty longProperty, Property<Long> property) {
        return BidirectionalBinding.bindNumberObject(longProperty, property);
    }

    public static BidirectionalBinding bindNumber(FloatProperty floatProperty, Property<Float> property) {
        return BidirectionalBinding.bindNumberObject(floatProperty, property);
    }

    public static BidirectionalBinding bindNumber(DoubleProperty doubleProperty, Property<Double> property) {
        return BidirectionalBinding.bindNumberObject(doubleProperty, property);
    }

    private static <T extends Number> BidirectionalBinding bindNumberObject(Property<Number> property, Property<T> property2) {
        BidirectionalBinding.checkParameters(property, property2);
        TypedNumberBidirectionalBinding<T> typedNumberBidirectionalBinding = new TypedNumberBidirectionalBinding<T>(property2, property);
        property.setValue((Number)property2.getValue());
        property.getValue();
        property.addListener(typedNumberBidirectionalBinding);
        property2.addListener(typedNumberBidirectionalBinding);
        return typedNumberBidirectionalBinding;
    }

    private static <T extends Number> BidirectionalBinding bindNumber(Property<T> property, Property<Number> property2) {
        BidirectionalBinding.checkParameters(property, property2);
        TypedNumberBidirectionalBinding<T> typedNumberBidirectionalBinding = new TypedNumberBidirectionalBinding<T>(property, property2);
        property.setValue((Number)property2.getValue());
        property.getValue();
        property.addListener(typedNumberBidirectionalBinding);
        property2.addListener(typedNumberBidirectionalBinding);
        return typedNumberBidirectionalBinding;
    }

    private BidirectionalBinding(Object object, Object object2) {
        this.cachedHashCode = object.hashCode() * object2.hashCode();
    }

    protected abstract Object getProperty1();

    protected abstract Object getProperty2();

    public int hashCode() {
        return this.cachedHashCode;
    }

    @Override
    public boolean wasGarbageCollected() {
        return this.getProperty1() == null || this.getProperty2() == null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        Object object2 = this.getProperty1();
        Object object3 = this.getProperty2();
        if (object2 == null || object3 == null) {
            return false;
        }
        if (object instanceof BidirectionalBinding) {
            BidirectionalBinding bidirectionalBinding = (BidirectionalBinding)object;
            Object object4 = bidirectionalBinding.getProperty1();
            Object object5 = bidirectionalBinding.getProperty2();
            if (object4 == null || object5 == null) {
                return false;
            }
            if (object2 == object4 && object3 == object5) {
                return true;
            }
            if (object2 == object5 && object3 == object4) {
                return true;
            }
        }
        return false;
    }

    private static class BidirectionalDoubleBinding
    extends BidirectionalBinding {
        private final WeakReference<DoubleProperty> propertyRef1;
        private final WeakReference<DoubleProperty> propertyRef2;
        private double oldValue;
        private boolean updating = false;

        private BidirectionalDoubleBinding(DoubleProperty doubleProperty, DoubleProperty doubleProperty2) {
            super(doubleProperty, doubleProperty2);
            this.oldValue = doubleProperty.get();
            this.propertyRef1 = new WeakReference<DoubleProperty>(doubleProperty);
            this.propertyRef2 = new WeakReference<DoubleProperty>(doubleProperty2);
        }

        @Override
        protected Property<Number> getProperty1() {
            return (Property)this.propertyRef1.get();
        }

        @Override
        protected Property<Number> getProperty2() {
            return (Property)this.propertyRef2.get();
        }

        @Override
        public void invalidated(Observable observable) {
            if (!this.updating) {
                DoubleProperty doubleProperty = (DoubleProperty)this.propertyRef1.get();
                DoubleProperty doubleProperty2 = (DoubleProperty)this.propertyRef2.get();
                if (doubleProperty == null || doubleProperty2 == null) {
                    if (doubleProperty != null) {
                        doubleProperty.removeListener(this);
                    }
                    if (doubleProperty2 != null) {
                        doubleProperty2.removeListener(this);
                    }
                } else {
                    try {
                        this.updating = true;
                        if (doubleProperty == observable) {
                            double d2 = doubleProperty.get();
                            doubleProperty2.set(d2);
                            doubleProperty2.get();
                            this.oldValue = d2;
                        } else {
                            double d3 = doubleProperty2.get();
                            doubleProperty.set(d3);
                            doubleProperty.get();
                            this.oldValue = d3;
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        try {
                            if (doubleProperty == observable) {
                                doubleProperty.set(this.oldValue);
                                doubleProperty.get();
                            } else {
                                doubleProperty2.set(this.oldValue);
                                doubleProperty2.get();
                            }
                        }
                        catch (Exception exception) {
                            exception.addSuppressed(runtimeException);
                            BidirectionalDoubleBinding.unbind(doubleProperty, doubleProperty2);
                            throw new RuntimeException("Bidirectional binding failed together with an attempt to restore the source property to the previous value. Removing the bidirectional binding from properties " + String.valueOf(doubleProperty) + " and " + String.valueOf(doubleProperty2), exception);
                        }
                        throw new RuntimeException("Bidirectional binding failed, setting to the previous value", runtimeException);
                    }
                    finally {
                        this.updating = false;
                    }
                }
            }
        }
    }

    private static class BidirectionalFloatBinding
    extends BidirectionalBinding {
        private final WeakReference<FloatProperty> propertyRef1;
        private final WeakReference<FloatProperty> propertyRef2;
        private float oldValue;
        private boolean updating = false;

        private BidirectionalFloatBinding(FloatProperty floatProperty, FloatProperty floatProperty2) {
            super(floatProperty, floatProperty2);
            this.oldValue = floatProperty.get();
            this.propertyRef1 = new WeakReference<FloatProperty>(floatProperty);
            this.propertyRef2 = new WeakReference<FloatProperty>(floatProperty2);
        }

        @Override
        protected Property<Number> getProperty1() {
            return (Property)this.propertyRef1.get();
        }

        @Override
        protected Property<Number> getProperty2() {
            return (Property)this.propertyRef2.get();
        }

        @Override
        public void invalidated(Observable observable) {
            if (!this.updating) {
                FloatProperty floatProperty = (FloatProperty)this.propertyRef1.get();
                FloatProperty floatProperty2 = (FloatProperty)this.propertyRef2.get();
                if (floatProperty == null || floatProperty2 == null) {
                    if (floatProperty != null) {
                        floatProperty.removeListener(this);
                    }
                    if (floatProperty2 != null) {
                        floatProperty2.removeListener(this);
                    }
                } else {
                    try {
                        this.updating = true;
                        if (floatProperty == observable) {
                            float f2 = floatProperty.get();
                            floatProperty2.set(f2);
                            floatProperty2.get();
                            this.oldValue = f2;
                        } else {
                            float f3 = floatProperty2.get();
                            floatProperty.set(f3);
                            floatProperty.get();
                            this.oldValue = f3;
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        try {
                            if (floatProperty == observable) {
                                floatProperty.set(this.oldValue);
                                floatProperty.get();
                            } else {
                                floatProperty2.set(this.oldValue);
                                floatProperty2.get();
                            }
                        }
                        catch (Exception exception) {
                            exception.addSuppressed(runtimeException);
                            BidirectionalFloatBinding.unbind(floatProperty, floatProperty2);
                            throw new RuntimeException("Bidirectional binding failed together with an attempt to restore the source property to the previous value. Removing the bidirectional binding from properties " + String.valueOf(floatProperty) + " and " + String.valueOf(floatProperty2), exception);
                        }
                        throw new RuntimeException("Bidirectional binding failed, setting to the previous value", runtimeException);
                    }
                    finally {
                        this.updating = false;
                    }
                }
            }
        }
    }

    private static class BidirectionalIntegerBinding
    extends BidirectionalBinding {
        private final WeakReference<IntegerProperty> propertyRef1;
        private final WeakReference<IntegerProperty> propertyRef2;
        private int oldValue;
        private boolean updating = false;

        private BidirectionalIntegerBinding(IntegerProperty integerProperty, IntegerProperty integerProperty2) {
            super(integerProperty, integerProperty2);
            this.oldValue = integerProperty.get();
            this.propertyRef1 = new WeakReference<IntegerProperty>(integerProperty);
            this.propertyRef2 = new WeakReference<IntegerProperty>(integerProperty2);
        }

        @Override
        protected Property<Number> getProperty1() {
            return (Property)this.propertyRef1.get();
        }

        @Override
        protected Property<Number> getProperty2() {
            return (Property)this.propertyRef2.get();
        }

        @Override
        public void invalidated(Observable observable) {
            if (!this.updating) {
                IntegerProperty integerProperty = (IntegerProperty)this.propertyRef1.get();
                IntegerProperty integerProperty2 = (IntegerProperty)this.propertyRef2.get();
                if (integerProperty == null || integerProperty2 == null) {
                    if (integerProperty != null) {
                        integerProperty.removeListener(this);
                    }
                    if (integerProperty2 != null) {
                        integerProperty2.removeListener(this);
                    }
                } else {
                    try {
                        this.updating = true;
                        if (integerProperty == observable) {
                            int n2 = integerProperty.get();
                            integerProperty2.set(n2);
                            integerProperty2.get();
                            this.oldValue = n2;
                        } else {
                            int n3 = integerProperty2.get();
                            integerProperty.set(n3);
                            integerProperty.get();
                            this.oldValue = n3;
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        try {
                            if (integerProperty == observable) {
                                integerProperty.set(this.oldValue);
                                integerProperty.get();
                            } else {
                                integerProperty2.set(this.oldValue);
                                integerProperty2.get();
                            }
                        }
                        catch (Exception exception) {
                            exception.addSuppressed(runtimeException);
                            BidirectionalIntegerBinding.unbind(integerProperty, integerProperty2);
                            throw new RuntimeException("Bidirectional binding failed together with an attempt to restore the source property to the previous value. Removing the bidirectional binding from properties " + String.valueOf(integerProperty) + " and " + String.valueOf(integerProperty2), exception);
                        }
                        throw new RuntimeException("Bidirectional binding failed, setting to the previous value", runtimeException);
                    }
                    finally {
                        this.updating = false;
                    }
                }
            }
        }
    }

    private static class BidirectionalLongBinding
    extends BidirectionalBinding {
        private final WeakReference<LongProperty> propertyRef1;
        private final WeakReference<LongProperty> propertyRef2;
        private long oldValue;
        private boolean updating = false;

        private BidirectionalLongBinding(LongProperty longProperty, LongProperty longProperty2) {
            super(longProperty, longProperty2);
            this.oldValue = longProperty.get();
            this.propertyRef1 = new WeakReference<LongProperty>(longProperty);
            this.propertyRef2 = new WeakReference<LongProperty>(longProperty2);
        }

        @Override
        protected Property<Number> getProperty1() {
            return (Property)this.propertyRef1.get();
        }

        @Override
        protected Property<Number> getProperty2() {
            return (Property)this.propertyRef2.get();
        }

        @Override
        public void invalidated(Observable observable) {
            if (!this.updating) {
                LongProperty longProperty = (LongProperty)this.propertyRef1.get();
                LongProperty longProperty2 = (LongProperty)this.propertyRef2.get();
                if (longProperty == null || longProperty2 == null) {
                    if (longProperty != null) {
                        longProperty.removeListener(this);
                    }
                    if (longProperty2 != null) {
                        longProperty2.removeListener(this);
                    }
                } else {
                    try {
                        this.updating = true;
                        if (longProperty == observable) {
                            long l2 = longProperty.get();
                            longProperty2.set(l2);
                            longProperty2.get();
                            this.oldValue = l2;
                        } else {
                            long l3 = longProperty2.get();
                            longProperty.set(l3);
                            longProperty.get();
                            this.oldValue = l3;
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        try {
                            if (longProperty == observable) {
                                longProperty.set(this.oldValue);
                                longProperty.get();
                            } else {
                                longProperty2.set(this.oldValue);
                                longProperty2.get();
                            }
                        }
                        catch (Exception exception) {
                            exception.addSuppressed(runtimeException);
                            BidirectionalLongBinding.unbind(longProperty, longProperty2);
                            throw new RuntimeException("Bidirectional binding failed together with an attempt to restore the source property to the previous value. Removing the bidirectional binding from properties " + String.valueOf(longProperty) + " and " + String.valueOf(longProperty2), exception);
                        }
                        throw new RuntimeException("Bidirectional binding failed, setting to the previous value", runtimeException);
                    }
                    finally {
                        this.updating = false;
                    }
                }
            }
        }
    }

    private static class BidirectionalBooleanBinding
    extends BidirectionalBinding {
        private final WeakReference<BooleanProperty> propertyRef1;
        private final WeakReference<BooleanProperty> propertyRef2;
        private boolean oldValue;
        private boolean updating;

        private BidirectionalBooleanBinding(BooleanProperty booleanProperty, BooleanProperty booleanProperty2) {
            super(booleanProperty, booleanProperty2);
            this.oldValue = booleanProperty.get();
            this.propertyRef1 = new WeakReference<BooleanProperty>(booleanProperty);
            this.propertyRef2 = new WeakReference<BooleanProperty>(booleanProperty2);
        }

        @Override
        protected Property<Boolean> getProperty1() {
            return (Property)this.propertyRef1.get();
        }

        @Override
        protected Property<Boolean> getProperty2() {
            return (Property)this.propertyRef2.get();
        }

        @Override
        public void invalidated(Observable observable) {
            if (!this.updating) {
                BooleanProperty booleanProperty = (BooleanProperty)this.propertyRef1.get();
                BooleanProperty booleanProperty2 = (BooleanProperty)this.propertyRef2.get();
                if (booleanProperty == null || booleanProperty2 == null) {
                    if (booleanProperty != null) {
                        booleanProperty.removeListener(this);
                    }
                    if (booleanProperty2 != null) {
                        booleanProperty2.removeListener(this);
                    }
                } else {
                    try {
                        this.updating = true;
                        if (booleanProperty == observable) {
                            boolean bl = booleanProperty.get();
                            booleanProperty2.set(bl);
                            booleanProperty2.get();
                            this.oldValue = bl;
                        } else {
                            boolean bl = booleanProperty2.get();
                            booleanProperty.set(bl);
                            booleanProperty.get();
                            this.oldValue = bl;
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        try {
                            if (booleanProperty == observable) {
                                booleanProperty.set(this.oldValue);
                                booleanProperty.get();
                            } else {
                                booleanProperty2.set(this.oldValue);
                                booleanProperty2.get();
                            }
                        }
                        catch (Exception exception) {
                            exception.addSuppressed(runtimeException);
                            BidirectionalBooleanBinding.unbind(booleanProperty, booleanProperty2);
                            throw new RuntimeException("Bidirectional binding failed together with an attempt to restore the source property to the previous value. Removing the bidirectional binding from properties " + String.valueOf(booleanProperty) + " and " + String.valueOf(booleanProperty2), exception);
                        }
                        throw new RuntimeException("Bidirectional binding failed, setting to the previous value", runtimeException);
                    }
                    finally {
                        this.updating = false;
                    }
                }
            }
        }
    }

    private static class TypedGenericBidirectionalBinding<T>
    extends BidirectionalBinding {
        private final WeakReference<Property<T>> propertyRef1;
        private final WeakReference<Property<T>> propertyRef2;
        private T oldValue;
        private boolean updating = false;

        private TypedGenericBidirectionalBinding(Property<T> property, Property<T> property2) {
            super(property, property2);
            this.oldValue = property.getValue();
            this.propertyRef1 = new WeakReference<Property<Property<T>>>(property);
            this.propertyRef2 = new WeakReference<Property<Property<T>>>(property2);
        }

        @Override
        protected Property<T> getProperty1() {
            return (Property)this.propertyRef1.get();
        }

        @Override
        protected Property<T> getProperty2() {
            return (Property)this.propertyRef2.get();
        }

        @Override
        public void invalidated(Observable observable) {
            if (!this.updating) {
                Property property = (Property)this.propertyRef1.get();
                Property property2 = (Property)this.propertyRef2.get();
                if (property == null || property2 == null) {
                    if (property != null) {
                        property.removeListener(this);
                    }
                    if (property2 != null) {
                        property2.removeListener(this);
                    }
                } else {
                    try {
                        this.updating = true;
                        if (property == observable) {
                            Object t2 = property.getValue();
                            property2.setValue(t2);
                            property2.getValue();
                            this.oldValue = t2;
                        } else {
                            Object t3 = property2.getValue();
                            property.setValue(t3);
                            property.getValue();
                            this.oldValue = t3;
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        try {
                            if (property == observable) {
                                property.setValue(this.oldValue);
                                property.getValue();
                            } else {
                                property2.setValue(this.oldValue);
                                property2.getValue();
                            }
                        }
                        catch (Exception exception) {
                            exception.addSuppressed(runtimeException);
                            TypedGenericBidirectionalBinding.unbind(property, property2);
                            throw new RuntimeException("Bidirectional binding failed together with an attempt to restore the source property to the previous value. Removing the bidirectional binding from properties " + String.valueOf(property) + " and " + String.valueOf(property2), exception);
                        }
                        throw new RuntimeException("Bidirectional binding failed, setting to the previous value", runtimeException);
                    }
                    finally {
                        this.updating = false;
                    }
                }
            }
        }
    }

    private static class StringFormatBidirectionalBinding<T>
    extends StringConversionBidirectionalBinding<T> {
        private final Format format;

        public StringFormatBidirectionalBinding(Property<String> property, Property<T> property2, Format format) {
            super(property, property2);
            this.format = format;
        }

        @Override
        protected String toString(Object object) {
            return this.format.format(object);
        }

        @Override
        protected T fromString(String string) throws ParseException {
            return (T)this.format.parseObject(string);
        }
    }

    private static class StringConverterBidirectionalBinding<T>
    extends StringConversionBidirectionalBinding<T> {
        private final StringConverter<T> converter;

        public StringConverterBidirectionalBinding(Property<String> property, Property<T> property2, StringConverter<T> stringConverter) {
            super(property, property2);
            this.converter = stringConverter;
        }

        @Override
        protected String toString(T t2) {
            return this.converter.toString(t2);
        }

        @Override
        protected T fromString(String string) throws ParseException {
            return this.converter.fromString(string);
        }
    }

    private static class UntypedGenericBidirectionalBinding
    extends BidirectionalBinding {
        private final Object property1;
        private final Object property2;

        public UntypedGenericBidirectionalBinding(Object object, Object object2) {
            super(object, object2);
            this.property1 = object;
            this.property2 = object2;
        }

        @Override
        protected Object getProperty1() {
            return this.property1;
        }

        @Override
        protected Object getProperty2() {
            return this.property2;
        }

        @Override
        public void invalidated(Observable observable) {
            throw new RuntimeException("Should not reach here");
        }
    }

    private static class TypedNumberBidirectionalBinding<T extends Number>
    extends BidirectionalBinding {
        private final WeakReference<Property<T>> propertyRef1;
        private final WeakReference<Property<Number>> propertyRef2;
        private T oldValue;
        private boolean updating = false;

        private TypedNumberBidirectionalBinding(Property<T> property, Property<Number> property2) {
            super(property, property2);
            this.oldValue = (Number)property.getValue();
            this.propertyRef1 = new WeakReference<Property<Property<T>>>(property);
            this.propertyRef2 = new WeakReference<Property<Number>>(property2);
        }

        @Override
        protected Property<T> getProperty1() {
            return (Property)this.propertyRef1.get();
        }

        @Override
        protected Property<Number> getProperty2() {
            return (Property)this.propertyRef2.get();
        }

        @Override
        public void invalidated(Observable observable) {
            if (!this.updating) {
                Property property = (Property)this.propertyRef1.get();
                Property property2 = (Property)this.propertyRef2.get();
                if (property == null || property2 == null) {
                    if (property != null) {
                        property.removeListener(this);
                    }
                    if (property2 != null) {
                        property2.removeListener(this);
                    }
                } else {
                    try {
                        this.updating = true;
                        if (property == observable) {
                            Number number = (Number)property.getValue();
                            property2.setValue(number);
                            property2.getValue();
                            this.oldValue = number;
                        } else {
                            Number number = (Number)property2.getValue();
                            property.setValue(number);
                            property.getValue();
                            this.oldValue = number;
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        try {
                            if (property == observable) {
                                property.setValue(this.oldValue);
                                property.getValue();
                            } else {
                                property2.setValue(this.oldValue);
                                property2.getValue();
                            }
                        }
                        catch (Exception exception) {
                            exception.addSuppressed(runtimeException);
                            TypedNumberBidirectionalBinding.unbind((Object)property, (Object)property2);
                            throw new RuntimeException("Bidirectional binding failed together with an attempt to restore the source property to the previous value. Removing the bidirectional binding from properties " + String.valueOf(property) + " and " + String.valueOf(property2), exception);
                        }
                        throw new RuntimeException("Bidirectional binding failed, setting to the previous value", runtimeException);
                    }
                    finally {
                        this.updating = false;
                    }
                }
            }
        }
    }

    public static abstract class StringConversionBidirectionalBinding<T>
    extends BidirectionalBinding {
        private final WeakReference<Property<String>> stringPropertyRef;
        private final WeakReference<Property<T>> otherPropertyRef;
        private boolean updating;

        public StringConversionBidirectionalBinding(Property<String> property, Property<T> property2) {
            super(property, property2);
            this.stringPropertyRef = new WeakReference<Property<String>>(property);
            this.otherPropertyRef = new WeakReference<Property<Property<T>>>(property2);
        }

        protected abstract String toString(T var1);

        protected abstract T fromString(String var1) throws ParseException;

        @Override
        protected Object getProperty1() {
            return this.stringPropertyRef.get();
        }

        @Override
        protected Object getProperty2() {
            return this.otherPropertyRef.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invalidated(Observable observable) {
            if (!this.updating) {
                Property property = (Property)this.stringPropertyRef.get();
                Property property2 = (Property)this.otherPropertyRef.get();
                if (property == null || property2 == null) {
                    if (property != null) {
                        property.removeListener(this);
                    }
                    if (property2 != null) {
                        property2.removeListener(this);
                    }
                } else {
                    try {
                        this.updating = true;
                        if (property == observable) {
                            try {
                                property2.setValue(this.fromString((String)property.getValue()));
                                property2.getValue();
                            }
                            catch (Exception exception) {
                                Logging.getLogger().warning("Exception while parsing String in bidirectional binding", exception);
                                property2.setValue(null);
                                property2.getValue();
                            }
                        } else {
                            try {
                                property.setValue(this.toString(property2.getValue()));
                                property.getValue();
                            }
                            catch (Exception exception) {
                                Logging.getLogger().warning("Exception while converting Object to String in bidirectional binding", exception);
                                property.setValue("");
                                property.getValue();
                            }
                        }
                    }
                    finally {
                        this.updating = false;
                    }
                }
            }
        }
    }
}

