/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.collections;

import com.sun.javafx.collections.ElementObserver;
import com.sun.javafx.collections.NonIterableChange;
import com.sun.javafx.collections.SortHelper;
import com.sun.javafx.collections.SortableList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.collections.ModifiableObservableListBase;
import javafx.util.Callback;

public class ObservableSequentialListWrapper<E>
extends ModifiableObservableListBase<E>
implements SortableList<E> {
    private final List<E> backingList;
    private final ElementObserver<E> elementObserver;
    private SortHelper helper;

    public ObservableSequentialListWrapper(List<E> list) {
        this.backingList = list;
        this.elementObserver = null;
    }

    public ObservableSequentialListWrapper(List<E> list, Callback<E, Observable[]> callback) {
        this.backingList = list;
        this.elementObserver = new ElementObserver<E>(callback, new Callback<E, InvalidationListener>(){

            @Override
            public InvalidationListener call(final E e2) {
                return new InvalidationListener(){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    @Override
                    public void invalidated(Observable observable) {
                        this.this$1.ObservableSequentialListWrapper.this.beginChange();
                        int n2 = 0;
                        Iterator iterator = this.this$1.ObservableSequentialListWrapper.this.backingList.iterator();
                        while (iterator.hasNext()) {
                            if (iterator.next() == e2) {
                                this.this$1.ObservableSequentialListWrapper.this.nextUpdate(n2);
                            }
                            ++n2;
                        }
                        this.this$1.ObservableSequentialListWrapper.this.endChange();
                    }
                };
            }
        }, this);
        for (E e2 : this.backingList) {
            this.elementObserver.attachListener(e2);
        }
    }

    @Override
    public boolean contains(Object object) {
        return this.backingList.contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.backingList.containsAll(collection);
    }

    @Override
    public int indexOf(Object object) {
        return this.backingList.indexOf(object);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.backingList.lastIndexOf(object);
    }

    @Override
    public ListIterator<E> listIterator(final int n2) {
        return new ListIterator<E>(this){
            private final ListIterator<E> backingIt;
            private E lastReturned;
            final /* synthetic */ ObservableSequentialListWrapper this$0;
            {
                this.this$0 = observableSequentialListWrapper;
                this.backingIt = this.this$0.backingList.listIterator(n2);
            }

            @Override
            public boolean hasNext() {
                return this.backingIt.hasNext();
            }

            @Override
            public E next() {
                this.lastReturned = this.backingIt.next();
                return this.lastReturned;
            }

            @Override
            public boolean hasPrevious() {
                return this.backingIt.hasPrevious();
            }

            @Override
            public E previous() {
                this.lastReturned = this.backingIt.previous();
                return this.lastReturned;
            }

            @Override
            public int nextIndex() {
                return this.backingIt.nextIndex();
            }

            @Override
            public int previousIndex() {
                return this.backingIt.previousIndex();
            }

            @Override
            public void remove() {
                this.this$0.beginChange();
                int n22 = this.previousIndex();
                this.backingIt.remove();
                this.this$0.nextRemove(n22, this.lastReturned);
                this.this$0.endChange();
            }

            @Override
            public void set(E e2) {
                this.this$0.beginChange();
                int n22 = this.previousIndex();
                this.backingIt.set(e2);
                this.this$0.nextSet(n22, this.lastReturned);
                this.this$0.endChange();
            }

            @Override
            public void add(E e2) {
                this.this$0.beginChange();
                int n22 = this.nextIndex();
                this.backingIt.add(e2);
                this.this$0.nextAdd(n22, n22 + 1);
                this.this$0.endChange();
            }
        };
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public E get(int n2) {
        try {
            return this.backingList.listIterator(n2).next();
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IndexOutOfBoundsException("Index: " + n2);
        }
    }

    @Override
    public boolean addAll(int n2, Collection<? extends E> collection) {
        if (n2 < 0 || n2 > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + n2);
        }
        if (collection.isEmpty()) {
            return false;
        }
        try {
            this.beginChange();
            boolean bl = false;
            ListIterator<E> listIterator = this.listIterator(n2);
            Iterator<E> iterator = collection.iterator();
            while (iterator.hasNext()) {
                listIterator.add(iterator.next());
                bl = true;
            }
            this.endChange();
            return bl;
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IndexOutOfBoundsException("Index: " + n2);
        }
    }

    @Override
    public int size() {
        return this.backingList.size();
    }

    @Override
    protected void doAdd(int n2, E e2) {
        try {
            this.backingList.listIterator(n2).add(e2);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IndexOutOfBoundsException("Index: " + n2);
        }
    }

    @Override
    protected E doSet(int n2, E e2) {
        try {
            ListIterator<E> listIterator = this.backingList.listIterator(n2);
            E e3 = listIterator.next();
            listIterator.set(e2);
            return e3;
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IndexOutOfBoundsException("Index: " + n2);
        }
    }

    @Override
    protected E doRemove(int n2) {
        try {
            ListIterator<E> listIterator = this.backingList.listIterator(n2);
            E e2 = listIterator.next();
            listIterator.remove();
            return e2;
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IndexOutOfBoundsException("Index: " + n2);
        }
    }

    @Override
    public void doSort(Comparator<? super E> comparator) {
        int[] nArray = this.getSortHelper().sort(this.backingList, comparator);
        this.fireChange(new NonIterableChange.SimplePermutationChange(0, this.size(), nArray, this));
    }

    private SortHelper getSortHelper() {
        if (this.helper == null) {
            this.helper = new SortHelper();
        }
        return this.helper;
    }
}

