/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.collections;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;

public class SortHelper {
    private int[] permutation;
    private int[] reversePermutation;
    private static final int INSERTIONSORT_THRESHOLD = 7;

    public <T> int[] sort(List<T> list, Comparator<? super T> comparator) {
        Object[] objectArray = list.toArray();
        int[] nArray = this.sort(objectArray, comparator);
        ListIterator<T> listIterator = list.listIterator();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            listIterator.next();
            listIterator.set(objectArray[i2]);
        }
        return nArray;
    }

    private <T> int[] sort(T[] TArray, Comparator<? super T> comparator) {
        Object[] objectArray = (Object[])TArray.clone();
        int[] nArray = this.initPermutation(TArray.length);
        this.mergeSort(objectArray, TArray, 0, TArray.length, 0, comparator);
        this.reversePermutation = null;
        this.permutation = null;
        return nArray;
    }

    public <T> int[] sort(T[] TArray, int n2, int n3, Comparator<? super T> comparator) {
        SortHelper.rangeCheck(TArray.length, n2, n3);
        T[] TArray2 = SortHelper.copyOfRange(TArray, n2, n3);
        int[] nArray = this.initPermutation(TArray.length);
        this.mergeSort(TArray2, TArray, n2, n3, -n2, comparator);
        this.reversePermutation = null;
        this.permutation = null;
        return Arrays.copyOfRange(nArray, n2, n3);
    }

    public int[] sort(int[] nArray, int n2, int n3) {
        SortHelper.rangeCheck(nArray.length, n2, n3);
        int[] nArray2 = SortHelper.copyOfRange(nArray, n2, n3);
        int[] nArray3 = this.initPermutation(nArray.length);
        this.mergeSort(nArray2, nArray, n2, n3, -n2);
        this.reversePermutation = null;
        this.permutation = null;
        return Arrays.copyOfRange(nArray3, n2, n3);
    }

    private static void rangeCheck(int n2, int n3, int n4) {
        if (n3 > n4) {
            throw new IllegalArgumentException("fromIndex(" + n3 + ") > toIndex(" + n4 + ")");
        }
        if (n3 < 0) {
            throw new ArrayIndexOutOfBoundsException(n3);
        }
        if (n4 > n2) {
            throw new ArrayIndexOutOfBoundsException(n4);
        }
    }

    private static int[] copyOfRange(int[] nArray, int n2, int n3) {
        int n4 = n3 - n2;
        if (n4 < 0) {
            throw new IllegalArgumentException(n2 + " > " + n3);
        }
        int[] nArray2 = new int[n4];
        System.arraycopy(nArray, n2, nArray2, 0, Math.min(nArray.length - n2, n4));
        return nArray2;
    }

    private static <T> T[] copyOfRange(T[] TArray, int n2, int n3) {
        return SortHelper.copyOfRange(TArray, n2, n3, TArray.getClass());
    }

    private static <T, U> T[] copyOfRange(U[] UArray, int n2, int n3, Class<? extends T[]> clazz) {
        int n4 = n3 - n2;
        if (n4 < 0) {
            throw new IllegalArgumentException(n2 + " > " + n3);
        }
        Object[] objectArray = clazz == Object[].class ? new Object[n4] : (Object[])Array.newInstance(clazz.getComponentType(), n4);
        System.arraycopy(UArray, n2, objectArray, 0, Math.min(UArray.length - n2, n4));
        return objectArray;
    }

    private void mergeSort(int[] nArray, int[] nArray2, int n2, int n3, int n4) {
        int n5;
        int n6 = n3 - n2;
        if (n6 < 7) {
            for (int i2 = n2; i2 < n3; ++i2) {
                for (int i3 = i2; i3 > n2 && Integer.compare(nArray2[i3 - 1], nArray2[i3]) > 0; --i3) {
                    this.swap(nArray2, i3, i3 - 1);
                }
            }
            return;
        }
        int n7 = n2;
        int n8 = n3;
        int n9 = (n2 += n4) + (n3 += n4) >>> 1;
        this.mergeSort(nArray2, nArray, n2, n9, -n4);
        this.mergeSort(nArray2, nArray, n9, n3, -n4);
        if (Integer.compare(nArray[n9 - 1], nArray[n9]) <= 0) {
            System.arraycopy(nArray, n2, nArray2, n7, n6);
            return;
        }
        int n10 = n2;
        int n11 = n9;
        for (n5 = n7; n5 < n8; ++n5) {
            if (n11 >= n3 || n10 < n9 && Integer.compare(nArray[n10], nArray[n11]) <= 0) {
                nArray2[n5] = nArray[n10];
                this.permutation[this.reversePermutation[n10++]] = n5;
                continue;
            }
            nArray2[n5] = nArray[n11];
            this.permutation[this.reversePermutation[n11++]] = n5;
        }
        for (n5 = n7; n5 < n8; ++n5) {
            this.reversePermutation[this.permutation[n5]] = n5;
        }
    }

    private <T> void mergeSort(T[] TArray, T[] TArray2, int n2, int n3, int n4, Comparator<? super T> comparator) {
        int n5;
        int n6 = n3 - n2;
        if (n6 < 7) {
            for (int i2 = n2; i2 < n3; ++i2) {
                for (int i3 = i2; i3 > n2 && comparator.compare(TArray2[i3 - 1], TArray2[i3]) > 0; --i3) {
                    this.swap(TArray2, i3, i3 - 1);
                }
            }
            return;
        }
        int n7 = n2;
        int n8 = n3;
        int n9 = (n2 += n4) + (n3 += n4) >>> 1;
        this.mergeSort(TArray2, TArray, n2, n9, -n4, comparator);
        this.mergeSort(TArray2, TArray, n9, n3, -n4, comparator);
        if (comparator.compare(TArray[n9 - 1], TArray[n9]) <= 0) {
            System.arraycopy(TArray, n2, TArray2, n7, n6);
            return;
        }
        int n10 = n2;
        int n11 = n9;
        for (n5 = n7; n5 < n8; ++n5) {
            if (n11 >= n3 || n10 < n9 && comparator.compare(TArray[n10], TArray[n11]) <= 0) {
                TArray2[n5] = TArray[n10];
                this.permutation[this.reversePermutation[n10++]] = n5;
                continue;
            }
            TArray2[n5] = TArray[n11];
            this.permutation[this.reversePermutation[n11++]] = n5;
        }
        for (n5 = n7; n5 < n8; ++n5) {
            this.reversePermutation[this.permutation[n5]] = n5;
        }
    }

    private void swap(int[] nArray, int n2, int n3) {
        int n4 = nArray[n2];
        nArray[n2] = nArray[n3];
        nArray[n3] = n4;
        this.permutation[this.reversePermutation[n2]] = n3;
        this.permutation[this.reversePermutation[n3]] = n2;
        int n5 = this.reversePermutation[n2];
        this.reversePermutation[n2] = this.reversePermutation[n3];
        this.reversePermutation[n3] = n5;
    }

    private void swap(Object[] objectArray, int n2, int n3) {
        Object object = objectArray[n2];
        objectArray[n2] = objectArray[n3];
        objectArray[n3] = object;
        this.permutation[this.reversePermutation[n2]] = n3;
        this.permutation[this.reversePermutation[n3]] = n2;
        int n4 = this.reversePermutation[n2];
        this.reversePermutation[n2] = this.reversePermutation[n3];
        this.reversePermutation[n3] = n4;
    }

    private int[] initPermutation(int n2) {
        this.permutation = new int[n2];
        this.reversePermutation = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.permutation[i2] = this.reversePermutation[i2] = i2;
        }
        return this.permutation;
    }
}

