/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css;

import com.sun.javafx.css.Combinator;
import com.sun.javafx.css.PseudoClassState;
import com.sun.javafx.css.SimpleSelector;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.collections.ObservableSet;
import javafx.css.PseudoClass;
import javafx.css.Selector;
import javafx.css.Styleable;

public final class CompoundSelector
extends Selector {
    private final List<SimpleSelector> selectors;
    private final List<Combinator> relationships;
    private int hash = -1;

    public List<SimpleSelector> getSelectors() {
        return this.selectors;
    }

    List<Combinator> getRelationships() {
        return this.relationships;
    }

    public CompoundSelector(List<SimpleSelector> list, List<Combinator> list2) {
        this.selectors = list != null ? Collections.unmodifiableList(list) : Collections.EMPTY_LIST;
        this.relationships = list2 != null ? Collections.unmodifiableList(list2) : Collections.EMPTY_LIST;
    }

    @Override
    public Set<String> getStyleClassNames() {
        return this.selectors.stream().map(Selector::getStyleClassNames).flatMap(Collection::stream).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public boolean applies(Styleable styleable) {
        return this.applies(styleable, this.selectors.size() - 1, null, 0);
    }

    @Override
    public boolean applies(Styleable styleable, Set<PseudoClass>[] setArray, int n2) {
        assert (setArray == null || n2 < setArray.length);
        if (setArray != null && setArray.length <= n2) {
            return false;
        }
        PseudoClassState[] pseudoClassStateArray = setArray != null ? new PseudoClassState[setArray.length] : null;
        boolean bl = this.applies(styleable, this.selectors.size() - 1, pseudoClassStateArray, n2);
        if (bl && pseudoClassStateArray != null) {
            for (int i2 = 0; i2 < setArray.length; ++i2) {
                Set<PseudoClass> set = setArray[i2];
                PseudoClassState pseudoClassState = pseudoClassStateArray[i2];
                if (set != null) {
                    if (pseudoClassState == null) continue;
                    set.addAll(pseudoClassState);
                    continue;
                }
                setArray[i2] = pseudoClassState;
            }
        }
        return bl;
    }

    private boolean applies(Styleable styleable, int n2, Set<PseudoClass>[] setArray, int n3) {
        if (n2 < 0) {
            return false;
        }
        if (!this.selectors.get(n2).applies(styleable, setArray, n3)) {
            return false;
        }
        if (n2 == 0) {
            return true;
        }
        Combinator combinator = this.relationships.get(n2 - 1);
        if (combinator == Combinator.CHILD) {
            Styleable styleable2 = styleable.getStyleableParent();
            if (styleable2 == null) {
                return false;
            }
            return this.applies(styleable2, n2 - 1, setArray, ++n3);
        }
        for (Styleable styleable3 = styleable.getStyleableParent(); styleable3 != null; styleable3 = styleable3.getStyleableParent()) {
            boolean bl;
            if (!(bl = this.applies(styleable3, n2 - 1, setArray, ++n3))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean stateMatches(Styleable styleable, Set<PseudoClass> set) {
        return this.stateMatches(styleable, set, this.selectors.size() - 1);
    }

    private boolean stateMatches(Styleable styleable, Set<PseudoClass> set, int n2) {
        if (n2 < 0) {
            return false;
        }
        if (!this.selectors.get(n2).stateMatches(styleable, set)) {
            return false;
        }
        if (n2 == 0) {
            return true;
        }
        Combinator combinator = this.relationships.get(n2 - 1);
        if (combinator == Combinator.CHILD) {
            Styleable styleable2 = styleable.getStyleableParent();
            if (styleable2 == null) {
                return false;
            }
            if (this.selectors.get(n2 - 1).applies(styleable2)) {
                ObservableSet<PseudoClass> observableSet = styleable2.getPseudoClassStates();
                return this.stateMatches(styleable2, observableSet, n2 - 1);
            }
        } else {
            for (Styleable styleable3 = styleable.getStyleableParent(); styleable3 != null; styleable3 = styleable3.getStyleableParent()) {
                if (!this.selectors.get(n2 - 1).applies(styleable3)) continue;
                ObservableSet<PseudoClass> observableSet = styleable3.getPseudoClassStates();
                return this.stateMatches(styleable3, observableSet, n2 - 1);
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.hash == -1) {
            int n2;
            int n3 = this.selectors.size();
            for (n2 = 0; n2 < n3; ++n2) {
                this.hash = 31 * (this.hash + this.selectors.get(n2).hashCode());
            }
            n3 = this.relationships.size();
            for (n2 = 0; n2 < n3; ++n2) {
                this.hash = 31 * (this.hash + this.relationships.get(n2).hashCode());
            }
        }
        return this.hash;
    }

    public boolean equals(Object object) {
        int n2;
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CompoundSelector compoundSelector = (CompoundSelector)object;
        if (compoundSelector.selectors.size() != this.selectors.size()) {
            return false;
        }
        int n3 = this.selectors.size();
        for (n2 = 0; n2 < n3; ++n2) {
            if (compoundSelector.selectors.get(n2).equals(this.selectors.get(n2))) continue;
            return false;
        }
        if (compoundSelector.relationships.size() != this.relationships.size()) {
            return false;
        }
        n3 = this.relationships.size();
        for (n2 = 0; n2 < n3; ++n2) {
            if (compoundSelector.relationships.get(n2).equals((Object)this.relationships.get(n2))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.selectors.get(0));
        for (int i2 = 1; i2 < this.selectors.size(); ++i2) {
            stringBuilder.append((Object)this.relationships.get(i2 - 1));
            stringBuilder.append(this.selectors.get(i2));
        }
        return stringBuilder.toString();
    }
}

