/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;

public abstract sealed class FixedCapacitySet<T>
extends AbstractSet<T> {
    private static final FixedCapacitySet<?> EMPTY = new Single();
    private boolean frozen;

    private static <T> FixedCapacitySet<T> empty() {
        return EMPTY;
    }

    public static <T> FixedCapacitySet<T> of(int n2) {
        return n2 == 0 ? FixedCapacitySet.empty() : (n2 == 1 ? new Single() : (n2 == 2 ? new Duo() : (n2 < 10 ? new Hashless(n2) : new OpenAddressed(n2))));
    }

    public abstract boolean isSuperSetOf(Collection<?> var1);

    public final void freeze() {
        this.frozen = true;
    }

    protected final void ensureNotFrozen() {
        if (this.frozen) {
            throw new UnsupportedOperationException();
        }
    }

    static {
        EMPTY.freeze();
    }

    private static final class Single<T>
    extends FixedCapacitySet<T> {
        private T element;

        private Single() {
        }

        @Override
        public int size() {
            return this.element == null ? 0 : 1;
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                private boolean hasNext;
                {
                    this.hasNext = element != null;
                }

                @Override
                public boolean hasNext() {
                    return this.hasNext;
                }

                @Override
                public T next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.hasNext = false;
                    return element;
                }
            };
        }

        @Override
        public boolean isSuperSetOf(Collection<?> collection) {
            return this.element == null || collection.contains(this.element);
        }

        @Override
        public boolean contains(Object object) {
            return this.element != null && this.element.equals(object);
        }

        @Override
        public boolean add(T t2) {
            this.ensureNotFrozen();
            if (this.contains(Objects.requireNonNull(t2, "e"))) {
                return false;
            }
            if (this.element != null) {
                throw new IllegalStateException("set is full");
            }
            this.element = t2;
            return true;
        }

        @Override
        public int hashCode() {
            return this.element == null ? 0 : this.element.hashCode();
        }
    }

    private static final class Duo<T>
    extends FixedCapacitySet<T> {
        private T element1;
        private T element2;
        private int size;

        private Duo() {
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                private int index;

                @Override
                public boolean hasNext() {
                    return this.index < size;
                }

                @Override
                public T next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return this.index++ == 0 ? element1 : element2;
                }
            };
        }

        @Override
        public boolean isSuperSetOf(Collection<?> collection) {
            return this.element1 == null || collection.contains(this.element1) && (this.element2 == null || collection.contains(this.element2));
        }

        @Override
        public boolean contains(Object object) {
            return this.element1 != null && this.element1.equals(object) || this.element2 != null && this.element2.equals(object);
        }

        @Override
        public boolean add(T t2) {
            this.ensureNotFrozen();
            if (this.contains(Objects.requireNonNull(t2, "e"))) {
                return false;
            }
            if (this.size == 2) {
                throw new IllegalStateException("set is full");
            }
            if (this.size == 0) {
                this.element1 = t2;
            } else {
                this.element2 = t2;
            }
            ++this.size;
            return true;
        }

        @Override
        public int hashCode() {
            return this.element1 == null ? 0 : this.element1.hashCode() + (this.element2 == null ? 0 : this.element2.hashCode());
        }
    }

    private static final class Hashless<T>
    extends FixedCapacitySet<T> {
        private final T[] elements;
        private int size;

        private Hashless(int n2) {
            this.elements = new Object[n2];
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                private int index;

                @Override
                public boolean hasNext() {
                    return this.index < size;
                }

                @Override
                public T next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return elements[this.index++];
                }
            };
        }

        @Override
        public boolean contains(Object object) {
            for (int i2 = 0; i2 < this.size; ++i2) {
                if (!this.elements[i2].equals(object)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isSuperSetOf(Collection<?> collection) {
            for (int i2 = 0; i2 < this.size; ++i2) {
                if (collection.contains(this.elements[i2])) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean add(T t2) {
            this.ensureNotFrozen();
            if (this.contains(Objects.requireNonNull(t2, "e"))) {
                return false;
            }
            if (this.size == this.elements.length) {
                throw new IllegalStateException("set is full");
            }
            this.elements[this.size++] = t2;
            return true;
        }

        @Override
        public int hashCode() {
            int n2 = 0;
            for (int i2 = 0; i2 < this.size; ++i2) {
                n2 += this.elements[i2].hashCode();
            }
            return n2;
        }
    }

    private static final class OpenAddressed<T>
    extends FixedCapacitySet<T> {
        private final T[] elements;
        private final int requestedCapacity;
        private final int mask;
        private int size;

        private OpenAddressed(int n2) {
            this.requestedCapacity = n2;
            int n3 = 32 - Integer.numberOfLeadingZeros(n2 * 2 - n2 / 2);
            this.elements = new Object[1 << n3];
            this.mask = (1 << n3) - 1;
            assert (this.elements.length > this.requestedCapacity) : "must have more buckets than capacity";
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                private int index = this.findFilledBucket(0);

                private int findFilledBucket(int n2) {
                    for (int i2 = n2; i2 < elements.length; ++i2) {
                        if (elements[i2] == null) continue;
                        return i2;
                    }
                    return -1;
                }

                @Override
                public boolean hasNext() {
                    return this.index >= 0;
                }

                @Override
                public T next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Object t2 = elements[this.index];
                    this.index = this.findFilledBucket(this.index + 1);
                    return t2;
                }
            };
        }

        @Override
        public boolean contains(Object object) {
            int n2 = this.determineBucketIndex(object);
            while (this.elements[n2] != null) {
                if (this.elements[n2].equals(object)) {
                    return true;
                }
                if (++n2 < this.elements.length) continue;
                n2 = 0;
            }
            return false;
        }

        @Override
        public boolean isSuperSetOf(Collection<?> collection) {
            for (int i2 = 0; i2 < this.elements.length; ++i2) {
                T t2 = this.elements[i2];
                if (t2 == null || collection.contains(t2)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean add(T t2) {
            this.ensureNotFrozen();
            int n2 = this.determineBucketIndex(t2);
            while (this.elements[n2] != null) {
                if (this.elements[n2].equals(t2)) {
                    return false;
                }
                if (++n2 < this.elements.length) continue;
                n2 = 0;
            }
            if (this.size == this.requestedCapacity) {
                throw new IllegalStateException("set is full");
            }
            this.elements[n2] = t2;
            ++this.size;
            return true;
        }

        @Override
        public int hashCode() {
            int n2 = 0;
            for (int i2 = 0; i2 < this.elements.length; ++i2) {
                T t2 = this.elements[i2];
                n2 += t2 == null ? 0 : t2.hashCode();
            }
            return n2;
        }

        private int determineBucketIndex(Object object) {
            int n2 = object.hashCode();
            return (n2 ^ n2 >>> 16) & this.mask;
        }
    }
}

