/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css;

import com.sun.javafx.css.BitSet;
import com.sun.javafx.css.PseudoClassImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javafx.css.PseudoClass;

public final class PseudoClassState
extends BitSet<PseudoClass> {
    static final Map<String, Integer> pseudoClassMap = new HashMap<String, Integer>(64);
    static final List<PseudoClass> pseudoClasses = new ArrayList<PseudoClass>();

    public PseudoClassState() {
    }

    PseudoClassState(List<String> list) {
        int n2 = list != null ? list.size() : 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            PseudoClass pseudoClass = PseudoClassState.getPseudoClass(list.get(i2));
            this.add(pseudoClass);
        }
    }

    @Override
    public String toString() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            arrayList.add(((PseudoClass)iterator.next()).getPseudoClassName());
        }
        return ((Object)arrayList).toString();
    }

    @Override
    protected Class<PseudoClass> getElementType() {
        return PseudoClass.class;
    }

    @Override
    protected PseudoClass getT(int n2) {
        return PseudoClassState.getPseudoClass(n2);
    }

    @Override
    protected int getIndex(PseudoClass pseudoClass) {
        if (pseudoClass instanceof PseudoClassImpl) {
            return ((PseudoClassImpl)pseudoClass).getIndex();
        }
        String string = pseudoClass.getPseudoClassName();
        Integer n2 = pseudoClassMap.get(string);
        if (n2 == null) {
            n2 = pseudoClasses.size();
            pseudoClasses.add(new PseudoClassImpl(string, n2));
            pseudoClassMap.put(string, n2);
        }
        return n2;
    }

    public static PseudoClass getPseudoClass(String string) {
        if (string == null || string.trim().isEmpty()) {
            throw new IllegalArgumentException("pseudoClass cannot be null or empty String");
        }
        PseudoClass pseudoClass = null;
        Integer n2 = pseudoClassMap.get(string);
        int n3 = n2 != null ? n2 : -1;
        int n4 = pseudoClasses.size();
        assert (n3 < n4);
        if (n3 != -1 && n3 < n4) {
            pseudoClass = pseudoClasses.get(n3);
        }
        if (pseudoClass == null) {
            pseudoClass = new PseudoClassImpl(string, n4);
            pseudoClasses.add(pseudoClass);
            pseudoClassMap.put(string, n4);
        }
        return pseudoClass;
    }

    static PseudoClass getPseudoClass(int n2) {
        if (0 <= n2 && n2 < pseudoClasses.size()) {
            return pseudoClasses.get(n2);
        }
        return null;
    }
}

