/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css;

import com.sun.javafx.css.FixedCapacitySet;
import com.sun.javafx.css.ImmutablePseudoClassSetsCache;
import com.sun.javafx.css.PseudoClassState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.css.PseudoClass;
import javafx.css.Selector;
import javafx.css.StyleClass;
import javafx.css.Styleable;
import javafx.geometry.NodeOrientation;
import javafx.scene.Node;

public final class SimpleSelector
extends Selector {
    private final String name;
    private static final Map<String, Integer> styleClassMap = new HashMap<String, Integer>(64);
    private static final List<StyleClass> styleClasses = new ArrayList<StyleClass>();
    private final FixedCapacitySet<String> selectorStyleClassNames;
    private transient Set<StyleClass> cachedStyleClasses;
    private final String id;
    private final Set<PseudoClass> pseudoClassState;
    private final boolean matchOnName;
    private final boolean matchOnId;
    private final boolean matchOnStyleClass;
    private final NodeOrientation nodeOrientation;

    public String getName() {
        return this.name;
    }

    public List<String> getStyleClasses() {
        return List.copyOf(this.selectorStyleClassNames);
    }

    public Set<StyleClass> getStyleClassSet() {
        if (this.cachedStyleClasses == null) {
            this.cachedStyleClasses = this.getStyleClassNames().stream().map(SimpleSelector::getStyleClass).collect(Collectors.toUnmodifiableSet());
        }
        return this.cachedStyleClasses;
    }

    private static StyleClass getStyleClass(String string) {
        if (string == null || string.trim().isEmpty()) {
            throw new IllegalArgumentException("styleClass cannot be null or empty String");
        }
        StyleClass styleClass = null;
        Integer n2 = styleClassMap.get(string);
        int n3 = n2 != null ? n2 : -1;
        int n4 = styleClasses.size();
        assert (n3 < n4);
        if (n3 != -1 && n3 < n4) {
            styleClass = styleClasses.get(n3);
        }
        if (styleClass == null) {
            styleClass = new StyleClass(string, n4);
            styleClasses.add(styleClass);
            styleClassMap.put(string, n4);
        }
        return styleClass;
    }

    public String getId() {
        return this.id;
    }

    public Set<PseudoClass> getPseudoClassStates() {
        return this.pseudoClassState;
    }

    public NodeOrientation getNodeOrientation() {
        return this.nodeOrientation;
    }

    public SimpleSelector(String string, List<String> list, List<String> list2, String string2) {
        this.name = string == null ? "*" : string;
        this.matchOnName = string != null && !"".equals(string) && !"*".equals(string);
        this.selectorStyleClassNames = list == null ? FixedCapacitySet.of(0) : this.convertStyleClassNamesToSet(list);
        this.selectorStyleClassNames.freeze();
        this.matchOnStyleClass = this.selectorStyleClassNames.size() > 0;
        PseudoClassState pseudoClassState = new PseudoClassState();
        NodeOrientation nodeOrientation = NodeOrientation.INHERIT;
        if (list2 != null) {
            for (int i2 = 0; i2 < list2.size(); ++i2) {
                String string3 = list2.get(i2);
                if (string3 == null || string3.isEmpty()) continue;
                if ("dir(".regionMatches(true, 0, string3, 0, 4)) {
                    boolean bl = "dir(rtl)".equalsIgnoreCase(string3);
                    nodeOrientation = bl ? NodeOrientation.RIGHT_TO_LEFT : NodeOrientation.LEFT_TO_RIGHT;
                    continue;
                }
                pseudoClassState.add(PseudoClassState.getPseudoClass(string3));
            }
        }
        this.pseudoClassState = ImmutablePseudoClassSetsCache.of(pseudoClassState);
        this.nodeOrientation = nodeOrientation;
        this.id = string2 == null ? "" : string2;
        this.matchOnId = string2 != null && !"".equals(string2);
    }

    @Override
    public Set<String> getStyleClassNames() {
        return this.selectorStyleClassNames;
    }

    private FixedCapacitySet<String> convertStyleClassNamesToSet(List<String> list) {
        FixedCapacitySet<String> fixedCapacitySet = FixedCapacitySet.of(list.size());
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = list.get(i2);
            if (string == null || string.isEmpty()) continue;
            fixedCapacitySet.add(string);
        }
        return fixedCapacitySet;
    }

    @Override
    public boolean applies(Styleable styleable) {
        boolean bl;
        boolean bl2;
        Object object;
        NodeOrientation nodeOrientation;
        if (this.nodeOrientation != NodeOrientation.INHERIT && styleable instanceof Node && ((nodeOrientation = ((Node)(object = (Node)styleable)).getNodeOrientation()) == NodeOrientation.INHERIT ? ((Node)object).getEffectiveNodeOrientation() != this.nodeOrientation : nodeOrientation != this.nodeOrientation)) {
            return false;
        }
        if (this.matchOnId && !(bl2 = this.id.equals(object = styleable.getId()))) {
            return false;
        }
        if (this.matchOnName && !(bl = this.name.equals(object = styleable.getTypeSelector()))) {
            return false;
        }
        return !this.matchOnStyleClass || this.matchesStyleClasses(styleable.getStyleClass());
    }

    @Override
    public boolean applies(Styleable styleable, Set<PseudoClass>[] setArray, int n2) {
        boolean bl = this.applies(styleable);
        if (bl && setArray != null && n2 < setArray.length) {
            if (setArray[n2] == null) {
                setArray[n2] = new PseudoClassState();
            }
            setArray[n2].addAll(this.pseudoClassState);
        }
        return bl;
    }

    @Override
    public boolean stateMatches(Styleable styleable, Set<PseudoClass> set) {
        return set != null ? set.containsAll(this.pseudoClassState) : false;
    }

    private boolean matchesStyleClasses(List<String> list) {
        if (list.size() < this.selectorStyleClassNames.size()) {
            return false;
        }
        return this.selectorStyleClassNames.isSuperSetOf(list);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SimpleSelector simpleSelector = (SimpleSelector)object;
        if (this.name == null ? simpleSelector.name != null : !this.name.equals(simpleSelector.name)) {
            return false;
        }
        if (this.id == null ? simpleSelector.id != null : !this.id.equals(simpleSelector.id)) {
            return false;
        }
        if (!this.selectorStyleClassNames.equals(simpleSelector.selectorStyleClassNames)) {
            return false;
        }
        return this.pseudoClassState.equals(simpleSelector.pseudoClassState);
    }

    public int hashCode() {
        int n2 = 7;
        n2 = 31 * (n2 + this.name.hashCode());
        n2 = 31 * (n2 + this.selectorStyleClassNames.hashCode());
        n2 = 31 * (n2 + this.selectorStyleClassNames.hashCode());
        n2 = this.id != null ? 31 * (n2 + this.id.hashCode()) : 0;
        n2 = 31 * (n2 + this.pseudoClassState.hashCode());
        return n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.name != null && !this.name.isEmpty()) {
            stringBuilder.append(this.name);
        } else {
            stringBuilder.append("*");
        }
        for (String object : this.selectorStyleClassNames) {
            stringBuilder.append('.').append(object);
        }
        if (this.id != null && !this.id.isEmpty()) {
            stringBuilder.append('#');
            stringBuilder.append(this.id);
        }
        for (PseudoClass pseudoClass : this.pseudoClassState) {
            stringBuilder.append(':').append(pseudoClass.getPseudoClassName());
        }
        return stringBuilder.toString();
    }
}

