/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css;

import com.sun.javafx.animation.InterpolatorHelper;
import com.sun.javafx.css.TransitionDefinition;
import com.sun.javafx.css.TransitionMediator;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.util.Utils;
import javafx.animation.AnimationTimer;
import javafx.animation.Interpolator;
import javafx.beans.property.Property;
import javafx.css.StyleableProperty;
import javafx.css.TransitionEvent;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.util.Duration;

public final class TransitionTimer
extends AnimationTimer {
    private final Node targetNode;
    private final String targetPropertyName;
    private final Interpolator interpolator;
    private final TransitionMediator mediator;
    private double reversingShorteningFactor;
    private long startTime;
    private long endTime;
    private long delay;
    private long duration;
    private long currentTime;
    private boolean started;

    private TransitionTimer(TransitionMediator transitionMediator, TransitionDefinition transitionDefinition, String string, long l2) {
        this.delay = TransitionTimer.millisToNanos(transitionDefinition.delay().toMillis());
        this.duration = TransitionTimer.millisToNanos(transitionDefinition.duration().toMillis());
        this.targetNode = (Node)((Property)((Object)transitionMediator.getStyleableProperty())).getBean();
        this.targetPropertyName = string;
        this.interpolator = transitionDefinition.interpolator();
        this.mediator = transitionMediator;
        this.currentTime = l2;
        this.startTime = l2 + this.delay;
        this.endTime = this.startTime + this.duration;
        this.reversingShorteningFactor = 1.0;
    }

    public static CancellationToken run(TransitionMediator transitionMediator, TransitionDefinition transitionDefinition, String string, long l2) {
        Node node;
        Property property;
        StyleableProperty<?> styleableProperty = transitionMediator.getStyleableProperty();
        if (!(styleableProperty instanceof Property && (styleableProperty = (property = (Property)((Object)styleableProperty)).getBean()) instanceof Node && NodeHelper.isTreeShowing(node = (Node)((Object)styleableProperty)))) {
            return null;
        }
        long l3 = TransitionTimer.millisToNanos(transitionDefinition.delay().toMillis());
        long l4 = TransitionTimer.millisToNanos(transitionDefinition.duration().toMillis());
        long l5 = Math.max(l4, 0L) + l3;
        TransitionTimer transitionTimer = NodeHelper.findTransitionTimer(node, string);
        if (transitionTimer != null) {
            if (l5 > 0L) {
                TransitionTimer transitionTimer2 = new TransitionTimer(transitionMediator, transitionDefinition, string, l2);
                if (transitionMediator.updateReversingAdjustedStartValue(transitionTimer.getMediator())) {
                    transitionTimer2.adjustReversingTimings(transitionTimer);
                }
                transitionTimer.interrupt();
                transitionTimer2.start();
                return transitionTimer2::stop;
            }
            transitionTimer.stop();
            return null;
        }
        if (l5 > 0L) {
            TransitionTimer transitionTimer3 = new TransitionTimer(transitionMediator, transitionDefinition, string, l2);
            transitionTimer3.start();
            return transitionTimer3::stop;
        }
        return null;
    }

    public TransitionMediator getMediator() {
        return this.mediator;
    }

    @Override
    public void handle(long l2) {
        this.currentTime = Math.min(l2, this.endTime);
        if (!this.started && this.currentTime >= this.startTime) {
            this.started = true;
            this.fireTransitionEvent(TransitionEvent.START);
        }
        if (this.started) {
            double d2 = this.getProgress();
            if (d2 >= 0.0) {
                this.update(d2);
            }
            if (d2 == 1.0) {
                this.stopTimer(TransitionEvent.END);
            }
        }
    }

    @Override
    public void start() {
        super.start();
        NodeHelper.addTransitionTimer(this.targetNode, this.targetPropertyName, this);
        this.fireTransitionEvent(TransitionEvent.RUN);
    }

    @Override
    public void stop() {
        this.stopTimer(TransitionEvent.CANCEL);
    }

    public void complete() {
        this.update(1.0);
        this.stopTimer(TransitionEvent.CANCEL);
    }

    private void interrupt() {
        super.stop();
        NodeHelper.removeTransitionTimer(this.targetNode, this.targetPropertyName);
        this.fireTransitionEvent(TransitionEvent.CANCEL);
    }

    private void stopTimer(EventType<TransitionEvent> eventType) {
        super.stop();
        this.mediator.onStop();
        NodeHelper.removeTransitionTimer(this.targetNode, this.targetPropertyName);
        this.fireTransitionEvent(eventType);
    }

    private void update(double d2) {
        try {
            this.mediator.onUpdate(InterpolatorHelper.curve(this.interpolator, d2));
        }
        catch (Throwable throwable) {
            Thread thread = Thread.currentThread();
            thread.getUncaughtExceptionHandler().uncaughtException(thread, throwable);
        }
    }

    private double getProgress() {
        if (this.currentTime <= this.startTime) {
            return 0.0;
        }
        if (this.currentTime < this.endTime) {
            return (double)(this.currentTime - this.startTime) / (double)(this.endTime - this.startTime);
        }
        return 1.0;
    }

    private void adjustReversingTimings(TransitionTimer transitionTimer) {
        double d2 = InterpolatorHelper.curve(transitionTimer.interpolator, transitionTimer.getProgress());
        if (d2 > 0.0 && d2 < 1.0) {
            double d3 = transitionTimer.reversingShorteningFactor;
            double d4 = d2 * d3 + (1.0 - d3);
            this.reversingShorteningFactor = Utils.clamp(0.0, d4, 1.0);
        }
        if (this.delay < 0L) {
            this.delay = (long)((double)this.delay * this.reversingShorteningFactor);
            this.startTime = this.currentTime + this.delay;
        }
        this.duration = (long)((double)this.duration * this.reversingShorteningFactor);
        this.endTime = this.startTime + this.duration;
    }

    private void fireTransitionEvent(EventType<TransitionEvent> eventType) {
        try {
            long l2;
            if (eventType == TransitionEvent.RUN || eventType == TransitionEvent.START) {
                l2 = Math.min(Math.max(-this.delay, 0L), this.duration);
            } else if (eventType == TransitionEvent.CANCEL) {
                l2 = Math.max(0L, this.currentTime - this.startTime);
            } else if (eventType == TransitionEvent.END) {
                l2 = this.duration;
            } else {
                throw new IllegalArgumentException("eventType");
            }
            this.targetNode.fireEvent(new TransitionEvent(eventType, this.mediator.getStyleableProperty(), this.targetPropertyName, Duration.millis(TransitionTimer.nanosToMillis(l2))));
        }
        catch (Throwable throwable) {
            Thread thread = Thread.currentThread();
            thread.getUncaughtExceptionHandler().uncaughtException(thread, throwable);
        }
    }

    private static double nanosToMillis(long l2) {
        return (double)l2 / 1000000.0;
    }

    private static long millisToNanos(double d2) {
        return (long)(d2 * 1000000.0);
    }

    public static interface CancellationToken {
        public void cancel();
    }
}

