/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font.coretext;

import com.sun.javafx.font.FontFallbackInfo;
import com.sun.javafx.font.FontResource;
import com.sun.javafx.font.PrismFontFactory;
import com.sun.javafx.font.PrismFontFile;
import com.sun.javafx.font.coretext.CTFontFile;
import com.sun.javafx.font.coretext.CTGlyphLayout;
import com.sun.javafx.font.coretext.OS;
import com.sun.javafx.text.GlyphLayout;

public class CTFactory
extends PrismFontFactory {
    public static PrismFontFactory getFactory() {
        return new CTFactory();
    }

    private CTFactory() {
    }

    CTFontFile createFontFile(String string, long l2) throws Exception {
        String string2 = OS.CTFontCopyURLAttribute(l2);
        int n2 = this.findFontIndex(string, string2);
        if (debugFonts) {
            System.err.println("createFontFile by ref name=" + string + " filename=" + string2 + " index=" + n2);
        }
        if (n2 == -1) {
            return null;
        }
        CTFontFile cTFontFile = new CTFontFile(string, string2, n2, l2);
        this.storeInMap(string, cTFontFile);
        return cTFontFile;
    }

    @Override
    protected PrismFontFile createFontFile(String string, String string2, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws Exception {
        return new CTFontFile(string, string2, n2, bl, bl2, bl3, bl4);
    }

    @Override
    public GlyphLayout createGlyphLayout() {
        return new CTGlyphLayout();
    }

    @Override
    protected boolean registerEmbeddedFont(String string) {
        boolean bl = CTFontFile.registerFont(string);
        if (debugFonts) {
            if (bl) {
                System.err.println("[CoreText] Font registration succeeded:" + string);
            } else {
                System.err.println("[CoreText] Font registration failed:" + string);
            }
        }
        return bl;
    }

    @Override
    public boolean isExcluded(String string) {
        return string.startsWith(".") || string.startsWith("System Font");
    }

    @Override
    public FontFallbackInfo getFallbacks(FontResource fontResource) {
        Object object;
        FontFallbackInfo fontFallbackInfo = new FontFallbackInfo();
        if (fontResource instanceof CTFontFile) {
            object = (CTFontFile)fontResource;
            ((CTFontFile)object).getCascadingInfo(fontFallbackInfo);
        }
        object = "System Regular";
        boolean bl = false;
        if (fontResource != null) {
            object = fontResource.getFullName();
            bl = fontResource.isBold();
        }
        if (((String)object).startsWith("System ")) {
            if (!bl) {
                fontFallbackInfo.add("Hiragino Sans W3", "/System/Library/Fonts/\u30d2\u30e9\u30ae\u30ce\u89d2\u30b4\u30b7\u30c3\u30af W3.ttc", null);
                fontFallbackInfo.add("Hiragino Sans GB W3", "/System/Library/Fonts/Hiragino Sans GB.ttc", null);
                fontFallbackInfo.add("Apple SD Gothic Neo Regular", "/System/Library/Fonts/AppleSDGothicNeo.ttc", null);
                fontFallbackInfo.add("PingFang SC Regular", "/System/Library/Fonts/PingFang.ttc", null);
                fontFallbackInfo.add("PingFang TC Regular", "/System/Library/Fonts/PingFang.ttc", null);
                fontFallbackInfo.add("PingFang HK Regular", "/System/Library/Fonts/PingFang.ttc", null);
            } else {
                fontFallbackInfo.add("Hiragino Sans W6", "/System/Library/Fonts/\u30d2\u30e9\u30ae\u30ce\u89d2\u30b4\u30b7\u30c3\u30af W6.ttc", null);
                fontFallbackInfo.add("Hiragino Sans GB W6", "System/Library/Fonts/Hiragino Sans GB.ttc", null);
                fontFallbackInfo.add("Apple SD Gothic Neo Bold", "/System/Library/Fonts/AppleSDGothicNeo.ttc", null);
                fontFallbackInfo.add("PingFang SC Semibold", "/System/Library/Fonts/PingFang.ttc", null);
                fontFallbackInfo.add("PingFang TC Semibold", "/System/Library/Fonts/PingFang.ttc", null);
                fontFallbackInfo.add("PingFang HK Semibold", "/System/Library/Fonts/PingFang.ttc", null);
            }
        }
        fontFallbackInfo.add("Apple Symbols", "/System/Library/Fonts/Apple Symbols.ttf", null);
        fontFallbackInfo.add("Apple Color Emoji", "/System/Library/Fonts/Apple Color Emoji.ttc", null);
        fontFallbackInfo.add("Arial Unicode MS", "/Library/Fonts/Arial Unicode.ttf", null);
        fontFallbackInfo.add("Heiti SC Light", "/System/Library/Fonts/STHeiti Light.ttc", null);
        return fontFallbackInfo;
    }
}

