/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font.coretext;

import com.sun.javafx.font.Disposer;
import com.sun.javafx.font.DisposerRecord;
import com.sun.javafx.font.FontFallbackInfo;
import com.sun.javafx.font.FontStrikeDesc;
import com.sun.javafx.font.MacFontFinder;
import com.sun.javafx.font.PrismFontFactory;
import com.sun.javafx.font.PrismFontFile;
import com.sun.javafx.font.PrismFontStrike;
import com.sun.javafx.font.coretext.CGAffineTransform;
import com.sun.javafx.font.coretext.CGRect;
import com.sun.javafx.font.coretext.CGSize;
import com.sun.javafx.font.coretext.CTFactory;
import com.sun.javafx.font.coretext.CTFontStrike;
import com.sun.javafx.font.coretext.OS;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.transform.BaseTransform;
import java.lang.ref.Reference;

class CTFontFile
extends PrismFontFile {
    private long cgFontRef = 0L;
    private static final CGAffineTransform tx = new CGAffineTransform();
    private long ctFontRef = 0L;

    CTFontFile(String string, String string2, int n2, long l2) throws Exception {
        super(string, string2, n2, false, false, false, false);
        if (l2 == 0L) {
            throw new InternalError("Zero fontref");
        }
        this.ctFontRef = l2;
        Disposer.addRecord(this, new SelfDisposerRecord(this.ctFontRef));
    }

    CTFontFile(String string, String string2, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws Exception {
        super(string, string2, n2, bl, bl2, bl3, bl4);
        String string3;
        if (string != null && (string3 = this.getFamilyName()).equals("System Font")) {
            this.fullName = string;
        }
        if (bl2) {
            this.cgFontRef = this.createCGFontForEmbeddedFont();
            Disposer.addRecord(this, new SelfDisposerRecord(this.cgFontRef));
        } else {
            this.cgFontRef = 0L;
        }
    }

    @Override
    public boolean isBold() {
        return this.fullName.equals("System Font Bold") || super.isBold();
    }

    public static boolean registerFont(String string) {
        if (string == null) {
            return false;
        }
        long l2 = OS.kCFAllocatorDefault();
        boolean bl = false;
        long l3 = OS.CFStringCreate(string);
        if (l3 != 0L) {
            int n2 = 0;
            long l4 = OS.CFURLCreateWithFileSystemPath(l2, l3, n2, false);
            if (l4 != 0L) {
                int n3 = 1;
                bl = OS.CTFontManagerRegisterFontsForURL(l4, n3, 0L);
                OS.CFRelease(l4);
            }
            OS.CFRelease(l3);
        }
        return bl;
    }

    private long createCGFontForEmbeddedFont() {
        long l2 = 0L;
        long l3 = OS.CFStringCreate(this.getFileName());
        if (l3 != 0L) {
            long l4 = OS.CFURLCreateWithFileSystemPath(OS.kCFAllocatorDefault(), l3, 0L, false);
            if (l4 != 0L) {
                long l5 = OS.CGDataProviderCreateWithURL(l4);
                if (l5 != 0L) {
                    l2 = OS.CGFontCreateWithDataProvider(l5);
                    OS.CFRelease(l5);
                }
                OS.CFRelease(l4);
            }
            OS.CFRelease(l3);
        }
        return l2;
    }

    long getCGFontRef() {
        return this.cgFontRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CGRect getBBox(int n2, float f2) {
        CTFontStrike cTFontStrike = (CTFontStrike)this.getStrike(f2, BaseTransform.IDENTITY_TRANSFORM);
        try {
            long l2 = cTFontStrike.getFontRef();
            if (l2 == 0L) {
                CGRect cGRect = null;
                return cGRect;
            }
            long l3 = OS.CTFontCreatePathForGlyph(l2, (short)n2, tx);
            if (l3 == 0L) {
                CGRect cGRect = null;
                return cGRect;
            }
            CGRect cGRect = OS.CGPathGetPathBoundingBox(l3);
            OS.CGPathRelease(l3);
            CGRect cGRect2 = cGRect;
            return cGRect2;
        }
        finally {
            Reference.reachabilityFence(cTFontStrike);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Path2D getGlyphOutline(int n2, float f2) {
        CTFontStrike cTFontStrike = (CTFontStrike)this.getStrike(f2, BaseTransform.IDENTITY_TRANSFORM);
        try {
            long l2 = cTFontStrike.getFontRef();
            if (l2 == 0L) {
                Path2D path2D = null;
                return path2D;
            }
            long l3 = OS.CTFontCreatePathForGlyph(l2, (short)n2, tx);
            if (l3 == 0L) {
                Path2D path2D = null;
                return path2D;
            }
            Path2D path2D = OS.CGPathApply(l3);
            OS.CGPathRelease(l3);
            Path2D path2D2 = path2D;
            return path2D2;
        }
        finally {
            Reference.reachabilityFence(cTFontStrike);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected float getAdvanceFromPlatform(int n2, float f2) {
        CTFontStrike cTFontStrike = (CTFontStrike)this.getStrike(f2, BaseTransform.IDENTITY_TRANSFORM);
        try {
            long l2 = cTFontStrike.getFontRef();
            int n3 = 0;
            CGSize cGSize = new CGSize();
            float f3 = (float)OS.CTFontGetAdvancesForGlyphs(l2, n3, (short)n2, cGSize);
            return f3;
        }
        finally {
            Reference.reachabilityFence(cTFontStrike);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int[] createGlyphBoundingBox(int n2) {
        float f2 = 12.0f;
        CTFontStrike cTFontStrike = (CTFontStrike)this.getStrike(f2, BaseTransform.IDENTITY_TRANSFORM);
        try {
            long l2;
            long l3 = cTFontStrike.getFontRef();
            if (l3 == 0L) {
                int[] nArray = null;
                return nArray;
            }
            int[] nArray = new int[4];
            if (!this.isCFF()) {
                if (this.isColorGlyph(n2)) {
                    CGRect cGRect = OS.CTFontGetBoundingRectForGlyphs(l3, (short)n2);
                    float f3 = (float)this.getUnitsPerEm() / f2;
                    nArray[0] = (int)Math.round(cGRect.origin.x * (double)f3);
                    nArray[1] = (int)Math.round(cGRect.origin.y * (double)f3);
                    nArray[2] = (int)Math.round((cGRect.origin.x + cGRect.size.width) * (double)f3);
                    nArray[3] = (int)Math.round((cGRect.origin.y + cGRect.size.height) * (double)f3);
                    int[] nArray2 = nArray;
                    return nArray2;
                }
                short s2 = this.getIndexToLocFormat();
                if (OS.CTFontGetBoundingRectForGlyphUsingTables(l3, (short)n2, s2, nArray)) {
                    int[] nArray3 = nArray;
                    return nArray3;
                }
            }
            if ((l2 = OS.CTFontCreatePathForGlyph(l3, (short)n2, null)) == 0L) {
                int[] nArray4 = null;
                return nArray4;
            }
            CGRect cGRect = OS.CGPathGetPathBoundingBox(l2);
            OS.CGPathRelease(l2);
            float f4 = (float)this.getUnitsPerEm() / f2;
            nArray[0] = (int)Math.round(cGRect.origin.x * (double)f4);
            nArray[1] = (int)Math.round(cGRect.origin.y * (double)f4);
            nArray[2] = (int)Math.round((cGRect.origin.x + cGRect.size.width) * (double)f4);
            nArray[3] = (int)Math.round((cGRect.origin.y + cGRect.size.height) * (double)f4);
            int[] nArray5 = nArray;
            return nArray5;
        }
        finally {
            Reference.reachabilityFence(cTFontStrike);
        }
    }

    @Override
    protected PrismFontStrike<CTFontFile> createStrike(float f2, BaseTransform baseTransform, int n2, FontStrikeDesc fontStrikeDesc) {
        return new CTFontStrike(this, f2, baseTransform, n2, fontStrikeDesc);
    }

    long getFontRef(float f2, CGAffineTransform cGAffineTransform) {
        long l2 = 0L;
        if (this.isEmbeddedFont()) {
            if (this.cgFontRef != 0L) {
                l2 = OS.CTFontCreateWithGraphicsFont(this.cgFontRef, f2, cGAffineTransform, 0L);
            }
        } else if (this.ctFontRef != 0L) {
            l2 = OS.CTFontCreateCopyWithAttributes(this.ctFontRef, f2, cGAffineTransform, 0L);
        } else {
            String string = this.getPSName();
            if (string.startsWith(".")) {
                boolean bl = this.getFullName().indexOf("Bold") > 0;
                l2 = OS.CTFontCreateUIFontForLanguage(f2, cGAffineTransform, bl);
            } else {
                long l3 = OS.CFStringCreate(string);
                if (l3 != 0L) {
                    l2 = OS.CTFontCreateWithName(l3, f2, cGAffineTransform);
                    OS.CFRelease(l3);
                }
            }
        }
        return l2;
    }

    void getCascadingInfo(FontFallbackInfo fontFallbackInfo) {
        CTFactory cTFactory = (CTFactory)PrismFontFactory.getFontFactory();
        long l2 = this.getFontRef(0.0f, null);
        String[] stringArray = MacFontFinder.getCascadeList(l2);
        if (PrismFontFactory.debugFonts) {
            System.err.println("Cascading list for " + this.getFullName());
        }
        for (int i2 = 0; i2 < stringArray.length; i2 += 2) {
            String string = stringArray[i2];
            String string2 = stringArray[i2 + 1];
            if (PrismFontFactory.debugFonts) {
                System.err.print("Entry : name=" + string + " file=" + string2);
            }
            if (string2 == null || string.startsWith(".")) {
                if (!PrismFontFactory.debugFonts) continue;
                System.err.println(" - *** not using this entry (.font and/or null file)");
                continue;
            }
            if (PrismFontFactory.debugFonts) {
                System.err.println();
            }
            fontFallbackInfo.add(string, string2, null);
        }
        if (PrismFontFactory.debugFonts) {
            System.err.println("End cascading list");
        }
    }

    static {
        CTFontFile.tx.a = 1.0;
        CTFontFile.tx.d = -1.0;
    }

    private static class SelfDisposerRecord
    implements DisposerRecord {
        private long fontRef;

        SelfDisposerRecord(long l2) {
            this.fontRef = l2;
        }

        @Override
        public synchronized void dispose() {
            if (this.fontRef != 0L) {
                OS.CFRelease(this.fontRef);
                this.fontRef = 0L;
            }
        }
    }
}

