/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.iio.common;

import com.sun.javafx.iio.ImageFrame;
import com.sun.javafx.iio.ImageStorage;
import com.sun.javafx.iio.common.PushbroomScaler;
import com.sun.javafx.iio.common.ScalerFactory;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Locale;

public class ImageTools {
    public static final int PROGRESS_INTERVAL = 5;

    public static int readFully(InputStream inputStream, byte[] byArray, int n2, int n3) throws IOException {
        if (n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n4 = n3;
        if (n2 < 0 || n3 < 0 || n2 + n3 > byArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > b.length!");
        }
        while (n3 > 0) {
            int n5 = inputStream.read(byArray, n2, n3);
            if (n5 == -1) {
                throw new EOFException();
            }
            n2 += n5;
            n3 -= n5;
        }
        return n4;
    }

    public static int readFully(InputStream inputStream, byte[] byArray) throws IOException {
        return ImageTools.readFully(inputStream, byArray, 0, byArray.length);
    }

    public static void skipFully(InputStream inputStream, long l2) throws IOException {
        while (l2 > 0L) {
            long l3 = inputStream.skip(l2);
            if (l3 <= 0L) {
                if (inputStream.read() == -1) {
                    throw new EOFException();
                }
                --l2;
                continue;
            }
            l2 -= l3;
        }
    }

    public static String getScaledImageName(String string, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = string.lastIndexOf(47);
        String string2 = n3 < 0 ? string : string.substring(n3 + 1);
        int n4 = string2.lastIndexOf(".");
        if (n4 < 0) {
            n4 = string2.length();
        }
        if (n3 >= 0) {
            stringBuilder.append(string.substring(0, n3 + 1));
        }
        stringBuilder.append(string2.substring(0, n4));
        stringBuilder.append("@");
        stringBuilder.append(n2);
        stringBuilder.append("x");
        stringBuilder.append(string2.substring(n4));
        return stringBuilder.toString();
    }

    public static InputStream createInputStream(String string) throws IOException {
        Serializable serializable;
        InputStream inputStream = null;
        try {
            serializable = new File(string);
            if (((File)serializable).exists()) {
                inputStream = new FileInputStream((File)serializable);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (inputStream == null) {
            serializable = new URL(string);
            inputStream = ((URL)serializable).openStream();
        }
        return inputStream;
    }

    public static int[] computeDimensions(int n2, int n3, int n4, int n5, boolean bl) {
        int n6;
        int n7 = n4 < 0 ? 0 : n4;
        int n8 = n6 = n5 < 0 ? 0 : n5;
        if (n7 == 0 && n6 == 0) {
            n7 = n2;
            n6 = n3;
        } else if (n7 != n2 || n6 != n3) {
            if (bl) {
                if (n7 == 0) {
                    n7 = Math.round((float)n2 * (float)n6 / (float)n3);
                } else if (n6 == 0) {
                    n6 = Math.round((float)n3 * (float)n7 / (float)n2);
                } else {
                    float f2 = Math.min((float)n7 / (float)n2, (float)n6 / (float)n3);
                    n7 = Math.round((float)n2 * f2);
                    n6 = Math.round((float)n3 * f2);
                }
            } else {
                if (n6 == 0) {
                    n6 = n3;
                }
                if (n7 == 0) {
                    n7 = n2;
                }
            }
            if (n7 <= 0) {
                n7 = 1;
            }
            if (n6 <= 0) {
                n6 = 1;
            }
        }
        return new int[]{n7, n6};
    }

    public static void validateMaxDimensions(double d2, double d3, double d4) {
        if (d2 * d4 > 2.147483647E9) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Image width exceeds maximum value (width = %f, scale = %f)", d2, d4));
        }
        if (d3 * d4 > 2.147483647E9) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Image height exceeds maximum value (height = %f, scale = %f)", d3, d4));
        }
        if ((long)(d2 * d4) * (long)(d3 * d4) > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Image size exceeds maximum value (width = %f, height = %f, scale = %f)", d2, d3, d4));
        }
    }

    public static ImageFrame scaleImageFrame(ImageFrame imageFrame, int n2, int n3, boolean bl) {
        int n4 = ImageStorage.getInstance().getNumBands(imageFrame.getImageType());
        ByteBuffer byteBuffer = ImageTools.scaleImage((ByteBuffer)imageFrame.getImageData(), imageFrame.getWidth(), imageFrame.getHeight(), n4, n2, n3, bl);
        return new ImageFrame(imageFrame.getImageType(), byteBuffer, n2, n3, n2 * n4, imageFrame.getMetadata());
    }

    public static ByteBuffer scaleImage(ByteBuffer byteBuffer, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        PushbroomScaler pushbroomScaler = ScalerFactory.createScaler(n2, n3, n4, n5, n6, bl);
        int n7 = n2 * n4;
        if (byteBuffer.hasArray()) {
            byte[] byArray = byteBuffer.array();
            for (int i2 = 0; i2 != n3; ++i2) {
                pushbroomScaler.putSourceScanline(byArray, i2 * n7);
            }
        } else {
            byte[] byArray = new byte[n7];
            for (int i3 = 0; i3 != n3; ++i3) {
                byteBuffer.get(byArray);
                pushbroomScaler.putSourceScanline(byArray, 0);
            }
        }
        return pushbroomScaler.getDestination();
    }
}

