/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.image.impl;

import com.sun.javafx.image.AlphaType;
import com.sun.javafx.image.BytePixelGetter;
import com.sun.javafx.image.BytePixelSetter;
import com.sun.javafx.image.ByteToBytePixelConverter;
import com.sun.javafx.image.PixelUtils;
import java.nio.ByteBuffer;

abstract class BaseIndexedToByteConverter
implements ByteToBytePixelConverter {
    protected final IndexedGetter getter;
    protected final BytePixelSetter setter;
    protected final int nSrcElems;
    protected final int nDstElems;

    BaseIndexedToByteConverter(IndexedGetter indexedGetter, BytePixelSetter bytePixelSetter) {
        this.getter = indexedGetter;
        this.setter = bytePixelSetter;
        this.nSrcElems = indexedGetter.getNumElements();
        this.nDstElems = bytePixelSetter.getNumElements();
    }

    public final IndexedGetter getGetter() {
        return this.getter;
    }

    public final BytePixelSetter getSetter() {
        return this.setter;
    }

    abstract void doConvert(byte[] var1, int var2, int var3, byte[] var4, int var5, int var6, int var7, int var8);

    abstract void doConvert(ByteBuffer var1, int var2, int var3, ByteBuffer var4, int var5, int var6, int var7, int var8);

    @Override
    public final void convert(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5, int n6, int n7) {
        if (n6 <= 0 || n7 <= 0) {
            return;
        }
        if (n3 == n6 * this.nSrcElems && n5 == n6 * this.nDstElems) {
            n6 *= n7;
            n7 = 1;
        }
        this.doConvert(byArray, n2, n3, byArray2, n4, n5, n6, n7);
    }

    @Override
    public final void convert(ByteBuffer byteBuffer, int n2, int n3, ByteBuffer byteBuffer2, int n4, int n5, int n6, int n7) {
        if (n6 <= 0 || n7 <= 0) {
            return;
        }
        if (n3 == n6 * this.nSrcElems && n5 == n6 * this.nDstElems) {
            n6 *= n7;
            n7 = 1;
        }
        if (byteBuffer.hasArray() && byteBuffer2.hasArray()) {
            this.doConvert(byteBuffer.array(), n2 += byteBuffer.arrayOffset(), n3, byteBuffer2.array(), n4 += byteBuffer2.arrayOffset(), n5, n6, n7);
        } else {
            this.doConvert(byteBuffer, n2, n3, byteBuffer2, n4, n5, n6, n7);
        }
    }

    @Override
    public final void convert(ByteBuffer byteBuffer, int n2, int n3, byte[] byArray, int n4, int n5, int n6, int n7) {
        if (n6 <= 0 || n7 <= 0) {
            return;
        }
        if (n3 == n6 * this.nSrcElems && n5 == n6 * this.nDstElems) {
            n6 *= n7;
            n7 = 1;
        }
        if (byteBuffer.hasArray()) {
            byte[] byArray2 = byteBuffer.array();
            this.doConvert(byArray2, n2 += byteBuffer.arrayOffset(), n3, byArray, n4, n5, n6, n7);
        } else {
            ByteBuffer byteBuffer2 = ByteBuffer.wrap(byArray);
            this.doConvert(byteBuffer, n2, n3, byteBuffer2, n4, n5, n6, n7);
        }
    }

    @Override
    public final void convert(byte[] byArray, int n2, int n3, ByteBuffer byteBuffer, int n4, int n5, int n6, int n7) {
        if (n6 <= 0 || n7 <= 0) {
            return;
        }
        if (n3 == n6 * this.nSrcElems && n5 == n6 * this.nDstElems) {
            n6 *= n7;
            n7 = 1;
        }
        if (byteBuffer.hasArray()) {
            byte[] byArray2 = byteBuffer.array();
            this.doConvert(byArray, n2, n3, byArray2, n4 += byteBuffer.arrayOffset(), n5, n6, n7);
        } else {
            ByteBuffer byteBuffer2 = ByteBuffer.wrap(byArray);
            this.doConvert(byteBuffer2, n2, n3, byteBuffer, n4, n5, n6, n7);
        }
    }

    static abstract class IndexedGetter
    implements BytePixelGetter {
        final int[] preColors;
        final int[] nonPreColors;
        private final AlphaType alphaType;

        IndexedGetter(int[] nArray, AlphaType alphaType) {
            int[] nArray2 = null;
            int[] nArray3 = null;
            switch (alphaType) {
                case OPAQUE: {
                    nArray3 = nArray;
                    nArray2 = nArray;
                    break;
                }
                case PREMULTIPLIED: {
                    nArray2 = nArray;
                    nArray3 = new int[nArray.length];
                    for (int i2 = 0; i2 < nArray.length; ++i2) {
                        nArray3[i2] = PixelUtils.PretoNonPre(nArray[i2]);
                    }
                    break;
                }
                case NONPREMULTIPLIED: {
                    nArray3 = nArray;
                    nArray2 = new int[nArray.length];
                    for (int i3 = 0; i3 < nArray.length; ++i3) {
                        nArray2[i3] = PixelUtils.NonPretoPre(nArray[i3]);
                    }
                    break;
                }
            }
            this.alphaType = alphaType;
            this.preColors = nArray2;
            this.nonPreColors = nArray3;
        }

        @Override
        public AlphaType getAlphaType() {
            return this.alphaType;
        }
    }
}

