/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.image.impl;

import com.sun.javafx.image.AlphaType;
import com.sun.javafx.image.BytePixelAccessor;
import com.sun.javafx.image.BytePixelGetter;
import com.sun.javafx.image.BytePixelSetter;
import com.sun.javafx.image.ByteToBytePixelConverter;
import com.sun.javafx.image.PixelUtils;
import com.sun.javafx.image.impl.BaseByteToByteConverter;
import com.sun.javafx.image.impl.ByteBgra;
import com.sun.javafx.image.impl.ByteBgraPre;
import java.nio.ByteBuffer;

public final class ByteAbgr {
    public static final BytePixelGetter getter = Accessor.instance;
    public static final BytePixelSetter setter = Accessor.instance;
    public static final BytePixelAccessor accessor = Accessor.instance;
    private static ByteToBytePixelConverter ToByteBgraObj;

    private ByteAbgr() {
    }

    public static ByteToBytePixelConverter ToByteBgraConverter() {
        if (ToByteBgraObj == null) {
            ToByteBgraObj = BaseByteToByteConverter.createReorderer(getter, ByteBgra.setter, 1, 2, 3, 0);
        }
        return ToByteBgraObj;
    }

    public static ByteToBytePixelConverter ToByteBgraPreConverter() {
        return ToByteBgraPreConv.instance;
    }

    static class ToByteBgraPreConv
    extends BaseByteToByteConverter {
        static final ByteToBytePixelConverter instance = new ToByteBgraPreConv();

        private ToByteBgraPreConv() {
            super(getter, ByteBgraPre.setter);
        }

        @Override
        void doConvert(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5, int n6, int n7) {
            n3 -= n6 * 4;
            n5 -= n6 * 4;
            while (--n7 >= 0) {
                for (int i2 = 0; i2 < n6; ++i2) {
                    int n8 = byArray[n2] & 0xFF;
                    byte by = byArray[n2 + 1];
                    byte by2 = byArray[n2 + 2];
                    byte by3 = byArray[n2 + 3];
                    n2 += 4;
                    if (n8 < 255) {
                        if (n8 == 0) {
                            by3 = 0;
                            by2 = 0;
                            by = 0;
                        } else {
                            by = (byte)(((by & 0xFF) * n8 + 127) / 255);
                            by2 = (byte)(((by2 & 0xFF) * n8 + 127) / 255);
                            by3 = (byte)(((by3 & 0xFF) * n8 + 127) / 255);
                        }
                    }
                    byArray2[n4++] = by;
                    byArray2[n4++] = by2;
                    byArray2[n4++] = by3;
                    byArray2[n4++] = (byte)n8;
                }
                n2 += n3;
                n4 += n5;
            }
        }

        @Override
        void doConvert(ByteBuffer byteBuffer, int n2, int n3, ByteBuffer byteBuffer2, int n4, int n5, int n6, int n7) {
            n3 -= n6 * 4;
            n5 -= n6 * 4;
            while (--n7 >= 0) {
                for (int i2 = 0; i2 < n6; ++i2) {
                    int n8 = byteBuffer.get(n2) & 0xFF;
                    byte by = byteBuffer.get(n2 + 1);
                    byte by2 = byteBuffer.get(n2 + 2);
                    byte by3 = byteBuffer.get(n2 + 3);
                    n2 += 4;
                    if (n8 < 255) {
                        if (n8 == 0) {
                            by3 = 0;
                            by2 = 0;
                            by = 0;
                        } else {
                            by = (byte)(((by & 0xFF) * n8 + 127) / 255);
                            by2 = (byte)(((by2 & 0xFF) * n8 + 127) / 255);
                            by3 = (byte)(((by3 & 0xFF) * n8 + 127) / 255);
                        }
                    }
                    byteBuffer2.put(n4, by);
                    byteBuffer2.put(n4 + 1, by2);
                    byteBuffer2.put(n4 + 2, by3);
                    byteBuffer2.put(n4 + 3, (byte)n8);
                    n4 += 4;
                }
                n2 += n3;
                n4 += n5;
            }
        }
    }

    static class Accessor
    implements BytePixelAccessor {
        static final BytePixelAccessor instance = new Accessor();

        private Accessor() {
        }

        @Override
        public AlphaType getAlphaType() {
            return AlphaType.NONPREMULTIPLIED;
        }

        @Override
        public int getNumElements() {
            return 4;
        }

        @Override
        public int getArgb(byte[] byArray, int n2) {
            return byArray[n2] << 24 | byArray[n2 + 1] & 0xFF | (byArray[n2 + 2] & 0xFF) << 8 | (byArray[n2 + 3] & 0xFF) << 16;
        }

        @Override
        public int getArgbPre(byte[] byArray, int n2) {
            return PixelUtils.NonPretoPre(this.getArgb(byArray, n2));
        }

        @Override
        public int getArgb(ByteBuffer byteBuffer, int n2) {
            return byteBuffer.get(n2) << 24 | byteBuffer.get(n2 + 1) & 0xFF | (byteBuffer.get(n2 + 2) & 0xFF) << 8 | (byteBuffer.get(n2 + 3) & 0xFF) << 16;
        }

        @Override
        public int getArgbPre(ByteBuffer byteBuffer, int n2) {
            return PixelUtils.NonPretoPre(this.getArgb(byteBuffer, n2));
        }

        @Override
        public void setArgb(byte[] byArray, int n2, int n3) {
            byArray[n2] = (byte)(n3 >> 24);
            byArray[n2 + 1] = (byte)n3;
            byArray[n2 + 2] = (byte)(n3 >> 8);
            byArray[n2 + 3] = (byte)(n3 >> 16);
        }

        @Override
        public void setArgbPre(byte[] byArray, int n2, int n3) {
            this.setArgb(byArray, n2, PixelUtils.PretoNonPre(n3));
        }

        @Override
        public void setArgb(ByteBuffer byteBuffer, int n2, int n3) {
            byteBuffer.put(n2, (byte)(n3 >> 24));
            byteBuffer.put(n2 + 1, (byte)n3);
            byteBuffer.put(n2 + 2, (byte)(n3 >> 8));
            byteBuffer.put(n2 + 3, (byte)(n3 >> 16));
        }

        @Override
        public void setArgbPre(ByteBuffer byteBuffer, int n2, int n3) {
            this.setArgb(byteBuffer, n2, PixelUtils.PretoNonPre(n3));
        }
    }
}

