/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.image.impl;

import com.sun.javafx.image.AlphaType;
import com.sun.javafx.image.BytePixelSetter;
import com.sun.javafx.image.ByteToBytePixelConverter;
import com.sun.javafx.image.impl.BaseIndexedToByteConverter;
import java.nio.ByteBuffer;

public final class EightBitIndexed {
    private EightBitIndexed() {
    }

    public static Getter createGetter(int[] nArray, AlphaType alphaType) {
        return new Getter(nArray, alphaType);
    }

    public static ByteToBytePixelConverter createToByteRgb(Getter getter, BytePixelSetter bytePixelSetter) {
        return new ToByteRgbConverter(getter, bytePixelSetter);
    }

    public static ByteToBytePixelConverter createToByteBgraAny(Getter getter, BytePixelSetter bytePixelSetter) {
        return new ToByteBgraAnyConverter(getter, bytePixelSetter);
    }

    public static class Getter
    extends BaseIndexedToByteConverter.IndexedGetter {
        Getter(int[] nArray, AlphaType alphaType) {
            super(nArray, alphaType);
        }

        @Override
        public int getNumElements() {
            return 8;
        }

        @Override
        public int getArgb(byte[] byArray, int n2) {
            return this.preColors[byArray[n2]];
        }

        @Override
        public int getArgbPre(byte[] byArray, int n2) {
            return this.nonPreColors[byArray[n2]];
        }

        @Override
        public int getArgb(ByteBuffer byteBuffer, int n2) {
            return this.preColors[byteBuffer.get(n2)];
        }

        @Override
        public int getArgbPre(ByteBuffer byteBuffer, int n2) {
            return this.nonPreColors[byteBuffer.get(n2)];
        }
    }

    public static class ToByteRgbConverter
    extends BaseIndexedToByteConverter {
        public ToByteRgbConverter(Getter getter, BytePixelSetter bytePixelSetter) {
            super(getter, bytePixelSetter);
        }

        @Override
        void doConvert(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5, int n6, int n7) {
            int[] nArray = this.getGetter().nonPreColors;
            n5 -= n6 * 3;
            while (--n7 >= 0) {
                for (int i2 = 0; i2 < n6; ++i2) {
                    int n8 = nArray[byArray[n2 + i2]];
                    byArray2[n4++] = (byte)(n8 >> 16);
                    byArray2[n4++] = (byte)(n8 >> 8);
                    byArray2[n4++] = (byte)n8;
                }
                n2 += n3;
                n4 += n5;
            }
        }

        @Override
        void doConvert(ByteBuffer byteBuffer, int n2, int n3, ByteBuffer byteBuffer2, int n4, int n5, int n6, int n7) {
            int[] nArray = this.getGetter().nonPreColors;
            n5 -= n6 * 3;
            while (--n7 >= 0) {
                for (int i2 = 0; i2 < n6; ++i2) {
                    int n8 = nArray[byteBuffer.get(n2 + i2)];
                    byteBuffer2.put(n4, (byte)(n8 >> 16));
                    byteBuffer2.put(n4 + 1, (byte)(n8 >> 8));
                    byteBuffer2.put(n4 + 2, (byte)n8);
                    n4 += 3;
                }
                n2 += n3;
                n4 += n5;
            }
        }
    }

    public static class ToByteBgraAnyConverter
    extends BaseIndexedToByteConverter {
        public ToByteBgraAnyConverter(Getter getter, BytePixelSetter bytePixelSetter) {
            super(getter, bytePixelSetter);
        }

        @Override
        void doConvert(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5, int n6, int n7) {
            int[] nArray = switch (this.setter.getAlphaType()) {
                default -> throw new MatchException(null, null);
                case AlphaType.OPAQUE, AlphaType.NONPREMULTIPLIED -> this.getGetter().nonPreColors;
                case AlphaType.PREMULTIPLIED -> this.getGetter().preColors;
            };
            n5 -= n6 * 4;
            while (--n7 >= 0) {
                for (int i2 = 0; i2 < n6; ++i2) {
                    int n8 = nArray[byArray[n2 + i2]];
                    byArray2[n4++] = (byte)n8;
                    byArray2[n4++] = (byte)(n8 >> 8);
                    byArray2[n4++] = (byte)(n8 >> 16);
                    byArray2[n4++] = (byte)(n8 >> 24);
                }
                n2 += n3;
                n4 += n5;
            }
        }

        @Override
        void doConvert(ByteBuffer byteBuffer, int n2, int n3, ByteBuffer byteBuffer2, int n4, int n5, int n6, int n7) {
            int[] nArray = switch (this.setter.getAlphaType()) {
                default -> throw new MatchException(null, null);
                case AlphaType.OPAQUE, AlphaType.NONPREMULTIPLIED -> this.getGetter().nonPreColors;
                case AlphaType.PREMULTIPLIED -> this.getGetter().preColors;
            };
            n5 -= n6 * 4;
            while (--n7 >= 0) {
                for (int i2 = 0; i2 < n6; ++i2) {
                    int n8 = nArray[byteBuffer.get(n2 + i2)];
                    byteBuffer2.put(n4, (byte)n8);
                    byteBuffer2.put(n4 + 1, (byte)(n8 >> 8));
                    byteBuffer2.put(n4 + 2, (byte)(n8 >> 16));
                    byteBuffer2.put(n4 + 3, (byte)(n8 >> 24));
                    n4 += 4;
                }
                n2 += n3;
                n4 += n5;
            }
        }
    }
}

