/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.image.impl;

import com.sun.javafx.image.AlphaType;
import com.sun.javafx.image.IntPixelAccessor;
import com.sun.javafx.image.IntPixelGetter;
import com.sun.javafx.image.IntPixelSetter;
import com.sun.javafx.image.IntToIntPixelConverter;
import com.sun.javafx.image.PixelUtils;
import com.sun.javafx.image.impl.BaseIntToIntConverter;
import com.sun.javafx.image.impl.IntArgbPre;
import java.nio.IntBuffer;

public class IntRgb {
    public static final IntPixelGetter getter = Accessor.instance;
    public static final IntPixelSetter setter = Accessor.instance;
    public static final IntPixelAccessor accessor = Accessor.instance;

    private IntRgb() {
    }

    public static IntToIntPixelConverter ToIntArgbPreConverter() {
        return ToIntArgbPreConv.instance;
    }

    public static class ToIntArgbPreConv
    extends BaseIntToIntConverter {
        public static final IntToIntPixelConverter instance = new ToIntArgbPreConv();

        private ToIntArgbPreConv() {
            super(getter, IntArgbPre.setter);
        }

        @Override
        void doConvert(int[] nArray, int n2, int n3, int[] nArray2, int n4, int n5, int n6, int n7) {
            n3 -= n6;
            n5 -= n6;
            while (--n7 >= 0) {
                for (int i2 = 0; i2 < n6; ++i2) {
                    int n8 = nArray[n2++];
                    int n9 = n8 >> 16 & 0xFF;
                    int n10 = n8 >> 8 & 0xFF;
                    int n11 = n8 & 0xFF;
                    nArray2[n4++] = 0xFF000000 | n9 << 16 | n10 << 8 | n11;
                }
                n2 += n3;
                n4 += n5;
            }
        }

        @Override
        void doConvert(IntBuffer intBuffer, int n2, int n3, IntBuffer intBuffer2, int n4, int n5, int n6, int n7) {
            while (--n7 >= 0) {
                for (int i2 = 0; i2 < n6; ++i2) {
                    int n8 = intBuffer.get(n2 + i2);
                    int n9 = n8 >> 16 & 0xFF;
                    int n10 = n8 >> 8 & 0xFF;
                    int n11 = n8 & 0xFF;
                    intBuffer2.put(n4 + i2, 0xFF000000 | n9 << 16 | n10 << 8 | n11);
                }
                n2 += n3;
                n4 += n5;
            }
        }
    }

    static class Accessor
    implements IntPixelAccessor {
        static final IntPixelAccessor instance = new Accessor();

        private Accessor() {
        }

        @Override
        public AlphaType getAlphaType() {
            return AlphaType.OPAQUE;
        }

        @Override
        public int getNumElements() {
            return 1;
        }

        @Override
        public int getArgb(int[] nArray, int n2) {
            return nArray[n2] | 0xFF000000;
        }

        @Override
        public int getArgbPre(int[] nArray, int n2) {
            return PixelUtils.NonPretoPre(nArray[n2] | 0xFF000000);
        }

        @Override
        public int getArgb(IntBuffer intBuffer, int n2) {
            return intBuffer.get(n2) | 0xFF000000;
        }

        @Override
        public int getArgbPre(IntBuffer intBuffer, int n2) {
            return PixelUtils.NonPretoPre(intBuffer.get(n2) | 0xFF000000);
        }

        @Override
        public void setArgb(int[] nArray, int n2, int n3) {
            nArray[n2] = n3 | 0xFF000000;
        }

        @Override
        public void setArgbPre(int[] nArray, int n2, int n3) {
            nArray[n2] = PixelUtils.PretoNonPre(n3) | 0xFF000000;
        }

        @Override
        public void setArgb(IntBuffer intBuffer, int n2, int n3) {
            intBuffer.put(n2, n3 | 0xFF000000);
        }

        @Override
        public void setArgbPre(IntBuffer intBuffer, int n2, int n3) {
            intBuffer.put(n2, PixelUtils.PretoNonPre(n3) | 0xFF000000);
        }
    }
}

