/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.marlin.ArrayCacheConst;
import com.sun.marlin.MarlinConst;
import com.sun.marlin.MarlinUtils;
import java.lang.ref.WeakReference;
import java.util.Arrays;

public final class ArrayCacheInt {
    private final int bucketCapacity;
    private WeakReference<Bucket[]> refBuckets = null;
    final ArrayCacheConst.CacheStats stats;

    ArrayCacheInt(int n2) {
        this.bucketCapacity = n2;
        this.stats = MarlinConst.DO_STATS ? new ArrayCacheConst.CacheStats("ArrayCacheInt(Dirty)") : null;
    }

    Bucket getCacheBucket(int n2) {
        int n3 = ArrayCacheConst.getBucket(n2);
        return this.getBuckets()[n3];
    }

    private Bucket[] getBuckets() {
        Bucket[] bucketArray;
        Bucket[] bucketArray2 = bucketArray = this.refBuckets != null ? (Bucket[])this.refBuckets.get() : null;
        if (bucketArray == null) {
            bucketArray = new Bucket[8];
            for (int i2 = 0; i2 < 8; ++i2) {
                bucketArray[i2] = new Bucket(ArrayCacheConst.ARRAY_SIZES[i2], this.bucketCapacity, MarlinConst.DO_STATS ? this.stats.bucketStats[i2] : null);
            }
            this.refBuckets = new WeakReference<Bucket[]>(bucketArray);
        }
        return bucketArray;
    }

    Reference createRef(int n2) {
        return new Reference(this, n2);
    }

    static int[] createArray(int n2) {
        return new int[n2];
    }

    static void fill(int[] nArray, int n2, int n3, int n4) {
        Arrays.fill(nArray, n2, n3, n4);
        if (MarlinConst.DO_CHECKS) {
            ArrayCacheInt.check(nArray, n2, n3, n4);
        }
    }

    static void check(int[] nArray, int n2, int n3, int n4) {
        if (MarlinConst.DO_CHECKS) {
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                if (nArray[i2] == n4) continue;
                MarlinUtils.logException("Invalid value at: " + i2 + " = " + nArray[i2] + " from: " + n2 + " to: " + n3 + "\n" + Arrays.toString(nArray), new Throwable());
                Arrays.fill(nArray, n4);
                return;
            }
        }
    }

    static final class Bucket {
        private int tail = 0;
        private final int arraySize;
        private final int[][] arrays;
        private final ArrayCacheConst.BucketStats stats;

        Bucket(int n2, int n3, ArrayCacheConst.BucketStats bucketStats) {
            this.arraySize = n2;
            this.stats = bucketStats;
            this.arrays = new int[n3][];
        }

        int[] getArray() {
            if (MarlinConst.DO_STATS) {
                ++this.stats.getOp;
            }
            if (this.tail != 0) {
                int[] nArray = this.arrays[--this.tail];
                this.arrays[this.tail] = null;
                return nArray;
            }
            if (MarlinConst.DO_STATS) {
                ++this.stats.createOp;
            }
            return ArrayCacheInt.createArray(this.arraySize);
        }

        void putArray(int[] nArray) {
            if (MarlinConst.DO_CHECKS && nArray.length != this.arraySize) {
                MarlinUtils.logInfo("ArrayCacheInt(Dirty): bad length = " + nArray.length);
                return;
            }
            if (MarlinConst.DO_STATS) {
                ++this.stats.returnOp;
            }
            if (this.arrays.length > this.tail) {
                this.arrays[this.tail++] = nArray;
                if (MarlinConst.DO_STATS) {
                    this.stats.updateMaxSize(this.tail);
                }
            } else if (MarlinConst.DO_CHECKS) {
                MarlinUtils.logInfo("ArrayCacheInt(Dirty): array capacity exceeded !");
            }
        }
    }

    static final class Reference {
        final int[] initial;
        private final ArrayCacheInt cache;

        Reference(ArrayCacheInt arrayCacheInt, int n2) {
            this.cache = arrayCacheInt;
            this.initial = ArrayCacheInt.createArray(n2);
            if (MarlinConst.DO_STATS) {
                arrayCacheInt.stats.totalInitial += (long)n2;
            }
        }

        int[] getArray(int n2) {
            if (n2 <= ArrayCacheConst.MAX_ARRAY_SIZE) {
                return this.cache.getCacheBucket(n2).getArray();
            }
            if (MarlinConst.DO_STATS) {
                ++this.cache.stats.oversize;
            }
            if (MarlinConst.DO_LOG_OVERSIZE) {
                MarlinUtils.logInfo("ArrayCacheInt(Dirty): getArray[oversize]: length=\t" + n2);
            }
            return ArrayCacheInt.createArray(n2);
        }

        int[] widenArray(int[] nArray, int n2, int n3) {
            int n4 = nArray.length;
            if (MarlinConst.DO_CHECKS && n4 >= n3) {
                return nArray;
            }
            if (MarlinConst.DO_STATS) {
                ++this.cache.stats.resize;
            }
            int[] nArray2 = this.getArray(ArrayCacheConst.getNewSize(n2, n3));
            System.arraycopy(nArray, 0, nArray2, 0, n2);
            this.putArray(nArray, 0, n2);
            if (MarlinConst.DO_LOG_WIDEN_ARRAY) {
                MarlinUtils.logInfo("ArrayCacheInt(Dirty): widenArray[" + nArray2.length + "]: usedSize=\t" + n2 + "\tlength=\t" + n4 + "\tneeded length=\t" + n3);
            }
            return nArray2;
        }

        boolean doCleanRef(int[] nArray) {
            return nArray != this.initial;
        }

        int[] putArray(int[] nArray) {
            return this.putArray(nArray, 0, nArray.length);
        }

        int[] putArray(int[] nArray, int n2, int n3) {
            if (nArray.length <= ArrayCacheConst.MAX_ARRAY_SIZE && nArray != this.initial) {
                this.cache.getCacheBucket(nArray.length).putArray(nArray);
            }
            return this.initial;
        }
    }
}

