/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.marlin.FloatMath;
import com.sun.marlin.MarlinConst;
import com.sun.marlin.MarlinUtils;

public final class MarlinProperties {
    private MarlinProperties() {
    }

    public static boolean isUseThreadLocal() {
        return MarlinProperties.getBoolean("prism.marlin.useThreadLocal", "true");
    }

    public static int getInitialEdges() {
        return MarlinProperties.align(MarlinProperties.getInteger("prism.marlin.edges", 4096, 64, 65536), 64);
    }

    public static int getInitialPixelWidth() {
        return MarlinProperties.align(MarlinProperties.getInteger("prism.marlin.pixelWidth", 4096, 64, 32768), 64);
    }

    public static int getInitialPixelHeight() {
        return MarlinProperties.align(MarlinProperties.getInteger("prism.marlin.pixelHeight", 2176, 64, 32768), 64);
    }

    public static boolean isProfileQuality() {
        String string = MarlinProperties.getString("prism.marlin.profile", "quality");
        if ("quality".equals(string)) {
            return true;
        }
        if ("speed".equals(string)) {
            return false;
        }
        MarlinUtils.logInfo("Invalid value for prism.marlin.profile = " + string + "; expect value in [quality, speed] !");
        return true;
    }

    public static int getSubPixel_Log2_X() {
        return MarlinProperties.getInteger("prism.marlin.subPixel_log2_X", 8, 0, 8);
    }

    public static int getSubPixel_Log2_Y() {
        int n2 = MarlinProperties.isProfileQuality() ? 3 : 2;
        return MarlinProperties.getInteger("prism.marlin.subPixel_log2_Y", n2, 0, 8);
    }

    public static int getBlockSize_Log2() {
        return MarlinProperties.getInteger("prism.marlin.blockSize_log2", 5, 3, 8);
    }

    public static boolean isForceRLE() {
        return MarlinProperties.getBoolean("prism.marlin.forceRLE", "false");
    }

    public static boolean isForceNoRLE() {
        return MarlinProperties.getBoolean("prism.marlin.forceNoRLE", "false");
    }

    public static boolean isUseTileFlags() {
        return MarlinProperties.getBoolean("prism.marlin.useTileFlags", "true");
    }

    public static boolean isUseTileFlagsWithHeuristics() {
        return MarlinProperties.isUseTileFlags() && MarlinProperties.getBoolean("prism.marlin.useTileFlags.useHeuristics", "true");
    }

    public static int getRLEMinWidth() {
        return MarlinProperties.getInteger("prism.marlin.rleMinWidth", 64, 0, Integer.MAX_VALUE);
    }

    public static boolean isUseSimplifier() {
        return MarlinProperties.getBoolean("prism.marlin.useSimplifier", "false");
    }

    public static boolean isUsePathSimplifier() {
        return MarlinProperties.getBoolean("prism.marlin.usePathSimplifier", "false");
    }

    public static float getPathSimplifierPixelTolerance() {
        return MarlinProperties.getFloat("prism.marlin.pathSimplifier.pixTol", 1.0f / MarlinConst.MIN_SUBPIXELS, 0.001f, 10.0f);
    }

    public static float getStrokerJoinError() {
        float f2 = 1.0f / MarlinConst.MIN_SUBPIXELS;
        float f3 = MarlinProperties.getFloat("prism.marlin.stroker.joinError", f2, -1.0f, 10.0f);
        return f3 < 0.0f ? f2 : f3;
    }

    public static int getStrokerJoinStyle() {
        return MarlinProperties.getInteger("prism.marlin.stroker.joinStyle", -1, -1, 2);
    }

    public static boolean isDoClip() {
        return MarlinProperties.getBoolean("prism.marlin.clip", "true");
    }

    public static boolean isDoClipRuntimeFlag() {
        return MarlinProperties.getBoolean("prism.marlin.clip.runtime.enable", "false");
    }

    public static boolean isDoClipAtRuntime() {
        return MarlinProperties.getBoolean("prism.marlin.clip.runtime", "true");
    }

    public static boolean isDoClipSubdivider() {
        return MarlinProperties.getBoolean("prism.marlin.clip.subdivider", "true");
    }

    public static float getSubdividerMinLength() {
        return MarlinProperties.getFloat("prism.marlin.clip.subdivider.minLength", 100.0f, Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY);
    }

    public static boolean isUseDPQS() {
        return MarlinProperties.getBoolean("prism.marlin.useDPQS", "true");
    }

    public static boolean isDoStats() {
        return MarlinProperties.getBoolean("prism.marlin.doStats", "false");
    }

    public static boolean isDoMonitors() {
        return MarlinProperties.getBoolean("prism.marlin.doMonitors", "false");
    }

    public static boolean isDoChecks() {
        return MarlinProperties.getBoolean("prism.marlin.doChecks", "false");
    }

    public static boolean isSkipRenderer() {
        return MarlinProperties.getBoolean("prism.marlin.skip_rdr", "false");
    }

    public static boolean isSkipRenderTiles() {
        return MarlinProperties.getBoolean("prism.marlin.skip_pipe", "false");
    }

    public static boolean isLoggingEnabled() {
        return MarlinProperties.getBoolean("prism.marlin.log", "false");
    }

    public static boolean isUseLogger() {
        return MarlinProperties.getBoolean("prism.marlin.useLogger", "false");
    }

    public static boolean isLogCreateContext() {
        return MarlinProperties.getBoolean("prism.marlin.logCreateContext", "false");
    }

    public static boolean isLogUnsafeMalloc() {
        return MarlinProperties.getBoolean("prism.marlin.logUnsafeMalloc", "false");
    }

    public static float getCurveLengthError() {
        return MarlinProperties.getFloat("prism.marlin.curve_len_err", 0.01f, 1.0E-6f, 1.0f);
    }

    public static float getCubicDecD2() {
        float f2 = MarlinProperties.isProfileQuality() ? 1.0f : 2.5f;
        return MarlinProperties.getFloat("prism.marlin.cubic_dec_d2", f2, 1.0E-5f, 4.0f);
    }

    public static float getCubicIncD1() {
        float f2 = MarlinProperties.isProfileQuality() ? 0.2f : 0.5f;
        return MarlinProperties.getFloat("prism.marlin.cubic_inc_d1", f2, 1.0E-6f, 1.0f);
    }

    public static float getQuadDecD2() {
        float f2 = MarlinProperties.isProfileQuality() ? 0.5f : 1.0f;
        return MarlinProperties.getFloat("prism.marlin.quad_dec_d2", f2, 1.0E-5f, 4.0f);
    }

    static String getString(String string, String string2) {
        String string3 = System.getProperty(string);
        return string3 == null ? string2 : string3;
    }

    static boolean getBoolean(String string, String string2) {
        String string3 = System.getProperty(string);
        return Boolean.valueOf(string3 == null ? string2 : string3);
    }

    static int getInteger(String string, int n2, int n3, int n4) {
        String string2 = System.getProperty(string);
        int n5 = n2;
        if (string2 != null) {
            try {
                n5 = Integer.decode(string2);
            }
            catch (NumberFormatException numberFormatException) {
                MarlinUtils.logInfo("Invalid integer value for " + string + " = " + string2);
            }
        }
        if (n5 < n3 || n5 > n4) {
            MarlinUtils.logInfo("Invalid value for " + string + " = " + n5 + "; expected value in range[" + n3 + ", " + n4 + "] !");
            n5 = n2;
        }
        return n5;
    }

    static int align(int n2, int n3) {
        int n4 = FloatMath.ceil_int((float)n2 / (float)n3);
        return n4 * n3;
    }

    public static double getDouble(String string, double d2, double d3, double d4) {
        double d5 = d2;
        String string2 = System.getProperty(string);
        if (string2 != null) {
            try {
                d5 = Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {
                MarlinUtils.logInfo("Invalid value for " + string + " = " + string2 + " !");
            }
        }
        if (d5 < d3 || d5 > d4) {
            MarlinUtils.logInfo("Invalid value for " + string + " = " + d5 + "; expect value in range[" + d3 + ", " + d4 + "] !");
            d5 = d2;
        }
        return d5;
    }

    public static float getFloat(String string, float f2, float f3, float f4) {
        return (float)MarlinProperties.getDouble(string, f2, f3, f4);
    }
}

