/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.marlin.ArrayCacheConst;
import com.sun.marlin.ArrayCacheInt;
import com.sun.marlin.ArrayCacheIntClean;
import com.sun.marlin.Curve;
import com.sun.marlin.DPQSSorterContext;
import com.sun.marlin.FloatMath;
import com.sun.marlin.MarlinAlphaConsumer;
import com.sun.marlin.MarlinConst;
import com.sun.marlin.MarlinProperties;
import com.sun.marlin.MarlinRenderer;
import com.sun.marlin.MarlinUtils;
import com.sun.marlin.MergeSort;
import com.sun.marlin.OffHeapArray;
import com.sun.marlin.RendererContext;
import sun.misc.Unsafe;

public final class Renderer
implements MarlinRenderer,
MarlinConst {
    static final boolean DISABLE_RENDER = MarlinProperties.isSkipRenderer();
    private static final int ALL_BUT_LSB = -2;
    private static final int ERR_STEP_MAX = Integer.MAX_VALUE;
    private static final double POWER_2_TO_32 = 4.294967296E9;
    static final double SUBPIXEL_SCALE_X = SUBPIXEL_POSITIONS_X;
    static final double SUBPIXEL_SCALE_Y = SUBPIXEL_POSITIONS_Y;
    static final int SUBPIXEL_MASK_X = SUBPIXEL_POSITIONS_X - 1;
    static final int SUBPIXEL_MASK_Y = SUBPIXEL_POSITIONS_Y - 1;
    private static final double RDR_OFFSET_X = 0.5 / SUBPIXEL_SCALE_X;
    private static final double RDR_OFFSET_Y = 0.5 / SUBPIXEL_SCALE_Y;
    public static final long OFF_CURX_OR = 0L;
    public static final long OFF_ERROR = 0L + (long)OffHeapArray.SIZE_INT;
    public static final long OFF_BUMP_X = OFF_ERROR + (long)OffHeapArray.SIZE_INT;
    public static final long OFF_BUMP_ERR = OFF_BUMP_X + (long)OffHeapArray.SIZE_INT;
    public static final long OFF_NEXT = OFF_BUMP_ERR + (long)OffHeapArray.SIZE_INT;
    public static final long OFF_YMAX = OFF_NEXT + (long)OffHeapArray.SIZE_INT;
    public static final int SIZEOF_EDGE_BYTES = (int)(OFF_YMAX + (long)OffHeapArray.SIZE_INT);
    private static final double CUB_DEC_ERR_SUBPIX = (double)MarlinProperties.getCubicDecD2() * ((double)SUBPIXEL_POSITIONS_X / 8.0);
    private static final double CUB_INC_ERR_SUBPIX = (double)MarlinProperties.getCubicIncD1() * ((double)SUBPIXEL_POSITIONS_X / 8.0);
    public static final double SCALE_DY = (double)SUBPIXEL_POSITIONS_X / (double)SUBPIXEL_POSITIONS_Y;
    public static final double CUB_DEC_BND = 8.0 * CUB_DEC_ERR_SUBPIX;
    public static final double CUB_INC_BND = 8.0 * CUB_INC_ERR_SUBPIX;
    public static final int CUB_COUNT_LG = 2;
    private static final int CUB_COUNT = 4;
    private static final int CUB_COUNT_2 = 16;
    private static final int CUB_COUNT_3 = 64;
    private static final double CUB_INV_COUNT = 0.25;
    private static final double CUB_INV_COUNT_2 = 0.0625;
    private static final double CUB_INV_COUNT_3 = 0.015625;
    private static final double QUAD_DEC_ERR_SUBPIX = (double)MarlinProperties.getQuadDecD2() * ((double)SUBPIXEL_POSITIONS_X / 8.0);
    public static final double QUAD_DEC_BND = 8.0 * QUAD_DEC_ERR_SUBPIX;
    private int[] crossings;
    private int[] aux_crossings;
    private int edgeCount;
    private int[] edgePtrs;
    private int[] aux_edgePtrs;
    private int activeEdgeMaxUsed;
    private final ArrayCacheInt.Reference crossings_ref;
    private final ArrayCacheInt.Reference edgePtrs_ref;
    private final ArrayCacheInt.Reference aux_crossings_ref;
    private final ArrayCacheInt.Reference aux_edgePtrs_ref;
    private int edgeMinY = Integer.MAX_VALUE;
    private int edgeMaxY = Integer.MIN_VALUE;
    private double edgeMinX = Double.POSITIVE_INFINITY;
    private double edgeMaxX = Double.NEGATIVE_INFINITY;
    private final OffHeapArray edges;
    private int[] edgeBuckets;
    private int[] edgeBucketCounts;
    private int buckets_minY;
    private int buckets_maxY;
    private final ArrayCacheIntClean.Reference edgeBuckets_ref;
    private final ArrayCacheIntClean.Reference edgeBucketCounts_ref;
    boolean useRLE = false;
    private int boundsMinX;
    private int boundsMinY;
    private int boundsMaxX;
    private int boundsMaxY;
    private int windingRule;
    private double x0;
    private double y0;
    private double sx0;
    private double sy0;
    final RendererContext rdrCtx;
    private final Curve curve;
    private int[] alphaLine;
    private final ArrayCacheIntClean.Reference alphaLine_ref;
    private boolean enableBlkFlags = false;
    private boolean prevUseBlkFlags = false;
    private int[] blkFlags;
    private final ArrayCacheIntClean.Reference blkFlags_ref;
    private int bbox_spminX;
    private int bbox_spmaxX;
    private int bbox_spminY;
    private int bbox_spmaxY;
    int bboxX0;
    int bboxX1;
    int bboxY0;
    int bboxY1;

    private void quadBreakIntoLinesAndAdd(double d2, double d3, Curve curve, double d4, double d5) {
        int n2 = 1;
        double d6 = Math.abs(curve.dbx) + Math.abs(curve.dby) * SCALE_DY;
        double d7 = QUAD_DEC_BND;
        while (d6 >= d7) {
            d6 /= 4.0;
            n2 <<= 1;
            if (!DO_STATS) continue;
            this.rdrCtx.stats.stat_rdr_quadBreak_dec.add(n2);
        }
        int n3 = n2;
        if (n2 > 1) {
            double d8 = 1.0 / (double)n2;
            double d9 = d8 * d8;
            double d10 = curve.dbx * d9;
            double d11 = curve.dby * d9;
            double d12 = curve.bx * d9 + curve.cx * d8;
            double d13 = curve.by * d9 + curve.cy * d8;
            double d14 = d2;
            double d15 = d3;
            while (--n2 > 0) {
                this.addLine(d2, d3, d14 += d12, d15 += d13);
                d2 = d14;
                d3 = d15;
                d12 += d10;
                d13 += d11;
            }
        }
        this.addLine(d2, d3, d4, d5);
        if (DO_STATS) {
            this.rdrCtx.stats.stat_rdr_quadBreak.add(n3);
        }
    }

    private void curveBreakIntoLinesAndAdd(double d2, double d3, Curve curve, double d4, double d5) {
        int n2 = 4;
        double d6 = 2.0 * curve.dax * 0.015625;
        double d7 = 2.0 * curve.day * 0.015625;
        double d8 = d6 + curve.dbx * 0.0625;
        double d9 = d7 + curve.dby * 0.0625;
        double d10 = curve.ax * 0.015625 + curve.bx * 0.0625 + curve.cx * 0.25;
        double d11 = curve.ay * 0.015625 + curve.by * 0.0625 + curve.cy * 0.25;
        int n3 = 0;
        double d12 = CUB_DEC_BND;
        double d13 = CUB_INC_BND;
        double d14 = SCALE_DY;
        double d15 = d2;
        double d16 = d3;
        while (n2 > 0) {
            while (n2 % 2 == 0 && Math.abs(d8) + Math.abs(d9) * d14 <= d13) {
                d10 = 2.0 * d10 + d8;
                d11 = 2.0 * d11 + d9;
                d8 = 4.0 * (d8 + d6);
                d9 = 4.0 * (d9 + d7);
                d6 *= 8.0;
                d7 *= 8.0;
                n2 >>= 1;
                if (!DO_STATS) continue;
                this.rdrCtx.stats.stat_rdr_curveBreak_inc.add(n2);
            }
            while (Math.abs(d8) + Math.abs(d9) * d14 >= d12) {
                d8 = d8 / 4.0 - (d6 /= 8.0);
                d9 = d9 / 4.0 - (d7 /= 8.0);
                d10 = (d10 - d8) / 2.0;
                d11 = (d11 - d9) / 2.0;
                n2 <<= 1;
                if (!DO_STATS) continue;
                this.rdrCtx.stats.stat_rdr_curveBreak_dec.add(n2);
            }
            if (--n2 == 0) break;
            d8 += d6;
            this.addLine(d2, d3, d15 += (d10 += d8), d16 += (d11 += (d9 += d7)));
            d2 = d15;
            d3 = d16;
        }
        this.addLine(d2, d3, d4, d5);
        if (DO_STATS) {
            this.rdrCtx.stats.stat_rdr_curveBreak.add(n3 + 1);
        }
    }

    private void addLine(double d2, double d3, double d4, double d5) {
        double d6;
        int n2;
        int n3;
        if (DO_STATS) {
            this.rdrCtx.stats.stat_rdr_addLine.add(1);
        }
        int n4 = 1;
        if (d5 < d3) {
            n4 = 0;
            double d7 = d5;
            d5 = d3;
            d3 = d7;
            d7 = d4;
            d4 = d2;
            d2 = d7;
        }
        if ((n3 = FloatMath.max(FloatMath.ceil_int(d3), this.boundsMinY)) >= (n2 = FloatMath.min(FloatMath.ceil_int(d5), this.boundsMaxY))) {
            if (DO_STATS) {
                this.rdrCtx.stats.stat_rdr_addLine_skip.add(1);
            }
            return;
        }
        if (n3 < this.edgeMinY) {
            this.edgeMinY = n3;
        }
        if (n2 > this.edgeMaxY) {
            this.edgeMaxY = n2;
        }
        if ((d6 = (d2 - d4) / (d3 - d5)) >= 0.0) {
            if (d2 < this.edgeMinX) {
                this.edgeMinX = d2;
            }
            if (d4 > this.edgeMaxX) {
                this.edgeMaxX = d4;
            }
        } else {
            if (d4 < this.edgeMinX) {
                this.edgeMinX = d4;
            }
            if (d2 > this.edgeMaxX) {
                this.edgeMaxX = d2;
            }
        }
        int n5 = SIZEOF_EDGE_BYTES;
        OffHeapArray offHeapArray = this.edges;
        int n6 = offHeapArray.used;
        if (offHeapArray.length - (long)n6 < (long)n5) {
            long l2 = ArrayCacheConst.getNewLargeSize(offHeapArray.length, n6 + n5);
            if (DO_STATS) {
                this.rdrCtx.stats.stat_rdr_edges_resizes.add(l2);
            }
            offHeapArray.resize(l2);
        }
        Unsafe unsafe = OffHeapArray.UNSAFE;
        long l3 = offHeapArray.address + (long)n6;
        double d8 = d2 + ((double)n3 - d3) * d6;
        long l4 = (long)(4.294967296E9 * d8) + Integer.MAX_VALUE;
        unsafe.putInt(l3, (int)(l4 >> 31) & 0xFFFFFFFE | n4);
        unsafe.putInt(l3 += 4L, (int)l4 >>> 1);
        long l5 = (long)(4.294967296E9 * d6);
        unsafe.putInt(l3 += 4L, (int)(l5 >> 31) & 0xFFFFFFFE);
        unsafe.putInt(l3 += 4L, (int)l5 >>> 1);
        int[] nArray = this.edgeBuckets;
        int[] nArray2 = this.edgeBucketCounts;
        int n7 = this.boundsMinY;
        int n8 = n3 - n7;
        unsafe.putInt(l3 += 4L, nArray[n8]);
        unsafe.putInt(l3 += 4L, n2);
        nArray[n8] = n6;
        int n9 = n8;
        nArray2[n9] = nArray2[n9] + 2;
        int n10 = n2 - n7;
        nArray2[n10] = nArray2[n10] | 1;
        offHeapArray.used += n5;
    }

    Renderer(RendererContext rendererContext) {
        this.rdrCtx = rendererContext;
        this.curve = rendererContext.curve;
        this.edges = rendererContext.rdrMem.edges;
        this.edgeBuckets_ref = rendererContext.rdrMem.edgeBuckets_ref;
        this.edgeBucketCounts_ref = rendererContext.rdrMem.edgeBucketCounts_ref;
        this.edgeBuckets = this.edgeBuckets_ref.initial;
        this.edgeBucketCounts = this.edgeBucketCounts_ref.initial;
        this.alphaLine_ref = rendererContext.rdrMem.alphaLine_ref;
        this.alphaLine = this.alphaLine_ref.initial;
        this.crossings_ref = rendererContext.rdrMem.crossings_ref;
        this.aux_crossings_ref = rendererContext.rdrMem.aux_crossings_ref;
        this.edgePtrs_ref = rendererContext.rdrMem.edgePtrs_ref;
        this.aux_edgePtrs_ref = rendererContext.rdrMem.aux_edgePtrs_ref;
        this.crossings = this.crossings_ref.initial;
        this.aux_crossings = this.aux_crossings_ref.initial;
        this.edgePtrs = this.edgePtrs_ref.initial;
        this.aux_edgePtrs = this.aux_edgePtrs_ref.initial;
        this.blkFlags_ref = rendererContext.rdrMem.blkFlags_ref;
        this.blkFlags = this.blkFlags_ref.initial;
    }

    @Override
    public Renderer init(int n2, int n3, int n4, int n5, int n6) {
        int n7;
        this.windingRule = n6;
        this.boundsMinX = n2 << SUBPIXEL_LG_POSITIONS_X;
        this.boundsMaxX = n2 + n4 << SUBPIXEL_LG_POSITIONS_X;
        this.boundsMinY = n3 << SUBPIXEL_LG_POSITIONS_Y;
        this.boundsMaxY = n3 + n5 << SUBPIXEL_LG_POSITIONS_Y;
        if (DO_LOG_BOUNDS) {
            MarlinUtils.logInfo("boundsXY = [" + this.boundsMinX + " ... " + this.boundsMaxX + "[ [" + this.boundsMinY + " ... " + this.boundsMaxY + "[");
        }
        if ((n7 = this.boundsMaxY - this.boundsMinY + 1) > INITIAL_BUCKET_ARRAY) {
            if (DO_STATS) {
                this.rdrCtx.stats.stat_array_renderer_edgeBuckets.add(n7);
                this.rdrCtx.stats.stat_array_renderer_edgeBucketCounts.add(n7);
            }
            this.edgeBuckets = this.edgeBuckets_ref.getArray(n7);
            this.edgeBucketCounts = this.edgeBucketCounts_ref.getArray(n7);
        }
        this.edgeMinY = Integer.MAX_VALUE;
        this.edgeMaxY = Integer.MIN_VALUE;
        this.edgeMinX = Double.POSITIVE_INFINITY;
        this.edgeMaxX = Double.NEGATIVE_INFINITY;
        this.edgeCount = 0;
        this.activeEdgeMaxUsed = 0;
        this.edges.used = 0;
        this.bboxX0 = 0;
        this.bboxX1 = 0;
        return this;
    }

    @Override
    public void dispose() {
        if (DO_STATS) {
            this.rdrCtx.stats.stat_rdr_activeEdges.add(this.activeEdgeMaxUsed);
            this.rdrCtx.stats.stat_rdr_edges.add(this.edges.used);
            this.rdrCtx.stats.stat_rdr_edges_count.add(this.edges.used / SIZEOF_EDGE_BYTES);
            this.rdrCtx.stats.hist_rdr_edges_count.add(this.edges.used / SIZEOF_EDGE_BYTES);
            this.rdrCtx.stats.totalOffHeap += this.edges.length;
        }
        if (this.crossings_ref.doCleanRef(this.crossings)) {
            this.crossings = this.crossings_ref.putArray(this.crossings);
        }
        if (this.aux_crossings_ref.doCleanRef(this.aux_crossings)) {
            this.aux_crossings = this.aux_crossings_ref.putArray(this.aux_crossings);
        }
        if (this.edgePtrs_ref.doCleanRef(this.edgePtrs)) {
            this.edgePtrs = this.edgePtrs_ref.putArray(this.edgePtrs);
        }
        if (this.aux_edgePtrs_ref.doCleanRef(this.aux_edgePtrs)) {
            this.aux_edgePtrs = this.aux_edgePtrs_ref.putArray(this.aux_edgePtrs);
        }
        if (this.alphaLine_ref.doSetRef(this.alphaLine)) {
            this.alphaLine = this.alphaLine_ref.putArrayClean(this.alphaLine);
        }
        if (this.blkFlags_ref.doSetRef(this.blkFlags)) {
            this.blkFlags = this.blkFlags_ref.putArrayClean(this.blkFlags);
        }
        if (this.edgeMinY != Integer.MAX_VALUE) {
            if (this.rdrCtx.dirty) {
                this.buckets_minY = 0;
                this.buckets_maxY = this.boundsMaxY - this.boundsMinY;
            }
            this.edgeBuckets = this.edgeBuckets_ref.putArray(this.edgeBuckets, this.buckets_minY, this.buckets_maxY);
            this.edgeBucketCounts = this.edgeBucketCounts_ref.putArray(this.edgeBucketCounts, this.buckets_minY, this.buckets_maxY + 1);
        } else {
            if (this.edgeBuckets_ref.doSetRef(this.edgeBuckets)) {
                this.edgeBuckets = this.edgeBuckets_ref.putArrayClean(this.edgeBuckets);
            }
            if (this.edgeBucketCounts_ref.doSetRef(this.edgeBucketCounts)) {
                this.edgeBucketCounts = this.edgeBucketCounts_ref.putArrayClean(this.edgeBucketCounts);
            }
        }
        if (this.edges.length != (long)INITIAL_EDGES_CAPACITY) {
            this.edges.resize(INITIAL_EDGES_CAPACITY);
        }
    }

    private static double tosubpixx(double d2) {
        return SUBPIXEL_SCALE_X * d2;
    }

    private static double tosubpixy(double d2) {
        return SUBPIXEL_SCALE_Y * d2 - 0.5;
    }

    @Override
    public void moveTo(double d2, double d3) {
        this.closePath();
        double d4 = Renderer.tosubpixx(d2);
        double d5 = Renderer.tosubpixy(d3);
        this.sx0 = d4;
        this.sy0 = d5;
        this.x0 = d4;
        this.y0 = d5;
    }

    @Override
    public void lineTo(double d2, double d3) {
        double d4 = Renderer.tosubpixx(d2);
        double d5 = Renderer.tosubpixy(d3);
        this.addLine(this.x0, this.y0, d4, d5);
        this.x0 = d4;
        this.y0 = d5;
    }

    @Override
    public void curveTo(double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = Renderer.tosubpixx(d6);
        double d9 = Renderer.tosubpixy(d7);
        this.curve.set(this.x0, this.y0, Renderer.tosubpixx(d2), Renderer.tosubpixy(d3), Renderer.tosubpixx(d4), Renderer.tosubpixy(d5), d8, d9);
        this.curveBreakIntoLinesAndAdd(this.x0, this.y0, this.curve, d8, d9);
        this.x0 = d8;
        this.y0 = d9;
    }

    @Override
    public void quadTo(double d2, double d3, double d4, double d5) {
        double d6 = Renderer.tosubpixx(d4);
        double d7 = Renderer.tosubpixy(d5);
        this.curve.set(this.x0, this.y0, Renderer.tosubpixx(d2), Renderer.tosubpixy(d3), d6, d7);
        this.quadBreakIntoLinesAndAdd(this.x0, this.y0, this.curve, d6, d7);
        this.x0 = d6;
        this.y0 = d7;
    }

    @Override
    public void closePath() {
        if (this.x0 != this.sx0 || this.y0 != this.sy0) {
            this.addLine(this.x0, this.y0, this.sx0, this.sy0);
            this.x0 = this.sx0;
            this.y0 = this.sy0;
        }
    }

    @Override
    public void pathDone() {
        this.closePath();
        this.endRendering();
    }

    private void _endRendering(int n2, int n3, MarlinAlphaConsumer marlinAlphaConsumer) {
        if (DISABLE_RENDER) {
            return;
        }
        int n4 = this.bbox_spminX;
        int n5 = this.bbox_spmaxX;
        boolean bl = this.windingRule == 0;
        int[] nArray = this.alphaLine;
        OffHeapArray offHeapArray = this.edges;
        int[] nArray2 = this.edgeBuckets;
        int[] nArray3 = this.edgeBucketCounts;
        int[] nArray4 = this.crossings;
        int[] nArray5 = this.edgePtrs;
        int[] nArray6 = this.aux_crossings;
        int[] nArray7 = this.aux_edgePtrs;
        long l2 = OFF_ERROR;
        long l3 = OFF_BUMP_X;
        long l4 = OFF_BUMP_ERR;
        long l5 = OFF_NEXT;
        long l6 = OFF_YMAX;
        Unsafe unsafe = OffHeapArray.UNSAFE;
        long l7 = offHeapArray.address;
        int n6 = SUBPIXEL_LG_POSITIONS_X;
        int n7 = SUBPIXEL_LG_POSITIONS_Y;
        int n8 = SUBPIXEL_MASK_X;
        int n9 = SUBPIXEL_MASK_Y;
        int n10 = SUBPIXEL_POSITIONS_X;
        int n11 = Integer.MAX_VALUE;
        int n12 = Integer.MIN_VALUE;
        int n13 = n2;
        int n14 = n13 - this.boundsMinY;
        int n15 = this.edgeCount;
        int n16 = nArray5.length;
        int n17 = nArray4.length;
        int n18 = this.activeEdgeMaxUsed;
        int n19 = 0;
        int[] nArray8 = this.blkFlags;
        int n20 = BLOCK_SIZE_LG;
        int n21 = BLOCK_SIZE;
        boolean bl2 = ENABLE_BLOCK_FLAGS_HEURISTICS && this.enableBlkFlags;
        boolean bl3 = this.prevUseBlkFlags;
        int n22 = this.rdrCtx.stroking;
        int n23 = -1;
        DPQSSorterContext dPQSSorterContext = this.rdrCtx.sorterCtx;
        while (n13 < n3) {
            int n24;
            int n25;
            int n26;
            long l8;
            int n27 = nArray3[n14];
            int n28 = n15;
            if (n27 != 0) {
                if (DO_STATS) {
                    this.rdrCtx.stats.stat_rdr_activeEdges_updates.add(n28);
                }
                if ((n27 & 1) != 0) {
                    l8 = l7 + l6;
                    int n29 = 0;
                    for (n26 = 0; n26 < n28; ++n26) {
                        n25 = nArray5[n26];
                        if (unsafe.getInt(l8 + (long)n25) <= n13) continue;
                        nArray5[n29++] = n25;
                    }
                    n28 = n15 = n29;
                }
                if ((n19 = n27 >> 1) != 0) {
                    int n30;
                    if (DO_STATS) {
                        this.rdrCtx.stats.stat_rdr_activeEdges_adds.add(n19);
                        if (n19 > 10) {
                            this.rdrCtx.stats.stat_rdr_activeEdges_adds_high.add(n19);
                        }
                    }
                    if (n16 < (n30 = n15 + n19)) {
                        if (DO_STATS) {
                            this.rdrCtx.stats.stat_array_renderer_edgePtrs.add(n30);
                        }
                        this.edgePtrs = nArray5 = this.edgePtrs_ref.widenArray(nArray5, n16, n30);
                        n16 = nArray5.length;
                        this.aux_edgePtrs_ref.putArray(nArray7);
                        if (DO_STATS) {
                            this.rdrCtx.stats.stat_array_renderer_aux_edgePtrs.add(n30);
                        }
                        this.aux_edgePtrs = nArray7 = this.aux_edgePtrs_ref.getArray(ArrayCacheConst.getNewSize(n15, n30));
                    }
                    l8 = l7 + l5;
                    n25 = nArray2[n14];
                    while (n15 < n30) {
                        nArray5[n15] = n25;
                        n25 = unsafe.getInt(l8 + (long)n25);
                        ++n15;
                    }
                    if (n17 < n15) {
                        this.crossings_ref.putArray(nArray4);
                        if (DO_STATS) {
                            this.rdrCtx.stats.stat_array_renderer_crossings.add(n15);
                        }
                        this.crossings = nArray4 = this.crossings_ref.getArray(n15);
                        this.aux_crossings_ref.putArray(nArray6);
                        if (DO_STATS) {
                            this.rdrCtx.stats.stat_array_renderer_aux_crossings.add(n15);
                        }
                        this.aux_crossings = nArray6 = this.aux_crossings_ref.getArray(n15);
                        n17 = nArray4.length;
                    }
                    if (DO_STATS && n15 > n18) {
                        n18 = n15;
                    }
                }
            }
            if (n15 != 0) {
                int n31;
                int n32;
                if (n15 <= 40 || n19 <= 10 && n15 <= 1000) {
                    if (DO_STATS) {
                        this.rdrCtx.stats.hist_rdr_crossings.add(n15);
                        this.rdrCtx.stats.hist_rdr_crossings_adds.add(n19);
                    }
                    boolean bl4 = n15 >= 20;
                    var51_52 = Integer.MIN_VALUE;
                    for (n26 = 0; n26 < n15; ++n26) {
                        n25 = nArray5[n26];
                        l8 = l7 + (long)n25;
                        var50_51 = n32 = unsafe.getInt(l8);
                        var60_61 = unsafe.getInt(l8 + l2) + unsafe.getInt(l8 + l4);
                        unsafe.putInt(l8, (n32 += unsafe.getInt(l8 + l3)) - (var60_61 >> 30 & 0xFFFFFFFE));
                        unsafe.putInt(l8 + l2, var60_61 & Integer.MAX_VALUE);
                        if (DO_STATS) {
                            this.rdrCtx.stats.stat_rdr_crossings_updates.add(n15);
                        }
                        if (var50_51 < var51_52) {
                            if (DO_STATS) {
                                this.rdrCtx.stats.stat_rdr_crossings_sorts.add(n26);
                            }
                            if (bl4 && n26 >= n28) {
                                if (DO_STATS) {
                                    this.rdrCtx.stats.stat_rdr_crossings_bsearch.add(n26);
                                }
                                int n33 = 0;
                                int n34 = n26 - 1;
                                do {
                                    int n35;
                                    if (nArray4[n35 = n33 + n34 >> 1] < var50_51) {
                                        n33 = n35 + 1;
                                        continue;
                                    }
                                    n34 = n35 - 1;
                                } while (n33 <= n34);
                                for (var48_49 = n26 - 1; var48_49 >= n33; --var48_49) {
                                    nArray4[var48_49 + 1] = nArray4[var48_49];
                                    nArray5[var48_49 + 1] = nArray5[var48_49];
                                }
                                nArray4[n33] = var50_51;
                                nArray5[n33] = n25;
                                continue;
                            }
                            var48_49 = n26 - 1;
                            nArray4[n26] = nArray4[var48_49];
                            nArray5[n26] = nArray5[var48_49];
                            while (--var48_49 >= 0 && nArray4[var48_49] > var50_51) {
                                nArray4[var48_49 + 1] = nArray4[var48_49];
                                nArray5[var48_49 + 1] = nArray5[var48_49];
                            }
                            nArray4[var48_49 + 1] = var50_51;
                            nArray5[var48_49 + 1] = n25;
                            continue;
                        }
                        nArray4[n26] = var51_52 = var50_51;
                    }
                } else {
                    boolean bl5;
                    if (DO_STATS) {
                        this.rdrCtx.stats.stat_rdr_crossings_msorts.add(n15);
                        this.rdrCtx.stats.hist_rdr_crossings_ratio.add(1000 * n19 / n15);
                        this.rdrCtx.stats.hist_rdr_crossings_msorts.add(n15);
                        this.rdrCtx.stats.hist_rdr_crossings_msorts_adds.add(n19);
                    }
                    boolean bl6 = n28 >= 1000;
                    boolean bl7 = bl5 = MergeSort.USE_DPQS && (bl6 || n19 >= 256);
                    if (DO_STATS && bl5) {
                        this.rdrCtx.stats.stat_rdr_crossings_dpqs.add(bl6 ? n15 : n19);
                    }
                    var51_52 = Integer.MIN_VALUE;
                    for (n26 = 0; n26 < n15; ++n26) {
                        n25 = nArray5[n26];
                        l8 = l7 + (long)n25;
                        var50_51 = n32 = unsafe.getInt(l8);
                        var60_61 = unsafe.getInt(l8 + l2) + unsafe.getInt(l8 + l4);
                        unsafe.putInt(l8, (n32 += unsafe.getInt(l8 + l3)) - (var60_61 >> 30 & 0xFFFFFFFE));
                        unsafe.putInt(l8 + l2, var60_61 & Integer.MAX_VALUE);
                        if (DO_STATS) {
                            this.rdrCtx.stats.stat_rdr_crossings_updates.add(n15);
                        }
                        if (bl6) {
                            if (bl5) {
                                nArray4[n26] = var50_51;
                                continue;
                            }
                            nArray6[n26] = var50_51;
                            nArray7[n26] = n25;
                            continue;
                        }
                        if (n26 >= n28) {
                            if (bl5) {
                                nArray6[n26] = var50_51;
                                nArray7[n26] = n25;
                                continue;
                            }
                            nArray4[n26] = var50_51;
                            continue;
                        }
                        if (var50_51 < var51_52) {
                            if (DO_STATS) {
                                this.rdrCtx.stats.stat_rdr_crossings_sorts.add(n26);
                            }
                            var48_49 = n26 - 1;
                            nArray6[n26] = nArray6[var48_49];
                            nArray7[n26] = nArray7[var48_49];
                            while (--var48_49 >= 0 && nArray6[var48_49] > var50_51) {
                                nArray6[var48_49 + 1] = nArray6[var48_49];
                                nArray7[var48_49 + 1] = nArray7[var48_49];
                            }
                            nArray6[var48_49 + 1] = var50_51;
                            nArray7[var48_49 + 1] = n25;
                            continue;
                        }
                        nArray6[n26] = var51_52 = var50_51;
                        nArray7[n26] = n25;
                    }
                    MergeSort.mergeSortNoCopy(nArray4, nArray5, nArray6, nArray7, n15, n28, bl6, dPQSSorterContext, bl5);
                }
                n19 = 0;
                int n36 = nArray4[0];
                int n37 = n36 >> 1;
                if (n37 < n11) {
                    n11 = n37;
                }
                if ((n31 = nArray4[n15 - 1] >> 1) > n12) {
                    n12 = n31;
                }
                int n38 = n32 = n37;
                int n39 = ((n36 & 1) << 1) - 1;
                if (bl) {
                    var55_56 = n39;
                    for (n26 = 1; n26 < n15; ++n26) {
                        n36 = nArray4[n26];
                        n32 = n36 >> 1;
                        n39 = ((n36 & 1) << 1) - 1;
                        if ((var55_56 & 1) != 0) {
                            int n40 = n37 = n38 > n4 ? n38 : n4;
                            if (n32 < n5) {
                                n31 = n32;
                            } else {
                                n31 = n5;
                                n26 = n15;
                            }
                            if (n37 < n31) {
                                var61_62 = (n37 -= n4) >> n6;
                                var62_63 = (n31 -= n4) - 1 >> n6;
                                if (var61_62 == var62_63) {
                                    n24 = n31 - n37;
                                    int n41 = var61_62;
                                    nArray[n41] = nArray[n41] + n24;
                                    int n42 = var61_62 + 1;
                                    nArray[n42] = nArray[n42] - n24;
                                    if (bl3) {
                                        nArray8[var61_62 >> n20] = 1;
                                    }
                                } else {
                                    n24 = n37 & n8;
                                    int n43 = var61_62;
                                    nArray[n43] = nArray[n43] + (n10 - n24);
                                    int n44 = var61_62 + 1;
                                    nArray[n44] = nArray[n44] + n24;
                                    var63_64 = n31 >> n6;
                                    n24 = n31 & n8;
                                    int n45 = var63_64;
                                    nArray[n45] = nArray[n45] - (n10 - n24);
                                    int n46 = var63_64 + 1;
                                    nArray[n46] = nArray[n46] - n24;
                                    if (bl3) {
                                        nArray8[var61_62 >> n20] = 1;
                                        nArray8[var63_64 >> n20] = 1;
                                    }
                                }
                            }
                        }
                        var55_56 += n39;
                        n38 = n32;
                    }
                } else {
                    n26 = 1;
                    var55_56 = 0;
                    while (true) {
                        if ((var55_56 += n39) != 0) {
                            if (n38 > n32) {
                                n38 = n32;
                            }
                        } else {
                            int n47 = n37 = n38 > n4 ? n38 : n4;
                            if (n32 < n5) {
                                n31 = n32;
                            } else {
                                n31 = n5;
                                n26 = n15;
                            }
                            if (n37 < n31) {
                                var61_62 = (n37 -= n4) >> n6;
                                var62_63 = (n31 -= n4) - 1 >> n6;
                                if (var61_62 == var62_63) {
                                    n24 = n31 - n37;
                                    int n48 = var61_62;
                                    nArray[n48] = nArray[n48] + n24;
                                    int n49 = var61_62 + 1;
                                    nArray[n49] = nArray[n49] - n24;
                                    if (bl3) {
                                        nArray8[var61_62 >> n20] = 1;
                                    }
                                } else {
                                    n24 = n37 & n8;
                                    int n50 = var61_62;
                                    nArray[n50] = nArray[n50] + (n10 - n24);
                                    int n51 = var61_62 + 1;
                                    nArray[n51] = nArray[n51] + n24;
                                    var63_64 = n31 >> n6;
                                    n24 = n31 & n8;
                                    int n52 = var63_64;
                                    nArray[n52] = nArray[n52] - (n10 - n24);
                                    int n53 = var63_64 + 1;
                                    nArray[n53] = nArray[n53] - n24;
                                    if (bl3) {
                                        nArray8[var61_62 >> n20] = 1;
                                        nArray8[var63_64 >> n20] = 1;
                                    }
                                }
                            }
                            n38 = Integer.MAX_VALUE;
                        }
                        if (n26 == n15) break;
                        n36 = nArray4[n26];
                        n32 = n36 >> 1;
                        n39 = ((n36 & 1) << 1) - 1;
                        ++n26;
                    }
                }
            }
            if ((n13 & n9) == n9) {
                n23 = n13 >> n7;
                n11 = FloatMath.max(n11, n4) >> n6;
                if ((n12 = FloatMath.min(n12, n5) >> n6) >= n11) {
                    this.copyAARow(nArray, n23, n11, n12 + 1, bl3, marlinAlphaConsumer);
                    if (bl2) {
                        boolean bl8 = bl3 = (n12 -= n11) > n21 && n12 > (n15 >> n22) - 1 << n20;
                        if (DO_STATS) {
                            n24 = FloatMath.max(1, (n15 >> n22) - 1);
                            this.rdrCtx.stats.hist_tile_generator_encoding_dist.add(n12 / n24);
                        }
                    }
                } else {
                    marlinAlphaConsumer.clearAlphas(n23);
                }
                n11 = Integer.MAX_VALUE;
                n12 = Integer.MIN_VALUE;
            }
            ++n13;
            ++n14;
        }
        --n13;
        n13 >>= n7;
        n11 = FloatMath.max(n11, n4) >> n6;
        if ((n12 = FloatMath.min(n12, n5) >> n6) >= n11) {
            this.copyAARow(nArray, n13, n11, n12 + 1, bl3, marlinAlphaConsumer);
        } else if (n13 != n23) {
            marlinAlphaConsumer.clearAlphas(n13);
        }
        this.edgeCount = n15;
        this.prevUseBlkFlags = bl3;
        if (DO_STATS) {
            this.activeEdgeMaxUsed = n18;
        }
    }

    void endRendering() {
        int n2;
        if (this.edgeMinY == Integer.MAX_VALUE) {
            return;
        }
        int n3 = FloatMath.max(FloatMath.ceil_int(this.edgeMinX - 0.5), this.boundsMinX);
        int n4 = FloatMath.min(FloatMath.ceil_int(this.edgeMaxX - 0.5), this.boundsMaxX);
        int n5 = this.edgeMinY;
        int n6 = this.edgeMaxY;
        this.buckets_minY = n5 - this.boundsMinY;
        this.buckets_maxY = n6 - this.boundsMinY;
        if (DO_LOG_BOUNDS) {
            MarlinUtils.logInfo("edgesXY = [" + this.edgeMinX + " ... " + this.edgeMaxX + "[ [" + this.edgeMinY + " ... " + this.edgeMaxY + "[");
            MarlinUtils.logInfo("spXY    = [" + n3 + " ... " + n4 + "[ [" + n5 + " ... " + n6 + "[");
        }
        if (n3 >= n4 || n5 >= n6) {
            return;
        }
        int n7 = n3 >> SUBPIXEL_LG_POSITIONS_X;
        int n8 = n4 + SUBPIXEL_MASK_X >> SUBPIXEL_LG_POSITIONS_X;
        int n9 = n5 >> SUBPIXEL_LG_POSITIONS_Y;
        int n10 = n6 + SUBPIXEL_MASK_Y >> SUBPIXEL_LG_POSITIONS_Y;
        this.initConsumer(n7, n9, n8, n10);
        if (ENABLE_BLOCK_FLAGS) {
            this.enableBlkFlags = this.useRLE;
            boolean bl = this.prevUseBlkFlags = this.enableBlkFlags && !ENABLE_BLOCK_FLAGS_HEURISTICS;
            if (this.enableBlkFlags && (n2 = (n8 - n7 >> BLOCK_SIZE_LG) + 2) > 256) {
                this.blkFlags = this.blkFlags_ref.getArray(n2);
            }
        }
        this.bbox_spminX = n7 << SUBPIXEL_LG_POSITIONS_X;
        this.bbox_spmaxX = n8 << SUBPIXEL_LG_POSITIONS_X;
        this.bbox_spminY = n5;
        this.bbox_spmaxY = n6;
        if (DO_LOG_BOUNDS) {
            MarlinUtils.logInfo("pXY       = [" + n7 + " ... " + n8 + "[ [" + n9 + " ... " + n10 + "[");
            MarlinUtils.logInfo("bbox_spXY = [" + this.bbox_spminX + " ... " + this.bbox_spmaxX + "[ [" + this.bbox_spminY + " ... " + this.bbox_spmaxY + "[");
        }
        if ((n2 = n8 - n7 + 2) > INITIAL_AA_ARRAY) {
            if (DO_STATS) {
                this.rdrCtx.stats.stat_array_renderer_alphaline.add(n2);
            }
            this.alphaLine = this.alphaLine_ref.getArray(n2);
        }
    }

    void initConsumer(int n2, int n3, int n4, int n5) {
        this.bboxX0 = n2;
        this.bboxX1 = n4;
        this.bboxY0 = n3;
        this.bboxY1 = n5;
        int n6 = n4 - n2;
        this.useRLE = FORCE_NO_RLE ? false : (FORCE_RLE ? true : n6 > RLE_MIN_WIDTH);
    }

    @Override
    public void produceAlphas(MarlinAlphaConsumer marlinAlphaConsumer) {
        marlinAlphaConsumer.setMaxAlpha(MAX_AA_ALPHA);
        if (this.enableBlkFlags && !marlinAlphaConsumer.supportBlockFlags()) {
            this.enableBlkFlags = false;
            this.prevUseBlkFlags = false;
        }
        this._endRendering(this.bbox_spminY, this.bbox_spmaxY, marlinAlphaConsumer);
    }

    void copyAARow(int[] nArray, int n2, int n3, int n4, boolean bl, MarlinAlphaConsumer marlinAlphaConsumer) {
        if (DO_STATS) {
            this.rdrCtx.stats.stat_cache_rowAA.add(n4 - n3);
        }
        if (bl) {
            if (DO_STATS) {
                this.rdrCtx.stats.hist_tile_generator_encoding.add(1);
            }
            marlinAlphaConsumer.setAndClearRelativeAlphas(this.blkFlags, nArray, n2, n3, n4);
        } else {
            if (DO_STATS) {
                this.rdrCtx.stats.hist_tile_generator_encoding.add(0);
            }
            marlinAlphaConsumer.setAndClearRelativeAlphas(nArray, n2, n3, n4);
        }
    }

    @Override
    public int getOutpixMinX() {
        return this.bboxX0;
    }

    @Override
    public int getOutpixMaxX() {
        return this.bboxX1;
    }

    @Override
    public int getOutpixMinY() {
        return this.bboxY0;
    }

    @Override
    public int getOutpixMaxY() {
        return this.bboxY1;
    }

    @Override
    public double getOffsetX() {
        return RDR_OFFSET_X;
    }

    @Override
    public double getOffsetY() {
        return RDR_OFFSET_Y;
    }
}

