/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.d3d;

import com.sun.prism.d3d.D3DContext;
import com.sun.prism.impl.BaseMesh;
import com.sun.prism.impl.Disposer;

class D3DMesh
extends BaseMesh {
    static int count = 0;
    private final D3DContext context;
    private final long nativeHandle;

    private D3DMesh(D3DContext d3DContext, long l2, Disposer.Record record) {
        super(record);
        this.context = d3DContext;
        this.nativeHandle = l2;
        ++count;
    }

    static D3DMesh create(D3DContext d3DContext) {
        long l2 = d3DContext.createD3DMesh();
        return new D3DMesh(d3DContext, l2, new D3DMeshDisposerRecord(d3DContext, l2));
    }

    long getNativeHandle() {
        return this.nativeHandle;
    }

    @Override
    public boolean isValid() {
        return !this.context.isDisposed();
    }

    @Override
    public void dispose() {
        this.disposerRecord.dispose();
        --count;
    }

    @Override
    public int getCount() {
        return count;
    }

    @Override
    public boolean buildNativeGeometry(float[] fArray, int n2, int[] nArray, int n3) {
        return this.context.buildNativeGeometry(this.nativeHandle, fArray, n2, nArray, n3);
    }

    @Override
    public boolean buildNativeGeometry(float[] fArray, int n2, short[] sArray, int n3) {
        return this.context.buildNativeGeometry(this.nativeHandle, fArray, n2, sArray, n3);
    }

    static class D3DMeshDisposerRecord
    implements Disposer.Record {
        private final D3DContext context;
        private long nativeHandle;

        D3DMeshDisposerRecord(D3DContext d3DContext, long l2) {
            this.context = d3DContext;
            this.nativeHandle = l2;
        }

        void traceDispose() {
        }

        @Override
        public void dispose() {
            if (this.nativeHandle != 0L) {
                this.traceDispose();
                this.context.releaseD3DMesh(this.nativeHandle);
                this.nativeHandle = 0L;
            }
        }
    }
}

