/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.d3d;

import com.sun.glass.ui.Screen;
import com.sun.prism.Graphics;
import com.sun.prism.Image;
import com.sun.prism.PixelFormat;
import com.sun.prism.RTTexture;
import com.sun.prism.ReadbackRenderTarget;
import com.sun.prism.Texture;
import com.sun.prism.d3d.D3DContext;
import com.sun.prism.d3d.D3DGraphics;
import com.sun.prism.d3d.D3DRenderTarget;
import com.sun.prism.d3d.D3DResourceFactory;
import com.sun.prism.d3d.D3DTexture;
import com.sun.prism.d3d.D3DTextureData;
import com.sun.prism.d3d.D3DTextureResource;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

class D3DRTTexture
extends D3DTexture
implements D3DRenderTarget,
RTTexture,
ReadbackRenderTarget {
    private boolean opaque = false;

    D3DRTTexture(D3DContext d3DContext, Texture.WrapMode wrapMode, long l2, int n2, int n3, int n4, int n5) {
        super(d3DContext, PixelFormat.INT_ARGB_PRE, wrapMode, l2, n2, n3, n4, n5, true);
    }

    D3DRTTexture(D3DContext d3DContext, Texture.WrapMode wrapMode, long l2, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        super(d3DContext, PixelFormat.INT_ARGB_PRE, wrapMode, l2, n2, n3, n4, n5, n6, n7, true, n8, false);
    }

    @Override
    public Texture getBackBuffer() {
        return this;
    }

    @Override
    public long getResourceHandle() {
        return ((D3DTextureData)((D3DTextureResource)this.resource).getResource()).getResource();
    }

    @Override
    public Graphics createGraphics() {
        return D3DGraphics.create(this, this.getContext());
    }

    @Override
    public int[] getPixels() {
        return null;
    }

    @Override
    public boolean readPixels(Buffer buffer, int n2, int n3, int n4, int n5) {
        if (n2 != this.getContentX() || n3 != this.getContentY() || n4 != this.getContentWidth() || n5 != this.getContentHeight()) {
            throw new IllegalArgumentException("reading subtexture not yet supported!");
        }
        return this.readPixels(buffer);
    }

    @Override
    public boolean readPixels(Buffer buffer) {
        D3DContext d3DContext = this.getContext();
        if (d3DContext.isDisposed()) {
            return false;
        }
        d3DContext.flushVertexBuffer();
        long l2 = this.getContext().getContextHandle();
        int n2 = 0;
        if (buffer instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)buffer;
            byte[] byArray = byteBuffer.hasArray() ? byteBuffer.array() : null;
            long l3 = byteBuffer.capacity();
            n2 = D3DResourceFactory.nReadPixelsB(l2, this.getNativeSourceHandle(), l3, buffer, byArray, this.getContentWidth(), this.getContentHeight());
        } else if (buffer instanceof IntBuffer) {
            IntBuffer intBuffer = (IntBuffer)buffer;
            int[] nArray = intBuffer.hasArray() ? intBuffer.array() : null;
            long l4 = intBuffer.capacity() * 4;
            n2 = D3DResourceFactory.nReadPixelsI(l2, this.getNativeSourceHandle(), l4, buffer, nArray, this.getContentWidth(), this.getContentHeight());
        } else {
            throw new IllegalArgumentException("Buffer of this type is not supported: " + String.valueOf(buffer));
        }
        return d3DContext.validatePresent(n2);
    }

    @Override
    public Screen getAssociatedScreen() {
        return this.getContext().getAssociatedScreen();
    }

    @Override
    public void update(Image image) {
        throw new UnsupportedOperationException("update() not supported for RTTextures");
    }

    @Override
    public void update(Image image, int n2, int n3) {
        throw new UnsupportedOperationException("update() not supported for RTTextures");
    }

    @Override
    public void update(Image image, int n2, int n3, int n4, int n5) {
        throw new UnsupportedOperationException("update() not supported for RTTextures");
    }

    @Override
    public void update(Image image, int n2, int n3, int n4, int n5, boolean bl) {
        throw new UnsupportedOperationException("update() not supported for RTTextures");
    }

    @Override
    public void update(Buffer buffer, PixelFormat pixelFormat, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl) {
        throw new UnsupportedOperationException("update() not supported for RTTextures");
    }

    @Override
    public void setOpaque(boolean bl) {
        this.opaque = bl;
    }

    @Override
    public boolean isOpaque() {
        return this.opaque;
    }

    @Override
    public boolean isVolatile() {
        return false;
    }

    @Override
    public boolean isMSAA() {
        return ((D3DTextureData)((D3DTextureResource)this.resource).getResource()).getSamples() != 0;
    }
}

