/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.d3d;

import com.sun.prism.PixelFormat;
import com.sun.prism.d3d.D3DContext;
import com.sun.prism.d3d.D3DResource;
import com.sun.prism.impl.PrismTrace;

public class D3DTextureData
extends D3DResource.D3DRecord {
    private final long size;
    private final boolean isRTT;
    private final int samples;

    static long estimateSize(int n2, int n3, PixelFormat pixelFormat) {
        return (long)n2 * (long)n3 * (long)pixelFormat.getBytesPerPixelUnit();
    }

    static long estimateRTSize(int n2, int n3, boolean bl) {
        return 4L * (long)n2 * (long)n3;
    }

    D3DTextureData(D3DContext d3DContext, long l2, boolean bl, int n2, int n3, PixelFormat pixelFormat, int n4) {
        super(d3DContext, l2);
        this.size = bl ? D3DTextureData.estimateRTSize(n2, n3, false) : D3DTextureData.estimateSize(n2, n3, pixelFormat);
        this.isRTT = bl;
        this.samples = n4;
        if (bl) {
            PrismTrace.rttCreated(l2, n2, n3, this.size);
        } else {
            PrismTrace.textureCreated(l2, n2, n3, this.size);
        }
    }

    int getSamples() {
        return this.samples;
    }

    long getSize() {
        return this.size;
    }

    @Override
    protected void markDisposed() {
        long l2 = this.getResource();
        if (l2 != 0L) {
            if (this.isRTT) {
                PrismTrace.rttDisposed(l2);
            } else {
                PrismTrace.textureDisposed(l2);
            }
        }
        super.markDisposed();
    }

    @Override
    public void dispose() {
        long l2 = this.getResource();
        if (l2 != 0L) {
            if (this.isRTT) {
                PrismTrace.rttDisposed(l2);
            } else {
                PrismTrace.textureDisposed(l2);
            }
        }
        super.dispose();
    }
}

