/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.animation;

import java.util.Objects;
import javafx.animation.Interpolator;

public final class StepInterpolator
extends Interpolator {
    private final int intervalCount;
    private final Interpolator.StepPosition position;

    public StepInterpolator(int n2, Interpolator.StepPosition stepPosition) {
        if (stepPosition == Interpolator.StepPosition.NONE && n2 <= 1) {
            throw new IllegalArgumentException("intervalCount must be greater than 1");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("intervalCount must be greater than 0");
        }
        this.position = Objects.requireNonNull(stepPosition, "position cannot be null");
        this.intervalCount = n2;
    }

    @Override
    protected double curve(double d2) {
        int n2;
        boolean bl;
        boolean bl2 = bl = d2 < 0.0;
        if (bl) {
            d2 = 0.0;
        } else if (d2 > 1.0) {
            d2 = 1.0;
        }
        int n3 = (int)(d2 * (double)this.intervalCount);
        if (this.position == Interpolator.StepPosition.START || this.position == Interpolator.StepPosition.BOTH) {
            ++n3;
        }
        if (bl && d2 * (double)this.intervalCount % 1.0 == 0.0) {
            --n3;
        }
        if (d2 >= 0.0 && n3 < 0) {
            n3 = 0;
        }
        switch (this.position) {
            default: {
                throw new MatchException(null, null);
            }
            case START: 
            case END: {
                int n4 = this.intervalCount;
                break;
            }
            case NONE: {
                int n4 = this.intervalCount - 1;
                break;
            }
            case BOTH: {
                int n4 = n2 = this.intervalCount + 1;
            }
        }
        if (d2 <= 1.0 && n3 > n2) {
            n3 = n2;
        }
        return (double)n3 / (double)n2;
    }

    public int hashCode() {
        return Integer.hashCode(this.intervalCount) + 31 * this.position.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof StepInterpolator)) return false;
        StepInterpolator stepInterpolator = (StepInterpolator)object;
        if (this.intervalCount != stepInterpolator.intervalCount) return false;
        if (this.position != stepInterpolator.position) return false;
        return true;
    }

    public String toString() {
        return "StepInterpolator [intervalCount=" + this.intervalCount + ", position=" + String.valueOf((Object)this.position) + "]";
    }
}

