/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.animation.shared;

import com.sun.javafx.util.Utils;
import com.sun.scenario.animation.shared.AnimationAccessor;
import com.sun.scenario.animation.shared.ClipEnvelope;
import com.sun.scenario.animation.shared.MultiLoopClipEnvelope;
import javafx.animation.Animation;
import javafx.util.Duration;

public class FiniteClipEnvelope
extends MultiLoopClipEnvelope {
    private int cycleCount;
    private long totalTicks;

    protected FiniteClipEnvelope(Animation animation) {
        super(animation);
        if (animation != null) {
            this.autoReverse = animation.isAutoReverse();
            this.cycleCount = animation.getCycleCount();
        }
        this.updateTotalTicks();
    }

    @Override
    public ClipEnvelope setCycleDuration(Duration duration) {
        if (duration.isIndefinite()) {
            return FiniteClipEnvelope.create(this.animation);
        }
        this.updateCycleTicks(duration);
        this.updateTotalTicks();
        return this;
    }

    @Override
    public ClipEnvelope setCycleCount(int n2) {
        if (n2 == 1 || n2 == -1) {
            return FiniteClipEnvelope.create(this.animation);
        }
        this.cycleCount = n2;
        this.updateTotalTicks();
        return this;
    }

    @Override
    public void setRate(double d2) {
        boolean bl = this.isDirectionChanged(d2);
        long l2 = bl ? this.totalTicks - this.ticks : this.ticks;
        Animation.Status status = this.animation.getStatus();
        if (status != Animation.Status.STOPPED) {
            this.setInternalCurrentRate(Math.abs(this.currentRate - this.rate) < 1.0E-12 ? d2 : -d2);
            this.deltaTicks = l2 - this.ticksRateChange(d2);
            this.abortCurrentPulse();
        }
        this.ticks = l2;
        this.rate = d2;
    }

    @Override
    protected double calculateCurrentRate() {
        return !this.autoReverse ? this.rate : (this.isDuringEvenCycle() == this.rate > 0.0 ? this.rate : -this.rate);
    }

    private void updateTotalTicks() {
        this.totalTicks = (long)this.cycleCount * this.cycleTicks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void timePulse(long l2) {
        if (this.cycleTicks == 0L) {
            return;
        }
        this.aborted = false;
        this.inTimePulse = true;
        try {
            long l3;
            long l4 = this.ticks;
            long l5 = Math.round((double)l2 * Math.abs(this.rate));
            this.ticks = Utils.clamp(0L, this.deltaTicks + l5, this.totalTicks);
            boolean bl = this.ticks >= this.totalTicks;
            long l6 = this.ticks - l4;
            if (l6 == 0L) {
                return;
            }
            long l7 = l3 = this.currentRate > 0.0 ? this.cycleTicks - this.cyclePos : this.cyclePos;
            while (l6 >= l3) {
                if (l3 > 0L) {
                    this.cyclePos = this.currentRate > 0.0 ? this.cycleTicks : 0L;
                    l6 -= l3;
                    AnimationAccessor.getDefault().playTo(this.animation, this.cyclePos, this.cycleTicks);
                    if (this.aborted) {
                        return;
                    }
                }
                if (!bl || l6 > 0L) {
                    if (this.autoReverse) {
                        this.setCurrentRate(-this.currentRate);
                    } else {
                        this.cyclePos = this.currentRate > 0.0 ? 0L : this.cycleTicks;
                        AnimationAccessor.getDefault().jumpTo(this.animation, this.cyclePos, this.cycleTicks, false);
                    }
                }
                l3 = this.cycleTicks;
            }
            if (l6 > 0L && !bl) {
                this.cyclePos += this.currentRate > 0.0 ? l6 : -l6;
                AnimationAccessor.getDefault().playTo(this.animation, this.cyclePos, this.cycleTicks);
            }
            if (bl && !this.aborted) {
                AnimationAccessor.getDefault().finished(this.animation);
            }
        }
        finally {
            this.inTimePulse = false;
        }
    }

    @Override
    public void jumpTo(long l2) {
        if (this.cycleTicks == 0L) {
            return;
        }
        long l3 = this.ticks;
        if (this.rate < 0.0) {
            l2 = this.totalTicks - l2;
        }
        this.ticks = Utils.clamp(0L, l2, this.totalTicks);
        long l4 = this.ticks - l3;
        if (l4 != 0L) {
            this.deltaTicks += l4;
            if (this.autoReverse) {
                boolean bl = this.ticks % (2L * this.cycleTicks) < this.cycleTicks;
                if (bl == this.rate > 0.0) {
                    this.cyclePos = this.ticks % this.cycleTicks;
                    if (this.animation.getStatus() == Animation.Status.RUNNING) {
                        this.setCurrentRate(Math.abs(this.rate));
                    }
                } else {
                    this.cyclePos = this.cycleTicks - this.ticks % this.cycleTicks;
                    if (this.animation.getStatus() == Animation.Status.RUNNING) {
                        this.setCurrentRate(-Math.abs(this.rate));
                    }
                }
            } else {
                this.cyclePos = this.ticks % this.cycleTicks;
                if (this.rate < 0.0) {
                    this.cyclePos = this.cycleTicks - this.cyclePos;
                }
                if (this.cyclePos == 0L && this.ticks > 0L) {
                    this.cyclePos = this.cycleTicks;
                }
            }
            AnimationAccessor.getDefault().jumpTo(this.animation, this.cyclePos, this.cycleTicks, false);
            this.abortCurrentPulse();
        }
    }
}

