/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public final class Log {
    public static final Shim log = new Shim();
    protected static final Level[] LEVELS;

    public static String format(Object object, Object ... objectArray) {
        if (objectArray.length < 2) {
            return String.valueOf(object);
        }
        if (((StringBuilder)(object = new StringBuilder(String.valueOf(object)))).length() > 0) {
            ((StringBuilder)object).append(' ');
        }
        ((StringBuilder)object).append('[');
        int n2 = objectArray.length / 2;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 > 0) {
                ((StringBuilder)object).append(',').append(' ');
            }
            ((StringBuilder)object).append(objectArray[2 * i2]).append('=');
            try {
                ((StringBuilder)object).append(objectArray[2 * i2 + 1]);
                continue;
            }
            catch (Throwable throwable) {
                ((StringBuilder)object).append("<toString() failure: ").append(throwable).append(">");
            }
        }
        return ((StringBuilder)object).append(']').toString();
    }

    static {
        OneLineFormatter oneLineFormatter = new OneLineFormatter();
        Handler[] handlerArray = LogManager.getLogManager().getLogger("");
        for (Handler handler : handlerArray.getHandlers()) {
            handler.setFormatter(oneLineFormatter);
        }
        LEVELS = new Level[]{Level.FINE, Level.INFO, Level.WARNING, Level.SEVERE};
    }

    public static class Shim {
        protected final Logger _impl = Logger.getLogger("com.threerings.getdown");

        public void debug(Object object, Object ... objectArray) {
            this.doLog(0, object, objectArray);
        }

        public void info(Object object, Object ... objectArray) {
            this.doLog(1, object, objectArray);
        }

        public void warning(Object object, Object ... objectArray) {
            this.doLog(2, object, objectArray);
        }

        public void error(Object object, Object ... objectArray) {
            this.doLog(3, object, objectArray);
        }

        protected void doLog(int n2, Object object, Object[] objectArray) {
            if (this._impl.isLoggable(LEVELS[n2])) {
                Throwable throwable = null;
                int n3 = objectArray.length;
                if (object instanceof Throwable) {
                    throwable = (Throwable)object;
                } else if (n3 % 2 == 1 && objectArray[n3 - 1] instanceof Throwable) {
                    throwable = (Throwable)objectArray[--n3];
                }
                this._impl.log(LEVELS[n2], Log.format(object, objectArray), throwable);
            }
        }
    }

    protected static class OneLineFormatter
    extends Formatter {
        protected Date _date = new Date();
        protected SimpleDateFormat _format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss:SSS");
        protected FieldPosition _fpos = new FieldPosition(3);

        protected OneLineFormatter() {
        }

        @Override
        public String format(LogRecord logRecord) {
            StringBuffer stringBuffer = new StringBuffer();
            this._date.setTime(logRecord.getMillis());
            this._format.format(this._date, stringBuffer, this._fpos);
            stringBuffer.append(" ");
            stringBuffer.append(logRecord.getLevel().getLocalizedName());
            stringBuffer.append(" ");
            stringBuffer.append(this.formatMessage(logRecord));
            stringBuffer.append(System.lineSeparator());
            if (logRecord.getThrown() != null) {
                try {
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    logRecord.getThrown().printStackTrace(printWriter);
                    printWriter.close();
                    stringBuffer.append(stringWriter.toString());
                }
                catch (Exception exception) {
                    stringBuffer.append("Format failure:").append(exception);
                }
            }
            return stringBuffer.toString();
        }
    }
}

