/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.data;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class ClassPath {
    private final Set<File> _classPathEntries;

    public ClassPath(LinkedHashSet<File> linkedHashSet) {
        this._classPathEntries = Collections.unmodifiableSet(linkedHashSet);
    }

    public String asArgumentString(File file) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "";
        for (File file2 : this._classPathEntries) {
            stringBuilder.append(string).append(file.toPath().relativize(file2.toPath()));
            string = File.pathSeparator;
        }
        return stringBuilder.toString();
    }

    public URL[] asUrls() {
        URL[] uRLArray = new URL[this._classPathEntries.size()];
        int n2 = 0;
        for (File file : this._classPathEntries) {
            uRLArray[n2++] = ClassPath.getURL(file);
        }
        return uRLArray;
    }

    public Set<File> getClassPathEntries() {
        return this._classPathEntries;
    }

    private static URL getURL(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalStateException("URL of file is illegal: " + file.getAbsolutePath(), malformedURLException);
        }
    }
}

