/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.launcher;

import com.a.a.a.a;
import com.a.a.c;
import com.a.b.t;
import com.threerings.getdown.Log;
import com.threerings.getdown.data.Application;
import com.threerings.getdown.launcher.RotatingBackgrounds;
import com.threerings.getdown.launcher.r;
import com.threerings.getdown.util.MessageUtil;
import com.threerings.getdown.util.Rectangle;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.Timer;

public final class StatusPanel
extends JComponent
implements ImageObserver {
    protected Image _barimg;
    protected RotatingBackgrounds _bg;
    protected Dimension _psize;
    protected ResourceBundle _msgs;
    protected int _progress = -1;
    protected String _status;
    protected int _statusDots = 1;
    protected boolean _displayError;
    protected c _label;
    protected c _newlab;
    protected c _plabel;
    protected c _newplab;
    protected c _rlabel;
    protected c _newrlab;
    protected Application.UpdateInterface _ifc;
    protected Timer _timer;
    protected long[] _remain = new long[4];
    protected int _ridx;
    protected t _rthrottle = new t(1, 1000L);
    protected static final Font FONT = new Font("SansSerif", 1, 12);

    public StatusPanel(ResourceBundle resourceBundle) {
        this._msgs = resourceBundle;
        this._timer = new Timer(1000, new r(this));
    }

    public final void init(Application.UpdateInterface object, RotatingBackgrounds object2, Image image) {
        int n2;
        this._ifc = object;
        this._bg = object2;
        object2 = this._bg.getImage(this._progress);
        int n3 = object2 == null ? -1 : ((Image)object2).getWidth(this);
        int n4 = n2 = object2 == null ? -1 : ((Image)object2).getHeight(this);
        if (n3 == -1 || n2 == -1) {
            object = ((Application.UpdateInterface)object).progress.union(((Application.UpdateInterface)object).status);
            this._psize = new Dimension(((Rectangle)object).x + ((Rectangle)object).width + ((Rectangle)object).x, ((Rectangle)object).y + ((Rectangle)object).height + ((Rectangle)object).x);
        } else {
            this._psize = new Dimension(n3, n2);
        }
        this._barimg = image;
        this.invalidate();
    }

    @Override
    public final boolean imageUpdate(Image image, int n2, int n3, int n4, int n5, int n6) {
        boolean bl = false;
        if ((n2 & 1) != 0) {
            this._psize.width = n5;
            bl = true;
        }
        if ((n2 & 2) != 0) {
            this._psize.height = n6;
            bl = true;
        }
        if (bl) {
            this.invalidate();
            StatusPanel statusPanel = this;
            statusPanel.setSize(statusPanel._psize);
            this.getParent().setSize(this._psize);
        }
        return (n2 & 0x20) == 0;
    }

    public final void setProgress(int n2, long l2) {
        int n3 = 0;
        if (this._progress != n2) {
            this._progress = n2;
            if (!this._ifc.hideProgressText) {
                String string = MessageFormat.format(this.get("m.complete"), n2);
                this._newplab = this.createLabel(string, new Color(this._ifc.progressText, true));
            }
            n3 = 1;
        }
        if (l2 > 1L) {
            if (!this._rthrottle.a()) {
                this._remain[this._ridx++ % this._remain.length] = l2;
            }
            l2 = 0L;
            n2 = Math.min(this._ridx, this._remain.length);
            for (n3 = 0; n3 < n2; ++n3) {
                l2 += this._remain[n3];
            }
            l2 /= (long)n2;
            if (!this._ifc.hideProgressText) {
                n3 = (int)(l2 / 60L);
                n2 = (int)(l2 % 60L);
                String string = n3 + ":" + (n2 < 10 ? "0" : "") + n2;
                string = MessageFormat.format(this.get("m.remain"), string);
                this._newrlab = this.createLabel(string, new Color(this._ifc.statusText, true));
            }
            n3 = 1;
        } else if (this._rlabel != null || this._newrlab != null) {
            this._rthrottle = new t(1, 1000L);
            this._ridx = 0;
            StatusPanel statusPanel = this;
            statusPanel._rlabel = null;
            statusPanel._newrlab = null;
            n3 = 1;
        }
        if (n3 != 0) {
            this.repaint();
        }
    }

    public final void setStatus(String string, boolean bl) {
        this._status = this.xlate(string);
        this._displayError = bl;
        this.updateStatusLabel();
    }

    public final void stopThrob() {
        this._timer.stop();
        this._statusDots = 3;
        this.updateStatusLabel();
    }

    @Override
    public final void addNotify() {
        super.addNotify();
        this._timer.start();
    }

    @Override
    public final void removeNotify() {
        this._timer.stop();
        super.removeNotify();
    }

    @Override
    public final void paintComponent(Graphics graphics) {
        int n2;
        super.paintComponent(graphics);
        graphics = (Graphics2D)graphics;
        Object object = this._displayError ? this._bg.getErrorImage() : this._bg.getImage(this._progress);
        if (object != null) {
            graphics.drawImage((Image)object, 0, 0, this);
        }
        object = a.a((Graphics2D)graphics);
        if (this._newlab != null) {
            this._newlab.a((Graphics2D)graphics);
            this._label = this._newlab;
            this._newlab = null;
        }
        if (this._newplab != null) {
            this._newplab.a((Graphics2D)graphics);
            this._plabel = this._newplab;
            this._newplab = null;
        }
        if (this._newrlab != null) {
            this._newrlab.a((Graphics2D)graphics);
            this._rlabel = this._newrlab;
            this._newrlab = null;
        }
        if (this._barimg != null) {
            graphics.setClip(this._ifc.progress.x, this._ifc.progress.y, this._progress * this._ifc.progress.width / 100, this._ifc.progress.height);
            graphics.drawImage(this._barimg, this._ifc.progress.x, this._ifc.progress.y, null);
            graphics.setClip(null);
        } else {
            graphics.setColor(new Color(this._ifc.progressBar, true));
            graphics.fillRect(this._ifc.progress.x, this._ifc.progress.y, this._progress * this._ifc.progress.width / 100, this._ifc.progress.height);
        }
        if (this._plabel != null) {
            n2 = (this._ifc.progress.width - this._plabel.a().width) / 2;
            int n3 = (this._ifc.progress.height - this._plabel.a().height) / 2;
            this._plabel.a((Graphics2D)graphics, this._ifc.progress.x + n2, this._ifc.progress.y + n3);
        }
        if (this._label != null) {
            StatusPanel statusPanel = this;
            this._label.a((Graphics2D)graphics, this._ifc.status.x, statusPanel.getStatusY(statusPanel._label));
        }
        if (this._rlabel != null) {
            n2 = this._ifc.status.x + this._ifc.status.width - this._rlabel.a().width;
            StatusPanel statusPanel = this;
            this._rlabel.a((Graphics2D)graphics, n2, statusPanel.getStatusY(statusPanel._rlabel));
        }
        a.a((Graphics2D)graphics, object);
    }

    @Override
    public final Dimension getPreferredSize() {
        return this._psize;
    }

    protected final void updateStatusLabel() {
        int n2;
        String string = this._status;
        if (!this._displayError) {
            for (n2 = 0; n2 < this._statusDots; ++n2) {
                string = string + " .";
            }
        }
        this._newlab = this.createLabel(string, new Color(this._ifc.statusText, true));
        n2 = this._ifc.status.width;
        if (n2 == 0) {
            n2 = this.getWidth();
        }
        if (n2 > 0) {
            this._newlab.b(n2);
        }
        this.repaint();
    }

    protected final int getStatusY(c c2) {
        if (this._ifc.status.y > this._ifc.progress.y) {
            return this._ifc.status.y;
        }
        return this._ifc.status.y + (this._ifc.status.height - c2.a().height);
    }

    protected final c createLabel(String object, Color color) {
        object = new c((String)object, color, FONT);
        if (this._ifc.textShadow != 0) {
            ((c)object).a(new Color(this._ifc.textShadow, true));
            ((c)object).a(4);
        }
        return object;
    }

    protected final String xlate(String stringArray) {
        int n2 = stringArray.indexOf(124);
        if (n2 == -1) {
            return this.get((String)stringArray);
        }
        String string = stringArray.substring(0, n2);
        stringArray = stringArray.substring(n2 + 1);
        stringArray = stringArray.split("\\|");
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            stringArray[n2] = MessageUtil.isTainted(stringArray[n2]) ? MessageUtil.unescape(MessageUtil.untaint(stringArray[n2])) : this.xlate(MessageUtil.unescape(stringArray[n2]));
        }
        return this.get(string, stringArray);
    }

    protected final String get(String string, String[] stringArray) {
        String string2 = this.get(string);
        if (string2 != null) {
            return MessageFormat.format(MessageUtil.escape(string2), stringArray);
        }
        return string + Arrays.asList(stringArray);
    }

    protected final String get(String string) {
        if (this._msgs == null) {
            return string;
        }
        if (MessageUtil.isTainted(string)) {
            return MessageUtil.untaint(string);
        }
        try {
            return this._msgs.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            Log.log.warning("Missing translation message '" + string + "'.", new Object[0]);
            return string;
        }
    }
}

