/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.tools;

import com.threerings.getdown.data.Application;
import com.threerings.getdown.data.Digest;
import com.threerings.getdown.data.EnvConfig;
import com.threerings.getdown.data.Resource;
import com.threerings.getdown.util.Base64;
import com.threerings.getdown.util.Config;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Signature;
import java.util.ArrayList;

public class Digester {
    public static void main(String[] stringArray) throws IOException, GeneralSecurityException {
        switch (stringArray.length) {
            case 1: {
                Digester.createDigests(new File(stringArray[0]), null, null, null);
                return;
            }
            case 4: {
                Digester.createDigests(new File(stringArray[0]), new File(stringArray[1]), stringArray[2], stringArray[3]);
                return;
            }
        }
        System.err.println("Usage: Digester app_dir [keystore_path password alias]");
        System.exit(255);
    }

    public static void createDigests(File file, File file2, String string, String string2) throws IOException, GeneralSecurityException {
        for (int i2 = 1; i2 <= 2; ++i2) {
            Digester.createDigest(i2, file);
            if (file2 == null) continue;
            Digester.signDigest(i2, file, file2, string, string2);
        }
    }

    public static void createDigest(int n2, File arrayList) throws IOException {
        File file = new File((File)((Object)arrayList), Digest.digestFile(n2));
        System.out.println("Generating digest file '" + file + "'...");
        arrayList = new EnvConfig((File)((Object)arrayList));
        Application application = new Application((EnvConfig)((Object)arrayList));
        arrayList = Application.readConfig((EnvConfig)((Object)arrayList), false);
        application.initBase((Config)((Object)arrayList));
        application.initResources((Config)((Object)arrayList));
        arrayList = new ArrayList<Resource>();
        arrayList.add(application.getConfigResource());
        arrayList.addAll(application.getCodeResources());
        arrayList.addAll(application.getResources());
        for (Application.AuxGroup auxGroup : application.getAuxGroups()) {
            arrayList.addAll(auxGroup.codes);
            arrayList.addAll(auxGroup.rsrcs);
        }
        application.init(true);
        Digest.createDigest(n2, arrayList, file);
    }

    public static void signDigest(int n2, File object, File object2, String object3, String object4) throws IOException, GeneralSecurityException {
        Object object5 = Digest.digestFile(n2);
        Object object6 = new File((File)object, (String)object5);
        object = new File((File)object, (String)object5 + ".sig");
        object2 = new FileInputStream((File)object2);
        try {
            object5 = new FileInputStream((File)object6);
            try {
                object = new FileOutputStream((File)object);
                try {
                    int n3;
                    object6 = KeyStore.getInstance("JKS");
                    ((KeyStore)object6).load((InputStream)object2, ((String)object3).toCharArray());
                    object3 = (PrivateKey)((KeyStore)object6).getKey((String)object4, ((String)object3).toCharArray());
                    Object object7 = Digest.sigAlgorithm(n2);
                    object7 = Signature.getInstance((String)object7);
                    object4 = new byte[8192];
                    ((Signature)object7).initSign((PrivateKey)object3);
                    while ((n3 = ((FileInputStream)object5).read((byte[])object4)) != -1) {
                        ((Signature)object7).update((byte[])object4, 0, n3);
                    }
                    object7 = Base64.encodeToString(((Signature)object7).sign(), 0);
                    ((FileOutputStream)object).write(((String)object7).getBytes(StandardCharsets.UTF_8));
                }
                finally {
                    ((FileOutputStream)object).close();
                }
            }
            finally {
                ((FileInputStream)object5).close();
            }
            return;
        }
        finally {
            ((FileInputStream)object2).close();
        }
    }
}

