/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.util;

import com.threerings.getdown.Log;
import com.threerings.getdown.util.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class VersionUtil {
    public static long readVersion(File object) {
        long l2 = -1L;
        try {
            object = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream((File)object), StandardCharsets.UTF_8));
            try {
                String string = ((BufferedReader)object).readLine();
                if (!StringUtil.isBlank(string)) {
                    l2 = Long.parseLong(string);
                }
            }
            finally {
                ((BufferedReader)object).close();
            }
        }
        catch (Exception exception) {
            Log.log.info("Unable to read version file: " + exception.getMessage(), new Object[0]);
        }
        return l2;
    }

    public static void writeVersion(File object, long l2) throws IOException {
        try {
            object = new PrintStream(new FileOutputStream((File)object));
            try {
                ((PrintStream)object).println(l2);
            }
            finally {
                ((PrintStream)object).close();
            }
        }
        catch (Exception exception) {
            Log.log.warning("Unable to write version file: " + exception.getMessage(), new Object[0]);
        }
    }

    public static long parseJavaVersion(String object, String string) {
        if (!((Matcher)(object = Pattern.compile((String)object).matcher(string))).matches()) {
            return 0L;
        }
        long l2 = 0L;
        for (int i2 = 1; i2 <= ((Matcher)object).groupCount(); ++i2) {
            String string2 = ((Matcher)object).group(i2);
            int n2 = string2 == null ? 0 : VersionUtil.parseInt(string2);
            l2 *= 100L;
            l2 += (long)n2;
        }
        return l2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long readReleaseVersion(File file, String string) {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
            String string3;
            String string2 = null;
            while ((string3 = bufferedReader.readLine()) != null) {
                if (!string3.startsWith("JAVA_VERSION=")) continue;
                string2 = string3.substring(13).replace('\"', ' ').trim();
            }
            if (string2 == null) {
                Log.log.warning("No JAVA_VERSION line in 'release' file", "file", file);
                return 0L;
            }
            long l2 = VersionUtil.parseJavaVersion(string, string2);
            return l2;
        }
        catch (Exception exception) {
            Log.log.warning("Failed to read version from 'release' file", "file", file, exception);
            return 0L;
        }
    }

    private static int parseInt(String string) {
        int n2 = 0;
        int n3 = string.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 < '0' || c2 > '9') continue;
            n2 *= 10;
            n2 += c2 - 48;
        }
        return n2;
    }
}

