/*
 * Decompiled with CFR 0.152.
 */
package fr.orpheo;

import fr.orpheo.serial.SerialPortManager;
import fr.orpheo.tools.ConsoleLogger;
import fr.orpheo.tools.TaskManager;
import java.io.IOException;
import javafx.application.Application;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;

public class App
extends Application {
    public static void main(String[] args) {
        App.launch(args);
    }

    @Override
    public void start(Stage stage) throws IOException {
        Scene scene = new Scene(App.loadFXML("mainView"), 1000.0, 666.0);
        stage.setTitle("Spark Programmer");
        stage.setOnCloseRequest(windowEvent -> {
            ConsoleLogger.info("Closing the app");
            SerialPortManager.closeSerialPort();
            SerialPortManager.stopAutoConnect();
            TaskManager.stopAllTasks();
        });
        stage.setResizable(false);
        stage.setScene(scene);
        ConsoleLogger.info("Starting the app");
        stage.show();
    }

    private static Parent loadFXML(String fxml) throws IOException {
        FXMLLoader fxmlLoader = new FXMLLoader(App.class.getResource(fxml + ".fxml"));
        return (Parent)fxmlLoader.load();
    }
}

