/*
 * Decompiled with CFR 0.152.
 */
package fr.orpheo;

import fr.orpheo.tools.FatalManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class FileResourcesManager {
    private static File localTempDirectory = null;

    private FileResourcesManager() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static List<String> listFilesInResourceDirectory(String targetDir) {
        ArrayList<String> fileNames = new ArrayList<String>();
        URL dirURL = FileResourcesManager.class.getResource(targetDir = targetDir.replaceAll("^/+|/+$", ""));
        if (dirURL != null) {
            if (dirURL.getProtocol().equals("file")) {
                try {
                    Path dirPath = Paths.get(dirURL.toURI());
                    if (Files.exists(dirPath, new LinkOption[0])) {
                        Files.list(dirPath).forEach(path -> fileNames.add(path.getFileName().toString()));
                    }
                }
                catch (Exception e2) {
                    FatalManager.fatalError("Failed to list files in " + targetDir + ": " + e2.getMessage());
                }
            } else if (dirURL.getProtocol().equals("jar")) {
                try {
                    String jarPath = dirURL.getPath().substring(5, dirURL.getPath().indexOf("!"));
                    String jarTargetDir = dirURL.getPath().substring(dirURL.getPath().indexOf("!") + 2);
                    jarPath = jarPath.replace("%20", " ");
                    try (JarFile jarFile = new JarFile(jarPath);){
                        Enumeration<JarEntry> entries = jarFile.entries();
                        while (entries.hasMoreElements()) {
                            JarEntry entry = entries.nextElement();
                            String entryName = entry.getName();
                            if (!entryName.startsWith(jarTargetDir) || entry.isDirectory()) continue;
                            String fileName = entryName.substring(jarTargetDir.length() + 1);
                            fileNames.add(fileName);
                        }
                    }
                }
                catch (Exception e3) {
                    FatalManager.fatalError("Failed to read JAR: " + e3.getMessage());
                }
            }
        }
        return fileNames;
    }

    public static File extractFile(String resourcePath, boolean makeExecutable) throws IOException {
        Path targetPath;
        File targetFile;
        if (localTempDirectory == null) {
            try {
                localTempDirectory = Files.createTempDirectory("SparkProgrammerTemp", new FileAttribute[0]).toFile();
                localTempDirectory.deleteOnExit();
            }
            catch (Exception e2) {
                throw new FileNotFoundException("Failed to create a temporary directory: " + e2.getMessage());
            }
        }
        if ((targetFile = (targetPath = Paths.get(localTempDirectory.getAbsolutePath(), resourcePath)).toFile()).exists()) {
            return targetFile;
        }
        try (InputStream resourceStream = FileResourcesManager.class.getResourceAsStream(resourcePath);){
            if (resourceStream == null) {
                throw new FileNotFoundException("Resource not found: " + resourcePath);
            }
            Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
            Files.copy(resourceStream, targetPath, StandardCopyOption.REPLACE_EXISTING);
        }
        if (makeExecutable && !targetFile.setExecutable(true)) {
            throw new IOException("Failed to make the file " + String.valueOf(targetFile) + " executable.");
        }
        ArrayList<File> filesToDelete = new ArrayList<File>();
        File currentFile = targetFile;
        while (!currentFile.equals(localTempDirectory)) {
            filesToDelete.add(currentFile);
            currentFile = currentFile.getParentFile();
        }
        filesToDelete.reversed().forEach(File::deleteOnExit);
        return targetFile;
    }

    public static List<String> getLinesFromResourceFile(String listFilePath) {
        ArrayList<String> lines = new ArrayList<String>();
        InputStream inputStream = FileResourcesManager.class.getResourceAsStream(listFilePath);
        if (inputStream == null) {
            FatalManager.fatalError("Resource not found: " + listFilePath);
            return lines;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) continue;
                lines.add(line);
            }
        }
        catch (IOException e2) {
            FatalManager.fatalError("Error reading resource file: " + listFilePath + ". " + e2.getMessage());
        }
        return lines;
    }
}

