/*
 * Decompiled with CFR 0.152.
 */
package fr.orpheo.controllers;

import fr.orpheo.controllers.GroupController;
import fr.orpheo.models.FrameSender;
import fr.orpheo.models.GlobalBindings;
import fr.orpheo.models.spark.protocol.ConfigProtocol;
import fr.orpheo.models.spark.protocol.ProtocolManager;
import fr.orpheo.models.spark.protocol.actions.ActionType;
import fr.orpheo.models.spark.protocol.groups.Group;
import fr.orpheo.models.spark.protocol.groups.GroupType;
import fr.orpheo.tools.Helper;
import fr.orpheo.tools.TaskManager;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.layout.GridPane;

public class ConfigController
implements Initializable {
    @FXML
    private Button readAllButton;
    @FXML
    private Button writeAllButton;
    @FXML
    private Button saveButton;
    @FXML
    private Button cancelButton;
    @FXML
    private GridPane paramGrid;
    private final List<GroupController> groupControllers = new ArrayList<GroupController>();
    private static ConfigProtocol currentProtocol = ProtocolManager.getLatestProtocol();

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        this.configureBindings();
        this.createGroupControllers();
    }

    private void configureBindings() {
        this.readAllButton.disableProperty().bind(GlobalBindings.idleConnected.not());
        this.writeAllButton.disableProperty().bind(GlobalBindings.idleConnected.not());
        this.saveButton.disableProperty().bind(GlobalBindings.idleConnected.not());
        this.cancelButton.disableProperty().bind(GlobalBindings.idleConnected.not());
    }

    private void createGroupControllers() {
        this.createGroupController(GroupType.CARD, 1, false);
        this.createGroupController(GroupType.HARD_VERSION, 1, false);
        this.createGroupController(GroupType.SOFT_VERSION, 1, false);
        this.createGroupController(GroupType.DATE_CODE, 1, false);
        this.createGroupController(GroupType.NFC, 1, false);
        this.createGroupController(GroupType.RTC, 1, true);
        this.createGroupController(GroupType.LED, 1, true);
        this.createGroupController(GroupType.INTENSITY, 1, true);
        this.createGroupController(GroupType.LATENCY, 1, true);
        this.createGroupController(GroupType.ZONE_ID, 1, true);
        this.createGroupController(GroupType.OPENING_TIME, 1, true);
        this.createGroupController(GroupType.CLOSING_TIME, 1, true);
        this.createGroupController(GroupType.ENABLE_EMISSION, 1, true);
        this.createGroupController(GroupType.RS485_ISTERMINAL, 1, true);
        this.createGroupController(GroupType.RS485_STRATEGY, 1, true);
        this.createGroupController(GroupType.RS485_PARAMETER, 1, true);
        this.createGroupController(GroupType.MODE, 1, true);
    }

    private void createGroupController(GroupType type, int protocolVersion, boolean writable) {
        Group group = ProtocolManager.getProtocolByVersion(protocolVersion).getGroupFromType(type);
        if (group == null) {
            throw new IllegalArgumentException("No group " + String.valueOf(type) + " in protocole verion " + protocolVersion + ".");
        }
        GroupController controller = new GroupController(group, this.paramGrid, writable);
        this.groupControllers.add(controller);
    }

    @FXML
    private void readAll(ActionEvent event) {
        TaskManager.performLongAction(() -> {
            for (GroupController controller : this.groupControllers) {
                if (controller.read()) continue;
                return;
            }
        });
    }

    @FXML
    private void writeAll(ActionEvent event) {
        TaskManager.performLongAction(() -> {
            for (GroupController controller : this.groupControllers) {
                if (controller.write()) continue;
                return;
            }
        });
    }

    @FXML
    private void save(ActionEvent event) {
        Helper.applyBorderColor(this.saveButton, FrameSender.performAction(currentProtocol.getActionFromType(ActionType.SAVE)));
    }

    @FXML
    private void cancel(ActionEvent event) {
        Helper.applyBorderColor(this.cancelButton, FrameSender.performAction(currentProtocol.getActionFromType(ActionType.CANCEL)));
    }
}

