/*
 * Decompiled with CFR 0.152.
 */
package fr.orpheo.controllers;

import fr.orpheo.models.GlobalBindings;
import fr.orpheo.models.spark.protocol.groups.Group;
import fr.orpheo.models.spark.protocol.groups.GroupRunner;
import fr.orpheo.models.spark.protocol.groups.GroupRunnerEventListener;
import fr.orpheo.tools.Helper;
import java.util.Collection;
import java.util.List;
import javafx.application.Platform;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;

public class GroupController
implements GroupRunnerEventListener {
    private static int gridRowIndex = 0;
    protected static final int READ_BUTTON_COLUMN = 0;
    protected static final int LABEL_COLUMN = 1;
    protected static final int TEXT_FIELD_COLUMN = 2;
    protected static final int COMBO_BOX_COLUMN = 3;
    protected static final int WRITE_BUTTON_COLUMN = 4;
    private Button readButton;
    private TextField textField;
    private ComboBox<String> comboBox;
    private Button writeButton;
    private GroupRunner groupRunner;

    public GroupController(Group group, GridPane grid, boolean writable) {
        this.groupRunner = new GroupRunner(group);
        this.groupRunner.register(this);
        this.addGridRow(writable ? group.getOptions() : null, grid);
    }

    private void addGridRow(List<String> options, GridPane grid) {
        this.readButton = new Button("Read");
        this.readButton.setOnAction(actionEvent -> this.read());
        GridPane.setRowIndex(this.readButton, gridRowIndex);
        GridPane.setColumnIndex(this.readButton, 0);
        grid.getChildren().add(this.readButton);
        this.readButton.disableProperty().bind(GlobalBindings.idleConnected.not());
        Label label = new Label(this.groupRunner.getName());
        GridPane.setRowIndex(label, gridRowIndex);
        GridPane.setColumnIndex(label, 1);
        grid.getChildren().add(label);
        this.textField = new TextField();
        this.textField.setEditable(false);
        this.textField.setPrefHeight(25.0);
        this.textField.setPrefWidth(175.0);
        this.textField.getStyleClass().add("config-field-default");
        GridPane.setRowIndex(this.textField, gridRowIndex);
        GridPane.setColumnIndex(this.textField, 2);
        grid.getChildren().add(this.textField);
        if (options != null) {
            this.comboBox = new ComboBox();
            this.comboBox.setPrefHeight(25.0);
            this.comboBox.setPrefWidth(175.0);
            this.comboBox.getStyleClass().add("config-field-default");
            GridPane.setRowIndex(this.comboBox, gridRowIndex);
            GridPane.setColumnIndex(this.comboBox, 3);
            this.comboBox.getItems().addAll((Collection<String>)options);
            grid.getChildren().add(this.comboBox);
            this.writeButton = new Button("Write");
            this.writeButton.setOnAction(actionEvent -> this.write());
            GridPane.setRowIndex(this.writeButton, gridRowIndex);
            GridPane.setColumnIndex(this.writeButton, 4);
            grid.getChildren().add(this.writeButton);
            this.writeButton.disableProperty().bind(GlobalBindings.idleConnected.not().or(this.comboBox.getSelectionModel().selectedItemProperty().isNull()));
        } else {
            this.comboBox = null;
            this.writeButton = null;
        }
        ++gridRowIndex;
    }

    public boolean read() {
        return this.groupRunner.read();
    }

    public boolean write() {
        if (this.comboBox == null) {
            return true;
        }
        String selectedOption = (String)this.comboBox.getValue();
        if (selectedOption == null) {
            return true;
        }
        return this.groupRunner.write(selectedOption);
    }

    @Override
    public void onGroupRead(Group group, String result) {
        if (result != null) {
            Platform.runLater(() -> this.textField.setText(result));
            Helper.applyBorderColor(this.textField, true);
        } else {
            Helper.applyBorderColor(this.textField, false);
        }
    }

    @Override
    public void onGroupWritten(Group group, String result) {
        Helper.applyBorderColor(this.comboBox, result != null);
    }
}

