/*
 * Decompiled with CFR 0.152.
 */
package fr.orpheo.controllers;

import com.fazecast.jSerialComm.SerialPort;
import fr.orpheo.models.GlobalBindings;
import fr.orpheo.serial.SerialPortEventListener;
import fr.orpheo.serial.SerialPortManager;
import fr.orpheo.tools.ConsoleLogger;
import fr.orpheo.tools.Helper;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ComboBox;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TextArea;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;

public class MainController
implements Initializable,
SerialPortEventListener {
    @FXML
    private CheckMenuItem showConsoleMenuItem;
    @FXML
    private CheckMenuItem showDebugMenuItem;
    @FXML
    private BorderPane rootPane;
    @FXML
    private SplitPane splitPaneConsole;
    @FXML
    private SplitPane splitPaneDebug;
    @FXML
    private TextArea console;
    @FXML
    private VBox debugVBox;
    @FXML
    private TextArea debugTextArea;
    @FXML
    private TextArea debugByteTextArea;
    @FXML
    private Button debugClearButton;
    @FXML
    private ComboBox<String> debugSendComboBox;
    @FXML
    private Button debugSendTextButton;
    @FXML
    private Button debugSendBytesButton;
    @FXML
    private VBox sparkDetectionVbox;
    private double dividerConsolePosition = 0.7;
    private double dividerDebugPosition = 0.7;

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        this.showConsoleMenuItem.selectedProperty().addListener((observableValue, bl, newValue) -> this.toggleConsole((boolean)newValue));
        this.toggleConsole(this.showConsoleMenuItem.isSelected());
        this.showDebugMenuItem.selectedProperty().addListener((observableValue, bl, newValue) -> this.toggleDebug((boolean)newValue));
        this.toggleDebug(this.showDebugMenuItem.isSelected());
        ConsoleLogger.bindConsole(this.console);
        SerialPortManager.register(this);
        SerialPortManager.startAutoConnect();
        this.setDetectionColor("vbox-disconnected");
        this.debugSendTextButton.disableProperty().bind(GlobalBindings.idleConnected.not().or(this.debugSendComboBox.getEditor().textProperty().isEmpty()));
        this.debugSendBytesButton.disableProperty().bind(GlobalBindings.idleConnected.not().or(GlobalBindings.invalidByteInput(this.debugSendComboBox.getEditor())));
    }

    private void toggleConsole(boolean show) {
        if (show) {
            if (!this.splitPaneConsole.getItems().contains(this.console)) {
                this.splitPaneConsole.getItems().add(this.console);
                this.splitPaneConsole.setDividerPositions(this.dividerConsolePosition);
            }
        } else {
            this.dividerConsolePosition = this.splitPaneConsole.getDividerPositions()[0];
            this.splitPaneConsole.getItems().remove(this.console);
        }
    }

    private void toggleDebug(boolean show) {
        if (show) {
            if (!this.splitPaneDebug.getItems().contains(this.debugVBox)) {
                this.splitPaneDebug.getItems().add(this.debugVBox);
                this.splitPaneDebug.setDividerPositions(this.dividerDebugPosition);
            }
        } else {
            this.dividerDebugPosition = this.splitPaneDebug.getDividerPositions()[0];
            this.splitPaneDebug.getItems().remove(this.debugVBox);
        }
    }

    @FXML
    private void clearDebugTextArea(ActionEvent event) {
        this.debugTextArea.clear();
        this.debugByteTextArea.clear();
    }

    @FXML
    private void sendDebugText(ActionEvent event) {
        if (Boolean.TRUE.equals(this.updateDebugComboBox())) {
            Helper.applyBorderColor(this.debugSendTextButton, SerialPortManager.sendBytes(((String)this.debugSendComboBox.getValue()).getBytes()));
        }
    }

    @FXML
    private void sendDebugBytes(ActionEvent event) {
        if (Boolean.TRUE.equals(this.updateDebugComboBox())) {
            String[] byteStrings = ((String)this.debugSendComboBox.getValue()).trim().split("\\s+");
            ArrayList<Byte> byteList = new ArrayList<Byte>();
            for (int i2 = 0; i2 < byteStrings.length; ++i2) {
                String byteString = byteStrings[i2];
                Integer byteValue = Helper.parseByte(byteString);
                if (byteValue == null) {
                    ConsoleLogger.warn("Not a number detected: " + byteString);
                    continue;
                }
                byteList.add(byteValue.byteValue());
            }
            byte[] byteArray = new byte[byteList.size()];
            for (int i3 = 0; i3 < byteList.size(); ++i3) {
                byteArray[i3] = (Byte)byteList.get(i3);
            }
            Helper.applyBorderColor(this.debugSendBytesButton, SerialPortManager.sendBytes(byteArray));
        }
    }

    private Boolean updateDebugComboBox() {
        String toSendValue = (String)this.debugSendComboBox.getValue();
        Boolean hasSomething = toSendValue != null && !toSendValue.trim().isEmpty();
        if (Boolean.TRUE.equals(hasSomething)) {
            this.debugSendComboBox.getItems().remove(toSendValue);
            this.debugSendComboBox.getItems().add(0, toSendValue);
            this.debugSendComboBox.setValue(toSendValue);
        }
        return hasSomething;
    }

    private void setDetectionColor(String styleClass) {
        if (!GlobalBindings.isPerformingAction()) {
            Platform.runLater(() -> {
                this.sparkDetectionVbox.getStyleClass().removeAll((String[])new String[]{"vbox-disconnected", "vbox-opening", "vbox-connected"});
                this.sparkDetectionVbox.getStyleClass().add(styleClass);
            });
        }
    }

    @Override
    public void onPortOpened(SerialPort serialPort) {
        this.setDetectionColor("vbox-connected");
    }

    @Override
    public void onPortOpening(SerialPort serialPort) {
        this.setDetectionColor("vbox-opening");
    }

    @Override
    public void onPortClosed() {
        this.setDetectionColor("vbox-disconnected");
    }

    @Override
    public void onPortWarning(String message) {
    }

    @Override
    public void onAutoConnectStarted() {
    }

    @Override
    public void onAutoConnectStopped() {
    }

    @Override
    public void onDataSent(byte[] data) {
    }

    @Override
    public void onDataReceived(byte[] data) {
        Platform.runLater(() -> {
            this.debugTextArea.appendText(new String(data, StandardCharsets.UTF_8));
            this.debugByteTextArea.appendText(Helper.bytesToHex(data) + "\n");
        });
    }
}

