/*
 * Decompiled with CFR 0.152.
 */
package fr.orpheo.controllers;

import fr.orpheo.FileResourcesManager;
import fr.orpheo.controllers.TestController;
import fr.orpheo.models.AlertBox;
import fr.orpheo.models.GlobalBindings;
import fr.orpheo.models.spark.SparkInitializer;
import fr.orpheo.models.spark.SparkInitializerEventListener;
import fr.orpheo.models.spark.protocol.groups.GroupType;
import fr.orpheo.models.tests.TestExecution;
import fr.orpheo.models.tests.TestRunner;
import fr.orpheo.stm32cli.Stm32CliEventListener;
import fr.orpheo.stm32cli.Stm32CliExecutor;
import fr.orpheo.tools.FatalManager;
import fr.orpheo.tools.Helper;
import fr.orpheo.tools.TaskManager;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.VBox;
import javafx.util.Duration;

public class ProgramController
implements Initializable,
Stm32CliEventListener,
SparkInitializerEventListener {
    private final LinkedHashMap<String, List<String>> hardVersionMap = new LinkedHashMap();
    @FXML
    private ComboBox<String> hardSfcardComboBox;
    @FXML
    private ComboBox<String> hardRevComboBox;
    @FXML
    private ComboBox<String> dateCodeYearComboBox;
    @FXML
    private ComboBox<String> dateCodeWeekComboBox;
    @FXML
    private ComboBox<String> setupVersionComboBox;
    @FXML
    private ComboBox<String> flowVersionComboBox;
    @FXML
    private VBox testVBox;
    @FXML
    private ProgressBar progressBarLocal;
    @FXML
    private ProgressBar progressBarGlobal;
    @FXML
    private Button flashSetupButton;
    @FXML
    private Button initButton;
    @FXML
    private Button flashFlowButton;
    @FXML
    private Button programButton;
    private static final long SETUP_INIT_DELAY = 100L;
    public final BooleanProperty protectUserFields = new SimpleBooleanProperty(false);
    private TestController testController;
    private static final float TEST_PART = 0.8f;
    private static final float PARAM_PART = 0.16f;
    private static final float SAVE_PART = 0.019999996f;

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        int i2;
        Stm32CliExecutor.register(this);
        SparkInitializer.register(this);
        this.hardSfcardComboBox.disableProperty().bind(this.protectUserFields);
        this.hardRevComboBox.disableProperty().bind(this.protectUserFields.or(this.hardSfcardComboBox.valueProperty().isNull()));
        this.dateCodeYearComboBox.disableProperty().bind(this.protectUserFields);
        this.dateCodeWeekComboBox.disableProperty().bind(this.protectUserFields);
        this.setupVersionComboBox.disableProperty().bind(this.protectUserFields);
        this.flowVersionComboBox.disableProperty().bind(this.protectUserFields);
        this.flashSetupButton.disableProperty().bind(GlobalBindings.idleConnected.not());
        this.flashFlowButton.disableProperty().bind(GlobalBindings.idleConnected.not());
        BooleanBinding userInputReady = this.hardSfcardComboBox.valueProperty().isNull().not().and(this.hardRevComboBox.valueProperty().isNull().not()).and(this.dateCodeYearComboBox.valueProperty().isNull().not()).and(this.dateCodeWeekComboBox.valueProperty().isNull().not());
        this.initButton.disableProperty().bind(GlobalBindings.idleConnected.not().or(userInputReady.not()));
        this.programButton.disableProperty().bind(GlobalBindings.idleConnected.not().or(userInputReady.not()));
        this.extractHardVersions();
        for (i2 = 0; i2 < 100; ++i2) {
            this.dateCodeYearComboBox.getItems().add(String.format("%02d", i2));
        }
        for (i2 = 1; i2 < 53; ++i2) {
            this.dateCodeWeekComboBox.getItems().add(String.format("%02d", i2));
        }
        this.extractSoftwareVersions();
        this.testController = new TestController(this.testVBox);
    }

    private void extractHardVersions() {
        Pattern hardPattern = Pattern.compile("(\\d+) REV (\\d+)");
        FileResourcesManager.getLinesFromResourceFile("spark/hard_versions.txt").forEach(line -> {
            Matcher matcher = hardPattern.matcher((CharSequence)line);
            if (matcher.find()) {
                String sfCardString = matcher.group(1);
                String revisionString = matcher.group(2);
                this.hardVersionMap.putIfAbsent(sfCardString, new ArrayList(1));
                this.hardVersionMap.get(sfCardString).add(revisionString);
            }
        });
        if (this.hardVersionMap.isEmpty()) {
            FatalManager.fatalError("No hard versions found.");
        }
        this.hardSfcardComboBox.getItems().addAll((Collection<String>)this.hardVersionMap.sequencedKeySet());
    }

    private void extractSoftwareVersions() {
        List<String> fileNames = FileResourcesManager.listFilesInResourceDirectory("STM32/Spark_binaries/");
        Map<Pattern, ComboBox<String>> patternToComboBox = Map.of(Pattern.compile("Spark_flow_software_(\\d+)_(\\d+)\\.elf"), this.flowVersionComboBox, Pattern.compile("Spark_setup_software_(\\d+)_(\\d+)\\.elf"), this.setupVersionComboBox);
        for (String fileName : fileNames) {
            patternToComboBox.forEach((pattern, comboBox) -> {
                Matcher matcher = pattern.matcher(fileName);
                if (matcher.find()) {
                    String version = matcher.group(1) + "." + matcher.group(2);
                    comboBox.getItems().addFirst(version);
                }
            });
        }
        patternToComboBox.forEach((pattern, comboBox) -> {
            if (comboBox.getItems().isEmpty()) {
                FatalManager.fatalError("No binaries for " + comboBox.getId());
            } else {
                comboBox.setValue((String)comboBox.getItems().getFirst());
            }
        });
    }

    @FXML
    private void flashSetup(ActionEvent event) {
        TaskManager.performLongAction(() -> Stm32CliExecutor.flashSpark(Stm32CliExecutor.SparkBinary.SETUP, (String)this.setupVersionComboBox.getValue()));
    }

    @FXML
    private void flashFlow(ActionEvent event) {
        TaskManager.performLongAction(() -> Stm32CliExecutor.flashSpark(Stm32CliExecutor.SparkBinary.FLOW, (String)this.flowVersionComboBox.getValue()));
    }

    @FXML
    private void initializeSpark(ActionEvent event) {
        TaskManager.performLongAction(() -> {
            this.protectUserFields.set(true);
            this.testController.clearRunner();
            SparkInitializer.initializeSpark((String)this.hardSfcardComboBox.getValue(), (String)this.hardRevComboBox.getValue(), (String)this.dateCodeYearComboBox.getValue(), (String)this.dateCodeWeekComboBox.getValue());
            this.protectUserFields.set(false);
        });
    }

    private void moveProgressBar(ProgressBar bar, double end) {
        double current = bar.getProgress();
        if (current == -1.0) {
            current = 0.0;
        }
        Timeline timeline = new Timeline(new KeyFrame(Duration.ZERO, new KeyValue(bar.progressProperty(), current)), new KeyFrame(Duration.millis(100.0), new KeyValue(bar.progressProperty(), end, Interpolator.EASE_BOTH)));
        timeline.play();
    }

    private void updateGlobalProgress(double progress) {
        Platform.runLater(() -> this.moveProgressBar(this.progressBarGlobal, progress));
    }

    private void updateLocalProgress(double progress) {
        Platform.runLater(() -> this.moveProgressBar(this.progressBarLocal, progress));
    }

    private void resetProgressAndExit() {
        this.updateGlobalProgress(0.0);
        this.protectUserFields.set(false);
    }

    @FXML
    private void programSpark(ActionEvent event) {
        TaskManager.performLongAction(() -> {
            this.protectUserFields.set(true);
            this.updateGlobalProgress(0.0);
            this.testController.clearRunner();
            if (!Stm32CliExecutor.flashSpark(Stm32CliExecutor.SparkBinary.SETUP, (String)this.setupVersionComboBox.getValue())) {
                this.resetProgressAndExit();
                return;
            }
            this.updateGlobalProgress(0.3333333432674408);
            Helper.delay(100L);
            if (!SparkInitializer.initializeSpark((String)this.hardSfcardComboBox.getValue(), (String)this.hardRevComboBox.getValue(), (String)this.dateCodeYearComboBox.getValue(), (String)this.dateCodeWeekComboBox.getValue())) {
                this.resetProgressAndExit();
                return;
            }
            this.updateGlobalProgress(0.6666666865348816);
            if (!Stm32CliExecutor.flashSpark(Stm32CliExecutor.SparkBinary.FLOW, (String)this.flowVersionComboBox.getValue())) {
                this.resetProgressAndExit();
                return;
            }
            this.updateGlobalProgress(1.0);
            AlertBox.display("Success", "Everything is OK!   \\(\u1d54\u1d55\u1d54)/");
            this.protectUserFields.set(false);
        });
    }

    @FXML
    private void updateRevComboBox(ActionEvent event) {
        this.hardRevComboBox.getItems().setAll((Collection<String>)this.hardVersionMap.get(this.hardSfcardComboBox.getValue()));
        this.hardRevComboBox.setValue(null);
    }

    @Override
    public void onFlashStarted(Stm32CliExecutor.SparkBinary binary) {
        this.updateLocalProgress(-1.0);
    }

    @Override
    public void onDownloadStarted(Stm32CliExecutor.SparkBinary binary) {
        this.updateLocalProgress(0.3333333432674408);
    }

    @Override
    public void onVerifyStarted(Stm32CliExecutor.SparkBinary binary) {
        this.updateLocalProgress(0.6666666865348816);
    }

    @Override
    public void onFlashSuccess(Stm32CliExecutor.SparkBinary binary) {
        this.updateLocalProgress(1.0);
    }

    @Override
    public void onFlashError(Stm32CliExecutor.SparkBinary binary, String message) {
        this.updateLocalProgress(0.0);
        AlertBox.display("Error", "Something wrong happend during Spark binary flash. Please try again.\nPlease see the details below:\n\t" + message);
    }

    @Override
    public void onInitStarted() {
        this.updateLocalProgress(0.0);
    }

    @Override
    public void onInitTestsLoaded(TestRunner runner) {
        Platform.runLater(() -> this.testController.addRunner(runner));
    }

    @Override
    public void onInitTestRan(TestExecution test, float advancement) {
        this.updateLocalProgress(advancement * 0.8f);
    }

    @Override
    public void onInitGroupSet(GroupType groupType, float advancement) {
        this.updateLocalProgress(advancement * 0.16f + 0.8f);
    }

    @Override
    public void onInitSaved() {
        this.updateLocalProgress(0.98f);
    }

    @Override
    public void onInitSuccess() {
        this.updateLocalProgress(1.0);
    }

    @Override
    public void onInitError(String message) {
        this.updateLocalProgress(0.0);
        AlertBox.display("Error", "Something wrong happend during Spark initialization. Please try again.\nPlease see the details below:\n\t" + message);
    }
}

