/*
 * Decompiled with CFR 0.152.
 */
package fr.orpheo.controllers;

import fr.orpheo.models.tests.TestExecution;
import fr.orpheo.models.tests.TestRunner;
import fr.orpheo.models.tests.TestRunnerEventListener;
import fr.orpheo.models.tests.TestStatus;
import java.util.HashMap;
import java.util.Map;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Circle;
import javafx.scene.shape.StrokeType;

public class TestController
implements TestRunnerEventListener {
    private final Pane testPane;
    private TestRunner runner;
    private final Map<TestExecution, Circle> indicatorsMap = new HashMap<TestExecution, Circle>();
    private static final Color RESET_COLOR = Color.CORNFLOWERBLUE;
    private static final Color PASSED_COLOR = Color.FORESTGREEN;
    private static final Color FAILED_COLOR = Color.CRIMSON;
    private static final Color ABORTED_COLOR = Color.ORANGERED;
    private static final Color STARTED_COLOR = Color.YELLOW;

    public TestController(Pane testPane) {
        this.testPane = testPane;
    }

    public void clearRunner() {
        if (this.runner != null) {
            this.runner.unregister(this);
            this.runner = null;
        }
        Platform.runLater(() -> this.testPane.getChildren().clear());
        this.indicatorsMap.clear();
    }

    public void addRunner(TestRunner runner) {
        this.clearRunner();
        Platform.runLater(() -> {
            for (TestExecution test : runner.getTests()) {
                this.createRow(test);
            }
        });
        runner.register(this);
    }

    private void createRow(TestExecution test) {
        HBox hbox = new HBox();
        hbox.setAlignment(Pos.CENTER);
        hbox.setSpacing(5.0);
        Circle mainCircle = new Circle(10.0);
        mainCircle.setStroke(Color.BLACK);
        mainCircle.setStrokeType(StrokeType.INSIDE);
        HBox.setMargin(mainCircle, new Insets(0.0, 10.0, 0.0, 10.0));
        Label label = new Label(test.getName());
        label.setAlignment(Pos.CENTER_RIGHT);
        label.setPrefWidth(100.0);
        hbox.getChildren().addAll((Node[])new Node[]{mainCircle, label});
        this.testPane.getChildren().add(hbox);
        this.indicatorsMap.put(test, mainCircle);
        this.setTestColor(test);
    }

    private void setTestColor(TestExecution test) {
        Circle indicator = this.indicatorsMap.get(test);
        if (indicator != null) {
            Color color = switch (test.getStatus()) {
                case TestStatus.STARTED -> STARTED_COLOR;
                case TestStatus.PASSED -> PASSED_COLOR;
                case TestStatus.FAILED -> FAILED_COLOR;
                case TestStatus.ABORTED -> ABORTED_COLOR;
                case TestStatus.RESET -> RESET_COLOR;
                default -> RESET_COLOR;
            };
            Platform.runLater(() -> indicator.setFill(color));
        }
    }

    @Override
    public void onTestChangedStatus(TestExecution test) {
        this.setTestColor(test);
    }
}

