/*
 * Decompiled with CFR 0.152.
 */
package fr.orpheo.models;

public class CircularByteBuffer {
    private final byte[] buffer;
    private int head = 0;
    private int tail = 0;
    private int count = 0;

    public CircularByteBuffer(int capacity) {
        this.buffer = new byte[capacity];
    }

    public synchronized void put(byte[] data) {
        for (byte b2 : data) {
            if (this.count == this.buffer.length) {
                this.tail = (this.tail + 1) % this.buffer.length;
            } else {
                ++this.count;
            }
            this.buffer[this.head] = b2;
            this.head = (this.head + 1) % this.buffer.length;
        }
    }

    public synchronized byte[] get(int startIndex, int length) {
        if (startIndex < 0 || length <= 0 || startIndex + length > this.count) {
            return new byte[0];
        }
        byte[] output = new byte[length];
        for (int i2 = 0; i2 < length; ++i2) {
            output[i2] = this.buffer[(this.tail + startIndex + i2) % this.buffer.length];
        }
        return output;
    }

    public synchronized int available() {
        return this.count;
    }

    public synchronized void clear() {
        this.head = 0;
        this.tail = 0;
        this.count = 0;
    }

    public synchronized void remove(int length) {
        if (length <= 0) {
            return;
        }
        int removeCount = Math.min(length, this.count);
        this.tail = (this.tail + removeCount) % this.buffer.length;
        this.count -= removeCount;
    }
}

