/*
 * Decompiled with CFR 0.152.
 */
package fr.orpheo.models;

import com.fazecast.jSerialComm.SerialPort;
import fr.orpheo.models.CircularByteBuffer;
import fr.orpheo.models.ConfigFrame;
import fr.orpheo.models.spark.protocol.ConfigProtocol;
import fr.orpheo.models.spark.protocol.ParamID;
import fr.orpheo.models.spark.protocol.actions.Action;
import fr.orpheo.models.spark.protocol.tests.TestDefinition;
import fr.orpheo.serial.SerialPortEventListener;
import fr.orpheo.serial.SerialPortManager;
import fr.orpheo.tools.ConsoleLogger;
import fr.orpheo.tools.Helper;

public class FrameSender
implements SerialPortEventListener {
    private static ConfigFrame currentFrame = null;
    private static final int DEFAULT_TIMEOUT = 300;
    private static final int BUFFER_SIZE = 4096;
    private static CircularByteBuffer circularBuffer = new CircularByteBuffer(4096);
    private static volatile boolean fillBuffer = false;

    private FrameSender() {
        SerialPortManager.register(this);
    }

    private static synchronized Integer send(ConfigFrame configFrame, Long timeout) {
        byte[] rawFrame = ConfigProtocol.formRawFrame(configFrame);
        currentFrame = configFrame;
        circularBuffer.clear();
        fillBuffer = true;
        if (!SerialPortManager.sendBytes(rawFrame)) {
            return null;
        }
        long timeoutMs = timeout != null ? timeout : 300L;
        long startTime = System.currentTimeMillis();
        Integer result = null;
        while (System.currentTimeMillis() - startTime < timeoutMs && (result = FrameSender.getReturnFromSpark()) == null) {
            Helper.delay(5L);
        }
        fillBuffer = false;
        if (result == null) {
            ConsoleLogger.error("Failed to send config frame: " + String.valueOf(configFrame) + " after " + timeoutMs + "ms");
        } else {
            ConsoleLogger.debug("Sent: " + String.valueOf(configFrame) + " ; Received: 0x" + String.format("%02X", result));
        }
        return result;
    }

    private static synchronized Integer getReturnFromSpark() {
        if (currentFrame == null) {
            return null;
        }
        int dataSize = ConfigProtocol.getDataSize();
        int available = circularBuffer.available();
        if (available < dataSize) {
            return null;
        }
        for (int i2 = available - dataSize; i2 >= 0; --i2) {
            byte[] rawData = circularBuffer.get(i2, dataSize);
            ConfigFrame receivedFrame = ConfigProtocol.decodeRawFrame(rawData);
            if (!currentFrame.correspondsTo(receivedFrame)) continue;
            return receivedFrame.getValue();
        }
        circularBuffer.remove(available - (dataSize - 1));
        return null;
    }

    public static synchronized Integer read(ParamID parameter) {
        if (parameter == null) {
            return null;
        }
        return FrameSender.send(new ConfigFrame(ConfigFrame.ReadWriteBit.READ, parameter.getAddress(), 0), null);
    }

    public static synchronized boolean write(ParamID parameter, int value) {
        return FrameSender.write(parameter, value, null);
    }

    public static synchronized boolean write(ParamID parameter, int value, Long timeout) {
        if (parameter == null) {
            return false;
        }
        Integer result = FrameSender.send(new ConfigFrame(ConfigFrame.ReadWriteBit.WRITE, parameter.getAddress(), value), timeout);
        return result != null && result == value;
    }

    public static synchronized boolean runTest(TestDefinition test) {
        return FrameSender.write(test.getTestID(), test.getNumber(), test.getTimeout());
    }

    public static synchronized boolean performAction(Action action) {
        return FrameSender.write(action.getActionID(), action.getNumber());
    }

    @Override
    public void onPortOpened(SerialPort serialPort) {
    }

    @Override
    public void onPortOpening(SerialPort serialPort) {
    }

    @Override
    public void onPortClosed() {
    }

    @Override
    public void onPortWarning(String message) {
    }

    @Override
    public void onAutoConnectStarted() {
    }

    @Override
    public void onAutoConnectStopped() {
    }

    @Override
    public void onDataSent(byte[] data) {
    }

    @Override
    public void onDataReceived(byte[] data) {
        if (fillBuffer) {
            circularBuffer.put(data);
        }
    }

    static {
        new FrameSender();
    }
}

