/*
 * Decompiled with CFR 0.152.
 */
package fr.orpheo.models;

import fr.orpheo.tools.Helper;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.control.TextField;

public class GlobalBindings {
    private static final BooleanProperty connected = new SimpleBooleanProperty(false);
    private static final BooleanProperty performingAction = new SimpleBooleanProperty(false);
    public static final BooleanBinding idleConnected = Bindings.createBooleanBinding(() -> connected.get() && !performingAction.get(), connected, performingAction);

    public static void setConnected(boolean value) {
        GlobalBindings.setSafe(connected, value);
    }

    public static void setPerformingAction(boolean value) {
        GlobalBindings.setSafe(performingAction, value);
    }

    private static void setSafe(BooleanProperty property, boolean value) {
        if (Platform.isFxApplicationThread()) {
            property.set(value);
        } else {
            Platform.runLater(() -> property.set(value));
        }
    }

    public static boolean isPerformingAction() {
        return performingAction.get();
    }

    public static BooleanBinding invalidByteInput(TextField editor) {
        return Bindings.createBooleanBinding(() -> {
            String[] parts;
            String text = editor.getText().trim();
            if (text.isEmpty()) {
                return true;
            }
            for (String part : parts = text.split("\\s+")) {
                if (Helper.parseByte(part) != null) continue;
                return true;
            }
            return false;
        }, editor.textProperty());
    }
}

