/*
 * Decompiled with CFR 0.152.
 */
package fr.orpheo.models;

import fr.orpheo.FileResourcesManager;
import fr.orpheo.tools.FatalManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ZoneIdMapping {
    private static final Map<Integer, Integer> rawToVisit = new HashMap<Integer, Integer>();
    private static final Map<Integer, Integer> visitToRaw = new HashMap<Integer, Integer>();

    private ZoneIdMapping() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static synchronized void extractList() {
        List<String> lines = FileResourcesManager.getLinesFromResourceFile("spark/visit_id_list.csv");
        for (int i2 = 1; i2 < lines.size(); ++i2) {
            String line = lines.get(i2);
            String[] parts = line.split(",");
            if (parts.length != 2) {
                FatalManager.fatalError("Invalid line format: " + line);
                continue;
            }
            try {
                String rawIdHex = parts[0].trim();
                if (!rawIdHex.startsWith("0X") && !rawIdHex.startsWith("0x")) {
                    throw new IllegalArgumentException("The Raw ID " + rawIdHex + " must start with \"0x\".");
                }
                int rawId = Integer.parseInt(rawIdHex.substring(2), 16);
                int visitId = Integer.parseInt(parts[1].trim());
                rawToVisit.put(rawId, visitId);
                visitToRaw.put(visitId, rawId);
                continue;
            }
            catch (Exception e2) {
                FatalManager.fatalError("Error parsing line: " + line + ". " + e2.getMessage());
            }
        }
    }

    public static int getRawId(int visitId) {
        return visitToRaw.getOrDefault(visitId, 0);
    }

    public static int getVisitId(int rawId) {
        return rawToVisit.getOrDefault(rawId, 0);
    }

    public static int getNumberOfExistingPOI() {
        return rawToVisit.size();
    }

    static {
        ZoneIdMapping.extractList();
    }
}

