/*
 * Decompiled with CFR 0.152.
 */
package fr.orpheo.models.spark;

import fr.orpheo.models.FrameSender;
import fr.orpheo.models.spark.SparkConfig;
import fr.orpheo.models.spark.SparkInitializerEventListener;
import fr.orpheo.models.spark.cards.Card;
import fr.orpheo.models.spark.protocol.ProtocolManager;
import fr.orpheo.models.spark.protocol.actions.ActionType;
import fr.orpheo.models.spark.protocol.groups.GroupRunner;
import fr.orpheo.models.spark.protocol.groups.GroupType;
import fr.orpheo.models.tests.TestExecution;
import fr.orpheo.models.tests.TestRunner;
import fr.orpheo.models.tests.TestRunnerEventListener;
import fr.orpheo.models.tests.TestStatus;
import fr.orpheo.serial.SerialPortManager;
import java.util.HashSet;
import java.util.Set;

public class SparkInitializer
implements TestRunnerEventListener {
    private static int numberofTestsRan = 0;
    private static int totalNumberOfTests = 0;
    private static int numberofParamSet = 0;
    private static final int totalNumberOfParams = 14;
    private static final SparkInitializer INSTANCE = new SparkInitializer();
    private static final Set<SparkInitializerEventListener> listeners = new HashSet<SparkInitializerEventListener>();

    private SparkInitializer() {
    }

    public static synchronized boolean initializeSpark(String hardSFCard, String hardRevision, String dateCodeYear, String dateCodeWeek) {
        SparkInitializer.notifyInitStarted();
        if (!SerialPortManager.isConnected()) {
            SparkInitializer.notifyInitError("Need to open the port before initialize");
            return false;
        }
        Card card = Card.getCardFromConfig();
        if (card == null) {
            SparkInitializer.notifyInitError("Failed to get card type");
            return false;
        }
        TestRunner testRunner = card.getTestRunner();
        SparkInitializer.notifyTestsLoaded(testRunner);
        numberofTestsRan = 0;
        totalNumberOfTests = testRunner.getNumberOfTests();
        testRunner.register(INSTANCE);
        boolean testResult = testRunner.runAllTests();
        testRunner.unregister(INSTANCE);
        if (!testResult) {
            SparkInitializer.notifyInitError("Tests failed!");
            return false;
        }
        if (!SparkInitializer.setAllParameters(hardSFCard, hardRevision, dateCodeYear, dateCodeWeek, card.getDefaultConfig())) {
            return false;
        }
        if (!FrameSender.performAction(ProtocolManager.getLatestProtocol().getActionFromType(ActionType.SAVE))) {
            SparkInitializer.notifyInitError("Failed to save...");
            return false;
        }
        SparkInitializer.notifySaved();
        SparkInitializer.notifyInitSuccess();
        return true;
    }

    private static boolean setAllParameters(String hardSFCard, String hardRevision, String dateCodeYear, String dateCodeWeek, SparkConfig defaultConfig) {
        numberofParamSet = 0;
        try {
            SparkInitializer.setGroup(GroupType.HARD_VERSION, hardSFCard + " REV " + hardRevision);
            SparkInitializer.setGroup(GroupType.DATE_CODE, dateCodeYear + dateCodeWeek);
            SparkInitializer.setGroup(GroupType.TEST_DATE, "Today");
            SparkInitializer.setGroup(GroupType.LED, defaultConfig.getLed());
            SparkInitializer.setGroup(GroupType.INTENSITY, defaultConfig.getIntensity());
            SparkInitializer.setGroup(GroupType.LATENCY, defaultConfig.getLatency());
            SparkInitializer.setGroup(GroupType.ZONE_ID, defaultConfig.getZoneID());
            SparkInitializer.setGroup(GroupType.OPENING_TIME, defaultConfig.getOpeningTime());
            SparkInitializer.setGroup(GroupType.CLOSING_TIME, defaultConfig.getClosingTime());
            SparkInitializer.setGroup(GroupType.ENABLE_EMISSION, defaultConfig.getEnableEmission());
            SparkInitializer.setGroup(GroupType.RS485_ISTERMINAL, defaultConfig.getRs485isTerminal());
            SparkInitializer.setGroup(GroupType.RS485_STRATEGY, defaultConfig.getRs485strategy());
            SparkInitializer.setGroup(GroupType.RS485_PARAMETER, defaultConfig.getRs485parameter());
            SparkInitializer.setGroup(GroupType.MODE, defaultConfig.getMode());
        }
        catch (RuntimeException e2) {
            SparkInitializer.notifyInitError(e2.getMessage());
            return false;
        }
        return true;
    }

    private static void setGroup(GroupType groupType, String value) {
        GroupRunner runner = new GroupRunner(ProtocolManager.getLatestProtocol().getGroupFromType(groupType));
        if (!runner.write(value)) {
            throw new RuntimeException("\tGroup " + String.valueOf(groupType) + " => FAILED");
        }
        SparkInitializer.notifyGroupSet(groupType, (float)(++numberofParamSet) / 14.0f);
    }

    @Override
    public void onTestChangedStatus(TestExecution test) {
        if (test.getStatus() != TestStatus.STARTED) {
            SparkInitializer.notifyTestRan(test, (float)(++numberofTestsRan) / (float)totalNumberOfTests);
        }
    }

    private static void notifyInitStarted() {
        listeners.forEach(listener -> listener.onInitStarted());
    }

    private static void notifyTestsLoaded(TestRunner runner) {
        listeners.forEach(listener -> listener.onInitTestsLoaded(runner));
    }

    private static void notifyTestRan(TestExecution test, float advancement) {
        listeners.forEach(listener -> listener.onInitTestRan(test, advancement));
    }

    private static void notifyGroupSet(GroupType groupType, float advancement) {
        listeners.forEach(listener -> listener.onInitGroupSet(groupType, advancement));
    }

    private static void notifySaved() {
        listeners.forEach(listener -> listener.onInitSaved());
    }

    private static void notifyInitSuccess() {
        listeners.forEach(listener -> listener.onInitSuccess());
    }

    private static void notifyInitError(String message) {
        listeners.forEach(listener -> listener.onInitError(message));
    }

    public static void register(SparkInitializerEventListener listener) {
        listeners.add(listener);
    }

    public static void unregister(SparkInitializerEventListener listener) {
        listeners.remove(listener);
    }
}

