/*
 * Decompiled with CFR 0.152.
 */
package fr.orpheo.models.spark.cards;

import fr.orpheo.models.FrameSender;
import fr.orpheo.models.spark.SparkConfig;
import fr.orpheo.models.spark.cards.CardMaxi;
import fr.orpheo.models.spark.cards.CardMini;
import fr.orpheo.models.spark.protocol.ParamID;
import fr.orpheo.models.spark.protocol.ProtocolManager;
import fr.orpheo.models.spark.protocol.groups.GroupType;
import fr.orpheo.models.tests.TestRunner;

public abstract class Card {
    public static Card getCardFromConfig() {
        ParamID cardID = ProtocolManager.getLatestProtocol().getGroupFromType(GroupType.CARD).getParamIDs().get(0);
        Integer cardNumber = FrameSender.read(cardID);
        if (cardNumber == null) {
            return null;
        }
        return switch (cardNumber) {
            case 0 -> new CardMaxi();
            case 1 -> new CardMini();
            default -> null;
        };
    }

    protected abstract String getDefaultLed();

    public SparkConfig getDefaultConfig() {
        return new SparkConfig(this.getDefaultLed(), "0", "1 s", "1", "07h00", "18h00", "Disabled", "Enabled", "Protocol V5", "1", "Satellite");
    }

    public abstract TestRunner getTestRunner();
}

