/*
 * Decompiled with CFR 0.152.
 */
package fr.orpheo.models.spark.protocol;

import fr.orpheo.models.ConfigFrame;
import fr.orpheo.models.spark.protocol.ProtocolManager;
import fr.orpheo.models.spark.protocol.TypeMapping;
import fr.orpheo.models.spark.protocol.actions.Action;
import fr.orpheo.models.spark.protocol.actions.ActionType;
import fr.orpheo.models.spark.protocol.groups.Group;
import fr.orpheo.models.spark.protocol.groups.GroupType;
import fr.orpheo.models.spark.protocol.tests.TestDefinition;
import fr.orpheo.models.spark.protocol.tests.TestType;

public abstract class ConfigProtocol {
    private static final int DATA_SIZE = 3;
    private final int version;
    protected final TypeMapping<GroupType, Group> groups = new TypeMapping();
    protected final TypeMapping<ActionType, Action> actions = new TypeMapping();
    protected final TypeMapping<TestType, TestDefinition> tests = new TypeMapping();

    protected ConfigProtocol(int version) {
        this.version = version;
        ProtocolManager.registerProtocol(this);
    }

    public int getVersion() {
        return this.version;
    }

    public Group getGroupFromType(GroupType type) {
        return this.groups.get(type);
    }

    public Action getActionFromType(ActionType type) {
        return this.actions.get(type);
    }

    public TestDefinition getTestFromType(TestType type) {
        return this.tests.get(type);
    }

    public static int getDataSize() {
        return 3;
    }

    private static byte pearsonHash(byte[] message, int len) {
        int[] lookupTable = new int[]{188, 234, 117, 208, 170, 224, 227, 0, 202, 205, 239, 171, 165, 127, 184, 105, 249, 77, 149, 169, 101, 126, 141, 226, 237, 129, 220, 5, 142, 81, 104, 45, 24, 91, 12, 143, 157, 137, 10, 115, 19, 89, 60, 121, 33, 43, 233, 72, 207, 147, 146, 99, 71, 27, 211, 116, 39, 110, 8, 240, 153, 120, 95, 69, 86, 185, 35, 132, 18, 243, 218, 34, 79, 46, 16, 11, 102, 232, 113, 131, 148, 160, 228, 15, 73, 125, 182, 84, 154, 210, 203, 151, 179, 221, 41, 162, 114, 134, 247, 168, 100, 107, 4, 195, 206, 145, 163, 212, 63, 135, 25, 59, 214, 245, 109, 122, 20, 159, 231, 172, 29, 2, 253, 213, 189, 190, 6, 112, 158, 32, 1, 199, 175, 248, 51, 238, 235, 152, 225, 66, 139, 3, 92, 193, 50, 174, 70, 58, 57, 67, 40, 17, 136, 222, 7, 128, 14, 78, 49, 68, 209, 26, 87, 130, 124, 241, 36, 48, 178, 156, 118, 22, 9, 150, 194, 133, 55, 82, 219, 111, 98, 180, 181, 37, 76, 216, 144, 52, 28, 103, 187, 244, 21, 167, 166, 176, 53, 30, 204, 47, 200, 251, 223, 255, 186, 183, 201, 80, 215, 93, 177, 44, 164, 217, 38, 13, 85, 155, 119, 252, 138, 254, 242, 161, 83, 31, 106, 140, 94, 65, 230, 197, 97, 108, 74, 64, 42, 236, 250, 246, 75, 54, 56, 229, 191, 62, 88, 90, 123, 192, 96, 61, 196, 198, 173, 23};
        byte result = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            result = (byte)lookupTable[(result ^ message[i2]) & 0xFF];
        }
        return result;
    }

    public static byte[] formRawFrame(ConfigFrame configFrame) {
        int readWriteBitValue = configFrame.getReadWriteBit() == ConfigFrame.ReadWriteBit.READ ? 1 : 0;
        byte[] rawFrame = new byte[]{(byte)(readWriteBitValue << 7 | configFrame.getAddress() & 0x3F), (byte)configFrame.getValue(), 0};
        rawFrame[2] = ConfigProtocol.pearsonHash(rawFrame, 2);
        return rawFrame;
    }

    public static ConfigFrame decodeRawFrame(byte[] rawFrame) {
        if (rawFrame.length == 3 && ConfigProtocol.pearsonHash(rawFrame, 2) == rawFrame[2]) {
            int firstByte = rawFrame[0] & 0xFF;
            ConfigFrame.ReadWriteBit readWriteBit = (firstByte & 0x80) != 0 ? ConfigFrame.ReadWriteBit.READ : ConfigFrame.ReadWriteBit.WRITE;
            int address = firstByte & 0x3F;
            int value = rawFrame[1] & 0xFF;
            return new ConfigFrame(readWriteBit, address, value);
        }
        return null;
    }

    public String toString() {
        return "Config Protocol V" + this.version;
    }
}

